/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.roundalib.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.roundaround.armorstands.roundalib.client.gui.util.Coords;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_6383;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_9017;

@Environment(value=EnvType.CLIENT)
public class ResponsiveGridWidget
extends class_9017
implements class_8133 {
    private final List<CellWidget<?>> cells = new ArrayList();
    private final List<class_8021> widgets = new ArrayList<class_8021>();
    private final class_7847 cellPositioner = class_7847.method_46481();
    private final Axis flowAxis;
    private int columnWidth;
    private int rowHeight;
    private int rowSpacing = 4;
    private int columnSpacing = 4;
    private Float relative = null;
    private int contentHeight = 0;

    public ResponsiveGridWidget(int n, int n2, int n3, int n4) {
        this(0, 0, n, n2, n3, n4, Axis.HORIZONTAL);
    }

    public ResponsiveGridWidget(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, Axis.HORIZONTAL);
    }

    public ResponsiveGridWidget(int n, int n2, int n3, int n4, Axis axis) {
        this(0, 0, n, n2, n3, n4, axis);
    }

    public ResponsiveGridWidget(int n, int n2, int n3, int n4, int n5, int n6, Axis axis) {
        super(n, n2, n3, n4, class_5244.field_39003);
        this.columnWidth = n5;
        this.rowHeight = n6;
        this.flowAxis = axis;
    }

    public List<? extends class_364> method_25396() {
        return this.widgets.stream().filter(class_80212 -> class_80212 instanceof class_364).map(class_80212 -> (class_364)class_80212).toList();
    }

    public void method_48227(Consumer<class_8021> consumer) {
        this.widgets.forEach(consumer);
    }

    public void method_48222() {
        int n = this.getMaxCountForMainAxis();
        int n2 = 0;
        int n3 = 0;
        Coords coords = this.getCenteredOffset();
        int n4 = 0;
        for (CellWidget<?> cellWidget : this.cells) {
            int n5 = this.flowAxis == Axis.HORIZONTAL ? n2 : n3;
            int n6 = this.flowAxis == Axis.HORIZONTAL ? n3 : n2;
            n4 = Math.max(n4, n6);
            cellWidget.setPosition(this.calcPosX(n5) + coords.x(), this.calcPosY(n6) + coords.y(), this.columnWidth, this.rowHeight);
            if (++n2 <= n - 1) continue;
            n2 = 0;
            ++n3;
        }
        super.method_48222();
        this.contentHeight = n4 * (this.rowHeight + this.rowSpacing) + this.rowSpacing;
    }

    protected int method_44395() {
        return this.contentHeight;
    }

    protected double method_44393() {
        return (double)(this.rowHeight + this.rowSpacing) / 2.0;
    }

    private int getMaxCountForMainAxis() {
        return switch (this.flowAxis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (this.field_22758 + this.columnSpacing) / (this.columnWidth + this.columnSpacing);
            case 1 -> (this.field_22759 + this.rowSpacing) / (this.rowHeight + this.rowSpacing);
        };
    }

    private Coords getCenteredOffset() {
        if (this.relative == null) {
            return Coords.zero();
        }
        int n = this.getMaxCountForMainAxis();
        int n2 = Math.min(n, this.cells.size());
        if (n2 <= 0) {
            return Coords.zero();
        }
        int n3 = this.flowAxis == Axis.HORIZONTAL ? this.columnWidth : this.rowHeight;
        int n4 = this.flowAxis == Axis.HORIZONTAL ? this.columnSpacing : this.rowSpacing;
        int n5 = n2 * n3 + (n2 - 1) * n4;
        int n6 = this.flowAxis == Axis.HORIZONTAL ? this.field_22758 : this.field_22759;
        int n7 = (int)((float)(n6 - n5) * this.relative.floatValue());
        return this.flowAxis == Axis.HORIZONTAL ? Coords.of(n7, 0) : Coords.of(0, n7);
    }

    private int calcPosX(int n) {
        return this.method_46426() + n * (this.columnWidth + this.columnSpacing);
    }

    private int calcPosY(int n) {
        return this.method_46427() + n * (this.rowHeight + this.rowSpacing);
    }

    protected void method_47399(class_6382 class_63822) {
        this.widgets.forEach(class_80212 -> {
            if (class_80212 instanceof class_6383) {
                class_6383 class_63832 = (class_6383)class_80212;
                class_63832.method_37020(class_63822);
            }
        });
    }

    protected void method_48579(class_332 class_3322, int n, int n2, float f) {
        this.widgets.forEach(class_80212 -> {
            if (class_80212 instanceof class_4068) {
                class_4068 class_40682 = (class_4068)class_80212;
                class_40682.method_25394(class_3322, n, n2, f);
            }
        });
    }

    public ResponsiveGridWidget rowSpacing(int n) {
        this.rowSpacing = n;
        return this;
    }

    public ResponsiveGridWidget columnSpacing(int n) {
        this.columnSpacing = n;
        return this;
    }

    public ResponsiveGridWidget spacing(int n) {
        this.rowSpacing = n;
        this.columnSpacing = n;
        return this;
    }

    public ResponsiveGridWidget alignedStart() {
        return this.aligned(0.0f);
    }

    public ResponsiveGridWidget centered() {
        return this.aligned(0.5f);
    }

    public ResponsiveGridWidget alignedEnd() {
        return this.aligned(1.0f);
    }

    public ResponsiveGridWidget aligned(float f) {
        this.relative = Float.valueOf(f);
        return this;
    }

    public void setColumnWidth(int n) {
        this.columnWidth = n;
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
    }

    public void setCellDimensions(int n, int n2) {
        this.columnWidth = n;
        this.rowHeight = n2;
    }

    public class_7847 copyCellPositioner() {
        return this.cellPositioner.method_46478();
    }

    public class_7847 getCellPositioner() {
        return this.cellPositioner;
    }

    public <T extends class_8021> CellWidget<T> add(T t) {
        return this.add(t, this.copyCellPositioner());
    }

    public <T extends class_8021> CellWidget<T> add(T t, Consumer<class_7847> consumer) {
        return this.add(t, (class_7847)class_156.method_654((Object)this.copyCellPositioner(), consumer));
    }

    public <T extends class_8021> CellWidget<T> add(T t, class_7847 class_78472) {
        this.widgets.add(t);
        CellWidget<T> cellWidget = new CellWidget<T>(t, class_78472);
        this.cells.add(cellWidget);
        return cellWidget;
    }

    public void clear() {
        this.widgets.clear();
        this.cells.clear();
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Axis {
        HORIZONTAL,
        VERTICAL;

    }

    @Environment(value=EnvType.CLIENT)
    public static class CellWidget<T extends class_8021> {
        private final T child;
        private final class_7847.class_7848 positioner;

        public CellWidget(T t, class_7847 class_78472) {
            this.child = t;
            this.positioner = class_78472.method_46480();
        }

        public T getChild() {
            return this.child;
        }

        public void setPosition(int n, int n2, int n3, int n4) {
            int n5 = this.positioner.field_40778;
            int n6 = n + n3 - this.child.method_25368() - this.positioner.field_40780;
            int n7 = class_3532.method_48781((float)this.positioner.field_40782, (int)n5, (int)n6);
            int n8 = this.positioner.field_40779;
            int n9 = n2 + n4 - this.child.method_25364() - this.positioner.field_40781;
            int n10 = class_3532.method_48781((float)this.positioner.field_40783, (int)n8, (int)n9);
            this.child.method_48229(n + n7, n2 + n10);
            T t = this.child;
            if (t instanceof class_8133) {
                class_8133 class_81332 = (class_8133)t;
                class_81332.method_48222();
            }
        }
    }
}

