/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.util;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.roundaround.armorstands.ArmorStandsMod;
import me.roundaround.armorstands.util.Pose;
import me.roundaround.armorstands.util.SavedPose;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1531;
import net.minecraft.class_3518;

public class PoseStorage {
    private static final File FILE = FabricLoader.getInstance().getGameDir().resolve("armorstandsposes.json").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final HashMap<UUID, SavedPose> map = new HashMap();

    public static void add(String string, class_1531 class_15312) {
        PoseStorage.add(string, new Pose(class_15312));
    }

    public static void add(String string, Pose pose) {
        UUID uUID = UUID.randomUUID();
        try {
            map.put(uUID, new SavedPose(string, pose));
            PoseStorage.save();
        }
        catch (IOException iOException) {
            map.remove(uUID);
            ArmorStandsMod.LOGGER.error((Object)iOException);
        }
    }

    public static void rename(UUID uUID, String string) {
        try {
            SavedPose savedPose = map.get(uUID);
            if (savedPose == null) {
                return;
            }
            map.put(uUID, new SavedPose(string, savedPose.toPose()));
            PoseStorage.save();
        }
        catch (IOException iOException) {
            ArmorStandsMod.LOGGER.error((Object)iOException);
        }
    }

    public static void remove(UUID uUID) {
        try {
            map.remove(uUID);
            PoseStorage.save();
        }
        catch (IOException iOException) {
            ArmorStandsMod.LOGGER.error((Object)iOException);
        }
    }

    public static void reload() {
        try {
            PoseStorage.load();
        }
        catch (IOException iOException) {
            ArmorStandsMod.LOGGER.error((Object)iOException);
        }
    }

    public static Map<UUID, SavedPose> getPoses() {
        return Map.copyOf(map);
    }

    private static void save() throws IOException {
        JsonArray jsonArray = new JsonArray();
        map.values().stream().map(SavedPose::toJson).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        try (BufferedWriter bufferedWriter = Files.newWriter((File)FILE, (Charset)StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)jsonArray, (Appendable)bufferedWriter);
        }
    }

    private static void load() throws IOException {
        if (!FILE.exists()) {
            return;
        }
        try (BufferedReader bufferedReader = Files.newReader((File)FILE, (Charset)StandardCharsets.UTF_8);){
            map.clear();
            JsonArray jsonArray = (JsonArray)GSON.fromJson((Reader)bufferedReader, JsonArray.class);
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonElement, (String)"entry");
                map.put(UUID.randomUUID(), SavedPose.fromJson(jsonObject));
            }
        }
    }
}

