/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.widget;

import java.util.Optional;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.network.ClientNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_437;
import net.minecraft.class_6880;

public class RotateSliderWidget
extends class_357 {
    private final AbstractArmorStandScreen parent;
    private final class_1531 armorStand;
    private Optional<Float> lastAngle = Optional.empty();
    private int min = -180;
    private int max = 180;
    private Optional<Long> lastScroll = Optional.empty();
    private boolean isDragging = false;
    private boolean pendingDragPing = false;

    public RotateSliderWidget(AbstractArmorStandScreen abstractArmorStandScreen, int n, int n2, class_1531 class_15312) {
        super(0, 0, n, n2, (class_2561)class_2561.method_43473(), 0.0);
        this.parent = abstractArmorStandScreen;
        this.armorStand = class_15312;
        this.refresh();
    }

    public boolean isPending(class_437 class_4372) {
        return this.isDragging() || this.lastScroll.isPresent();
    }

    public void setRange(int n, int n2) {
        this.min = n;
        this.max = n2;
        this.refresh();
    }

    public void refresh() {
        float f = this.armorStand.method_36454();
        if (this.lastAngle.isPresent() && Math.abs(f - this.lastAngle.get().floatValue()) < 1.0E-5f) {
            return;
        }
        this.lastAngle = Optional.of(Float.valueOf(f));
        this.setAngle(f);
    }

    public void zero() {
        this.setAngle(0.0f);
        this.persistValue();
    }

    public void increment() {
        double d = Math.ceil(this.getAngle());
        if (d - (double)this.getAngle() < (double)1.0E-5f) {
            d += 1.0;
        }
        this.setAngle((float)d);
        this.persistValue();
    }

    public void decrement() {
        double d = Math.floor(this.getAngle());
        if ((double)this.getAngle() - d < (double)1.0E-5f) {
            d -= 1.0;
        }
        this.setAngle((float)d);
        this.persistValue();
    }

    public void tick() {
        this.lastScroll.ifPresent(l -> {
            if (System.currentTimeMillis() - l > 500L) {
                this.lastScroll = Optional.empty();
                this.persistValue();
            }
        });
    }

    public boolean isDragging() {
        return this.isDragging || this.pendingDragPing;
    }

    public void onPong() {
        this.pendingDragPing = false;
    }

    protected void method_25346() {
        this.method_25355((class_2561)class_2561.method_43469((String)"armorstands.angle", (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.getAngle()))}));
    }

    protected void method_25344() {
        this.armorStand.method_36456(this.getAngle());
    }

    public void method_25348(double d, double d2) {
        super.method_25348(d, d2);
        this.isDragging = true;
    }

    public void method_25357(double d, double d2) {
        super.method_25357(d, d2);
        this.isDragging = false;
        this.pendingDragPing = true;
        this.parent.sendPing();
        this.persistValue();
    }

    public boolean method_25401(double d, double d2, double d3, double d4) {
        if (this.method_25405(d, d2)) {
            this.setAngle(this.getAngle() + (float)d4);
            this.method_25344();
            this.lastScroll = Optional.of(System.currentTimeMillis());
            return true;
        }
        return super.method_25401(d, d2, d3, d4);
    }

    protected void method_25349(double d, double d2, double d3, double d4) {
        this.isDragging = true;
        super.method_25349(d, d2, d3, d4);
    }

    public void method_25354(class_1144 class_11442) {
        class_11442.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    private float getAngle() {
        return RotateSliderWidget.valueToAngle(this.field_22753, this.min, this.max);
    }

    public void setAngle(float f) {
        this.setValue(RotateSliderWidget.angleToValue(f, this.min, this.max));
    }

    private void setValue(double d) {
        this.field_22753 = class_3532.method_15350((double)d, (double)0.0, (double)1.0);
        this.method_25346();
    }

    private static double angleToValue(float f, int n, int n2) {
        return (f - (float)n) / (float)(n2 - n);
    }

    private static float valueToAngle(double d, int n, int n2) {
        return (float)(d * (double)(n2 - n) + (double)n);
    }

    private void persistValue() {
        this.lastScroll = Optional.empty();
        ClientNetworking.sendSetYawPacket(this.getAngle());
    }
}

