/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.gui.widget.RotateSliderWidget;
import me.roundaround.armorstands.client.network.ClientNetworking;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.UtilityAction;
import me.roundaround.armorstands.roundalib.client.gui.icon.BuiltinIcon;
import me.roundaround.armorstands.roundalib.client.gui.layout.FillerWidget;
import me.roundaround.armorstands.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.armorstands.roundalib.client.gui.util.Spacing;
import me.roundaround.armorstands.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.HorizontalLineWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.LabelWidget;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public class ArmorStandRotateScreen
extends AbstractArmorStandScreen {
    private static final int BUTTON_WIDTH = 46;
    private static final int DIRECTION_BUTTON_WIDTH = 70;
    private static final int MINI_BUTTON_WIDTH = 24;
    private static final int SLIDER_WIDTH = 102;
    private LabelWidget playerFacingLabel;
    private LabelWidget playerRotationLabel;
    private LabelWidget standFacingLabel;
    private LabelWidget standRotationLabel;
    private RotateSliderWidget rotateSlider;

    public ArmorStandRotateScreen(ArmorStandScreenHandler armorStandScreenHandler) {
        super(armorStandScreenHandler, ScreenType.ROTATE.getDisplayName());
        this.supportsUndoRedo = true;
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.ROTATE;
    }

    @Override
    protected void populateLayout() {
        super.populateLayout();
        this.initTopLeft();
        this.initBottomLeft();
        this.initBottomRight();
    }

    private void initTopLeft() {
        LinearLayoutWidget linearLayoutWidget = LinearLayoutWidget.vertical().spacing(12).defaultOffAxisContentAlignStart();
        LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.vertical().spacing(1).defaultOffAxisContentAlignStart();
        linearLayoutWidget2.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.current.player")).bgColor(BACKGROUND_COLOR).build());
        this.playerFacingLabel = linearLayoutWidget2.add(LabelWidget.builder(this.field_22793, ArmorStandRotateScreen.getCurrentFacingText((class_1297)this.getPlayer())).bgColor(BACKGROUND_COLOR).build());
        this.playerRotationLabel = linearLayoutWidget2.add(LabelWidget.builder(this.field_22793, ArmorStandRotateScreen.getCurrentRotationText((class_1297)this.getPlayer())).bgColor(BACKGROUND_COLOR).build());
        linearLayoutWidget.add(linearLayoutWidget2);
        LinearLayoutWidget linearLayoutWidget3 = LinearLayoutWidget.vertical().spacing(1).defaultOffAxisContentAlignStart();
        linearLayoutWidget3.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.current.stand")).bgColor(BACKGROUND_COLOR).build());
        this.standFacingLabel = linearLayoutWidget3.add(LabelWidget.builder(this.field_22793, ArmorStandRotateScreen.getCurrentFacingText((class_1297)this.getArmorStand())).bgColor(BACKGROUND_COLOR).build());
        this.standRotationLabel = linearLayoutWidget3.add(LabelWidget.builder(this.field_22793, ArmorStandRotateScreen.getCurrentRotationText((class_1297)this.getArmorStand())).bgColor(BACKGROUND_COLOR).build());
        linearLayoutWidget.add(linearLayoutWidget3);
        this.layout.topLeft.add(new HorizontalLineWidget(this.utilRow.method_25368() - 8).margin(12), linearLayoutCellConfigurator -> linearLayoutCellConfigurator.margin(Spacing.of(0, 0, 0, 4)));
        this.layout.topLeft.add(linearLayoutWidget);
    }

    private void initBottomLeft() {
        LinearLayoutWidget linearLayoutWidget = LinearLayoutWidget.vertical().spacing(2).defaultOffAxisContentAlignStart();
        linearLayoutWidget.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.rotate.snap")).bgColor(BACKGROUND_COLOR).build());
        LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.horizontal().spacing(2);
        linearLayoutWidget2.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)("armorstands.rotate.snap." + class_2350.field_11035.method_10151())), class_41852 -> ClientNetworking.sendSetYawPacket(class_3532.method_15393((float)class_2350.field_11035.method_10144()))).method_46437(70, 16).method_46431());
        linearLayoutWidget2.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)("armorstands.rotate.snap." + class_2350.field_11043.method_10151())), class_41852 -> ClientNetworking.sendSetYawPacket(class_3532.method_15393((float)class_2350.field_11043.method_10144()))).method_46437(70, 16).method_46431());
        linearLayoutWidget.add(linearLayoutWidget2);
        LinearLayoutWidget linearLayoutWidget3 = LinearLayoutWidget.horizontal().spacing(2);
        linearLayoutWidget3.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)("armorstands.rotate.snap." + class_2350.field_11034.method_10151())), class_41852 -> ClientNetworking.sendSetYawPacket(class_3532.method_15393((float)class_2350.field_11034.method_10144()))).method_46437(70, 16).method_46431());
        linearLayoutWidget3.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)("armorstands.rotate.snap." + class_2350.field_11039.method_10151())), class_41852 -> ClientNetworking.sendSetYawPacket(class_3532.method_15393((float)class_2350.field_11039.method_10144()))).method_46437(70, 16).method_46431());
        linearLayoutWidget.add(linearLayoutWidget3);
        this.layout.bottomLeft.add(linearLayoutWidget);
        LinearLayoutWidget linearLayoutWidget4 = LinearLayoutWidget.vertical().spacing(2).defaultOffAxisContentAlignStart();
        linearLayoutWidget4.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.rotate.face")).bgColor(BACKGROUND_COLOR).build());
        LinearLayoutWidget linearLayoutWidget5 = LinearLayoutWidget.horizontal().spacing(2);
        linearLayoutWidget5.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.rotate.face.toward"), class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.FACE_TOWARD)).method_46437(46, 16).method_46431());
        linearLayoutWidget5.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.rotate.face.away"), class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.FACE_AWAY)).method_46437(46, 16).method_46431());
        linearLayoutWidget5.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.rotate.face.with"), class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.FACE_WITH)).method_46437(46, 16).method_46431());
        linearLayoutWidget4.add(linearLayoutWidget5);
        this.layout.bottomLeft.add(linearLayoutWidget4, linearLayoutCellConfigurator -> linearLayoutCellConfigurator.margin(Spacing.of(4, 0, 0, 0)));
    }

    private void initBottomRight() {
        this.layout.bottomRight.spacing(8);
        this.initRotateRow(RotateDirection.CLOCKWISE);
        this.initRotateRow(RotateDirection.COUNTERCLOCKWISE);
        this.layout.bottomRight.add(FillerWidget.ofHeight(8));
        LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.vertical().spacing(2).defaultOffAxisContentAlignEnd();
        LinearLayoutWidget linearLayoutWidget3 = LinearLayoutWidget.horizontal().defaultOffAxisContentAlignEnd().spacing(2);
        linearLayoutWidget3.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.rotate")).bgColor(BACKGROUND_COLOR).build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(102 - 3 * (16 + linearLayoutWidget.getSpacing())));
        linearLayoutWidget3.add(IconButtonWidget.builder(BuiltinIcon.MINUS_13, "armorstands").dimensions(16).onPress(class_41852 -> this.rotateSlider.decrement()).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.rotate.subtract"))).build());
        linearLayoutWidget3.add(IconButtonWidget.builder(BuiltinIcon.PLUS_13, "armorstands").dimensions(16).onPress(class_41852 -> this.rotateSlider.increment()).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.rotate.add"))).build());
        linearLayoutWidget3.add(IconButtonWidget.builder(BuiltinIcon.ROTATE_13, "armorstands").dimensions(16).onPress(class_41852 -> this.rotateSlider.zero()).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.rotate.zero"))).build());
        linearLayoutWidget2.add(linearLayoutWidget3);
        this.rotateSlider = linearLayoutWidget2.add(new RotateSliderWidget(this, 102, 16, this.getArmorStand()));
        this.layout.bottomRight.add(linearLayoutWidget2);
    }

    private void initRotateRow(RotateDirection rotateDirection) {
        LinearLayoutWidget linearLayoutWidget = LinearLayoutWidget.vertical().spacing(2).defaultOffAxisContentAlignEnd();
        linearLayoutWidget.add(LabelWidget.builder(this.field_22793, rotateDirection.getLabel()).bgColor(BACKGROUND_COLOR).build());
        LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.horizontal().spacing(2).defaultOffAxisContentAlignCenter();
        String string = rotateDirection.getModifier();
        linearLayoutWidget2.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)(string + "1")), class_41852 -> ClientNetworking.sendAdjustYawPacket(rotateDirection.offset())).method_46437(24, 16).method_46431());
        linearLayoutWidget2.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)(string + "5")), class_41852 -> ClientNetworking.sendAdjustYawPacket(rotateDirection.offset() * 5)).method_46437(24, 16).method_46431());
        linearLayoutWidget2.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)(string + "15")), class_41852 -> ClientNetworking.sendAdjustYawPacket(rotateDirection.offset() * 15)).method_46437(24, 16).method_46431());
        linearLayoutWidget2.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)(string + "45")), class_41852 -> ClientNetworking.sendAdjustYawPacket(rotateDirection.offset() * 45)).method_46437(24, 16).method_46431());
        linearLayoutWidget.add(linearLayoutWidget2);
        this.layout.bottomRight.add(linearLayoutWidget);
    }

    @Override
    public void method_37432() {
        super.method_37432();
        this.playerFacingLabel.setText(ArmorStandRotateScreen.getCurrentFacingText((class_1297)this.getPlayer()));
        this.playerRotationLabel.setText(ArmorStandRotateScreen.getCurrentRotationText((class_1297)this.getPlayer()));
        this.standFacingLabel.setText(ArmorStandRotateScreen.getCurrentFacingText((class_1297)this.getArmorStand()));
        this.standRotationLabel.setText(ArmorStandRotateScreen.getCurrentRotationText((class_1297)this.getArmorStand()));
        this.rotateSlider.tick();
    }

    @Override
    public void updateYawOnClient(float f) {
        if (this.rotateSlider != null && this.rotateSlider.isPending((class_437)this)) {
            return;
        }
        super.updateYawOnClient(f);
        if (this.rotateSlider != null) {
            this.rotateSlider.setAngle(f);
        }
    }

    @Override
    public void onPong() {
        super.onPong();
        if (this.rotateSlider != null) {
            this.rotateSlider.onPong();
        }
    }

    public static enum RotateDirection {
        CLOCKWISE(1, "armorstands.rotate.clockwise"),
        COUNTERCLOCKWISE(-1, "armorstands.rotate.counter");

        private final int offset;
        private final class_2561 label;

        private RotateDirection(int n2, String string2) {
            this.offset = n2;
            this.label = class_2561.method_43471((String)string2);
        }

        public int offset() {
            return this.offset;
        }

        public class_2561 getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label.getString();
        }

        public String getModifier() {
            return this.offset > 0 ? "+" : "-";
        }
    }
}

