/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.gui.widget.PresetPoseButtonWidget;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.roundalib.client.gui.icon.BuiltinIcon;
import me.roundaround.armorstands.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.LabelWidget;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import me.roundaround.armorstands.util.PosePreset;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5676;

public class ArmorStandPresetsScreen
extends AbstractArmorStandScreen {
    private static final int CONTROL_WIDTH = 120;
    private static final int CONTROL_HEIGHT = 16;
    private static final int BUTTONS_PER_PAGE = 6;
    private final ArrayList<PresetPoseButtonWidget> presetButtons = new ArrayList();
    private IconButtonWidget prevPageButton;
    private IconButtonWidget nextPageButton;
    private LabelWidget pageLabel;
    private int page = 0;
    private PosePreset.Source source = PosePreset.Source.ALL;
    private PosePreset.Category category = PosePreset.Category.ALL;
    private List<PosePreset> matchingPresets = new ArrayList<PosePreset>();

    public ArmorStandPresetsScreen(ArmorStandScreenHandler armorStandScreenHandler) {
        super(armorStandScreenHandler, ScreenType.PRESETS.getDisplayName());
        this.supportsUndoRedo = true;
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.PRESETS;
    }

    @Override
    protected void populateLayout() {
        super.populateLayout();
        this.initBottomLeft();
        this.initBottomRight();
    }

    @Override
    protected void collectElements() {
        this.updateFilters();
        super.collectElements();
    }

    private void initBottomLeft() {
        this.layout.bottomLeft.spacing(12);
        LinearLayoutWidget linearLayoutWidget = LinearLayoutWidget.vertical().spacing(2).defaultOffAxisContentAlignStart();
        linearLayoutWidget.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.presets.source.label")).bgColor(BACKGROUND_COLOR).build());
        linearLayoutWidget.add(class_5676.method_32606(PosePreset.Source::getDisplayName).method_32620(PosePreset.Source.getSources()).method_32619((Object)PosePreset.Source.ALL).method_32616().method_32617(0, 0, 120, 16, (class_2561)class_2561.method_43471((String)"armorstands.presets.source.label"), (class_56762, source) -> this.filter((PosePreset.Source)((Object)source))));
        this.layout.bottomLeft.add(linearLayoutWidget);
        LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.vertical().spacing(2).defaultOffAxisContentAlignStart();
        linearLayoutWidget2.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.presets.category.label")).bgColor(BACKGROUND_COLOR).build());
        linearLayoutWidget2.add(class_5676.method_32606(PosePreset.Category::getDisplayName).method_32620(PosePreset.Category.getCategories()).method_32619((Object)PosePreset.Category.ALL).method_32616().method_32617(0, 0, 120, 16, (class_2561)class_2561.method_43471((String)"armorstands.presets.category.label"), (class_56762, category) -> this.filter((PosePreset.Category)((Object)category))));
        this.layout.bottomLeft.add(linearLayoutWidget2);
    }

    private void initBottomRight() {
        for (int i = 6; i > 0; --i) {
            PresetPoseButtonWidget presetPoseButtonWidget = this.layout.bottomRight.add(new PresetPoseButtonWidget(120, 16));
            this.presetButtons.add(presetPoseButtonWidget);
        }
        LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.horizontal().spacing(2).defaultOffAxisContentAlignCenter();
        this.prevPageButton = linearLayoutWidget2.add(IconButtonWidget.builder(BuiltinIcon.PREV_18, "armorstands").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"armorstands.presets.previous")).onPress(class_41852 -> this.previousPage()).build());
        int n = class_3532.method_15386((float)((float)PosePreset.getPresets(this.source, this.category).size() / 6.0f)) - 1;
        this.pageLabel = linearLayoutWidget2.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43469((String)"armorstands.presets.page", (Object[])new Object[]{this.page + 1, n + 1})).alignTextCenterX().bgColor(BACKGROUND_COLOR).build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(76));
        this.nextPageButton = linearLayoutWidget2.add(IconButtonWidget.builder(BuiltinIcon.NEXT_18, "armorstands").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"armorstands.presets.next")).onPress(class_41852 -> this.nextPage()).build());
        this.layout.bottomRight.add(linearLayoutWidget2);
    }

    @Override
    public boolean method_25401(double d, double d2, double d3, double d4) {
        if (this.layout.bottomRight.getBounds().contains(d, d2)) {
            if (d4 < 0.0) {
                this.nextPage();
            } else {
                this.previousPage();
            }
            return true;
        }
        return super.method_25401(d, d2, d3, d4);
    }

    private void filter(PosePreset.Source source) {
        this.source = source;
        this.updateFilters();
    }

    private void filter(PosePreset.Category category) {
        this.category = category;
        this.updateFilters();
    }

    private void updateFilters() {
        this.matchingPresets = PosePreset.getPresets(this.source, this.category);
        this.setPage(0);
    }

    private void setPage(int n) {
        int n2 = Math.max(0, class_3532.method_15386((float)((float)this.matchingPresets.size() / 6.0f)) - 1);
        this.page = n;
        List<PosePreset> list = this.matchingPresets.subList(n * 6, Math.min((n + 1) * 6, this.matchingPresets.size()));
        for (int i = 0; i < 6; ++i) {
            if (i < list.size()) {
                this.presetButtons.get(i).setPose(list.get(i));
                this.presetButtons.get((int)i).field_22764 = true;
                continue;
            }
            this.presetButtons.get((int)i).field_22764 = false;
        }
        class_364 class_3642 = this.method_25399();
        if (class_3642 instanceof PresetPoseButtonWidget && !this.presetButtons.contains(class_3642)) {
            this.method_25395((class_364)this.presetButtons.getFirst());
        }
        this.prevPageButton.field_22763 = this.page > 0;
        this.nextPageButton.field_22763 = this.page < n2;
        this.pageLabel.setText((class_2561)class_2561.method_43469((String)"armorstands.presets.page", (Object[])new Object[]{this.page + 1, n2 + 1}));
    }

    private void nextPage() {
        int n = class_3532.method_15386((float)((float)this.matchingPresets.size() / 6.0f)) - 1;
        if (this.page < n) {
            this.setPage(this.page + 1);
        }
    }

    private void previousPage() {
        if (this.page > 0) {
            this.setPage(this.page - 1);
        }
    }
}

