/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.gui.widget.AdjustPoseSliderWidget;
import me.roundaround.armorstands.client.gui.widget.ScaleSliderWidget;
import me.roundaround.armorstands.client.network.ClientNetworking;
import me.roundaround.armorstands.network.EulerAngleParameter;
import me.roundaround.armorstands.network.PosePart;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.roundalib.client.gui.icon.BuiltinIcon;
import me.roundaround.armorstands.roundalib.client.gui.icon.CustomIcon;
import me.roundaround.armorstands.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.armorstands.roundalib.client.gui.util.Spacing;
import me.roundaround.armorstands.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.FrameWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.HorizontalLineWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.LabelWidget;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import me.roundaround.armorstands.util.Pose;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class ArmorStandPoseScreen
extends AbstractArmorStandScreen {
    private static final int SLIDER_WIDTH = 100;
    protected static final CustomIcon HEAD_ICON = new CustomIcon("head", 20);
    protected static final CustomIcon BODY_ICON = new CustomIcon("body", 20);
    protected static final CustomIcon RIGHT_ARM_ICON = new CustomIcon("rightarm", 20);
    protected static final CustomIcon LEFT_ARM_ICON = new CustomIcon("leftarm", 20);
    protected static final CustomIcon RIGHT_LEG_ICON = new CustomIcon("rightleg", 20);
    protected static final CustomIcon LEFT_LEG_ICON = new CustomIcon("leftleg", 20);
    private PosePart posePart = PosePart.HEAD;
    private ScaleSliderWidget scaleSlider;
    private class_4185 activePosePartButton;
    private FrameWidget activePosePartFrame;
    private LabelWidget posePartLabelLeft;
    private LabelWidget posePartLabelRight;
    private AdjustPoseSliderWidget pitchSlider;
    private AdjustPoseSliderWidget yawSlider;
    private AdjustPoseSliderWidget rollSlider;

    public ArmorStandPoseScreen(ArmorStandScreenHandler armorStandScreenHandler) {
        super(armorStandScreenHandler, ScreenType.POSE.getDisplayName());
        this.supportsUndoRedo = true;
    }

    public void onArmorStandPoseChanged(class_1531 class_15312, PosePart posePart) {
        if (this.pitchSlider == null || this.yawSlider == null || this.rollSlider == null) {
            return;
        }
        if (class_15312.method_5628() != this.getArmorStand().method_5628() || posePart != this.posePart) {
            return;
        }
        this.pitchSlider.refresh();
        this.yawSlider.refresh();
        this.rollSlider.refresh();
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.POSE;
    }

    @Override
    protected void populateLayout() {
        super.populateLayout();
        this.initBottomLeft();
        this.initBottomRight();
        this.activePosePartFrame = this.layout.nonPositioned.add(new FrameWidget(), (nonPositioningLayoutWidget, frameWidget) -> frameWidget.frame((class_8021)this.activePosePartButton));
    }

    private void initBottomLeft() {
        this.layout.bottomLeft.defaultOffAxisContentAlignCenter();
        LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.vertical().spacing(4).defaultOffAxisContentAlignCenter();
        this.posePartLabelLeft = linearLayoutWidget2.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43469((String)"armorstands.pose.editing", (Object[])new Object[]{this.posePart.getDisplayName()})).width(100).overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).alignTextCenterX().bgColor(BACKGROUND_COLOR).build());
        this.activePosePartButton = linearLayoutWidget2.add(IconButtonWidget.builder(HEAD_ICON, "armorstands").vanillaSize().disableIconDim().messageAndTooltip(PosePart.HEAD.getDisplayName()).onPress(class_41852 -> this.setActivePosePart(class_41852, PosePart.HEAD)).build());
        this.activePosePartButton.field_22763 = false;
        LinearLayoutWidget linearLayoutWidget3 = LinearLayoutWidget.horizontal().spacing(4);
        linearLayoutWidget3.add(IconButtonWidget.builder(RIGHT_ARM_ICON, "armorstands").vanillaSize().disableIconDim().messageAndTooltip(PosePart.RIGHT_ARM.getDisplayName()).onPress(class_41852 -> this.setActivePosePart(class_41852, PosePart.RIGHT_ARM)).build());
        linearLayoutWidget3.add(IconButtonWidget.builder(BODY_ICON, "armorstands").vanillaSize().disableIconDim().messageAndTooltip(PosePart.BODY.getDisplayName()).onPress(class_41852 -> this.setActivePosePart(class_41852, PosePart.BODY)).build());
        linearLayoutWidget3.add(IconButtonWidget.builder(LEFT_ARM_ICON, "armorstands").vanillaSize().disableIconDim().messageAndTooltip(PosePart.LEFT_ARM.getDisplayName()).onPress(class_41852 -> this.setActivePosePart(class_41852, PosePart.LEFT_ARM)).build());
        linearLayoutWidget2.add(linearLayoutWidget3);
        LinearLayoutWidget linearLayoutWidget4 = LinearLayoutWidget.horizontal().spacing(4);
        linearLayoutWidget4.add(IconButtonWidget.builder(RIGHT_LEG_ICON, "armorstands").vanillaSize().disableIconDim().messageAndTooltip(PosePart.RIGHT_LEG.getDisplayName()).onPress(class_41852 -> this.setActivePosePart(class_41852, PosePart.RIGHT_LEG)).build());
        linearLayoutWidget4.add(IconButtonWidget.builder(LEFT_LEG_ICON, "armorstands").vanillaSize().disableIconDim().messageAndTooltip(PosePart.LEFT_LEG.getDisplayName()).onPress(class_41852 -> this.setActivePosePart(class_41852, PosePart.LEFT_LEG)).build());
        linearLayoutWidget2.add(linearLayoutWidget4);
        this.layout.bottomLeft.add(linearLayoutWidget2);
        this.layout.bottomLeft.add(new HorizontalLineWidget(92).margin(8));
        this.layout.bottomLeft.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.pose.mirror"), this::handleMirrorPose).method_46437(100, 16).method_46431());
        this.layout.bottomLeft.add(new HorizontalLineWidget(92).margin(8));
        LinearLayoutWidget linearLayoutWidget5 = LinearLayoutWidget.vertical().spacing(2);
        LinearLayoutWidget linearLayoutWidget6 = LinearLayoutWidget.horizontal().spacing(2).defaultOffAxisContentAlignEnd();
        linearLayoutWidget6.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43471((String)"armorstands.scale")).bgColor(BACKGROUND_COLOR).build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(100 - 3 * (16 + linearLayoutWidget.getSpacing())));
        linearLayoutWidget6.add(IconButtonWidget.builder(BuiltinIcon.MINUS_13, "armorstands").dimensions(16).onPress(class_41852 -> this.scaleSlider.decrement()).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.scale.subtract"))).build());
        linearLayoutWidget6.add(IconButtonWidget.builder(BuiltinIcon.PLUS_13, "armorstands").dimensions(16).onPress(class_41852 -> this.scaleSlider.increment()).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.scale.add"))).build());
        linearLayoutWidget6.add(IconButtonWidget.builder(BuiltinIcon.ROTATE_13, "armorstands").dimensions(16).onPress(class_41852 -> this.scaleSlider.setToOne()).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.scale.zero"))).build());
        linearLayoutWidget5.add(linearLayoutWidget6);
        this.scaleSlider = linearLayoutWidget5.add(new ScaleSliderWidget(this, 100, 16, this.getArmorStand()));
        this.layout.bottomLeft.add(linearLayoutWidget5);
    }

    private void initBottomRight() {
        this.layout.bottomRight.spacing(12);
        LinearLayoutWidget linearLayoutWidget = LinearLayoutWidget.vertical().spacing(2).defaultOffAxisContentAlignEnd();
        this.posePartLabelRight = linearLayoutWidget.add(LabelWidget.builder(this.field_22793, (class_2561)class_2561.method_43469((String)"armorstands.pose.editing", (Object[])new Object[]{this.posePart.getDisplayName()})).width(100).overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).alignTextRight().bgColor(BACKGROUND_COLOR).build());
        linearLayoutWidget.add(class_5676.method_32606(SliderRange::getDisplayName).method_32619((Object)SliderRange.FULL).method_32624((Object[])SliderRange.values()).method_32616().method_57720((class_2561)class_2561.method_43471((String)"armorstands.pose.range"), (class_56762, sliderRange) -> {
            this.pitchSlider.setRange(sliderRange.getMin(), sliderRange.getMax());
            this.yawSlider.setRange(sliderRange.getMin(), sliderRange.getMax());
            this.rollSlider.setRange(sliderRange.getMin(), sliderRange.getMax());
        }), linearLayoutCellConfigurator -> {
            linearLayoutCellConfigurator.layoutHook((linearLayoutWidget, class_56762) -> class_56762.method_55445(100, 16));
            linearLayoutCellConfigurator.margin(Spacing.of(0, 0, 8, 0));
        });
        this.layout.bottomRight.add(linearLayoutWidget);
        this.pitchSlider = this.addAdjustSlider(EulerAngleParameter.PITCH);
        this.yawSlider = this.addAdjustSlider(EulerAngleParameter.YAW);
        this.rollSlider = this.addAdjustSlider(EulerAngleParameter.ROLL);
    }

    private AdjustPoseSliderWidget addAdjustSlider(EulerAngleParameter eulerAngleParameter) {
        LinearLayoutWidget linearLayoutWidget2 = LinearLayoutWidget.vertical().spacing(2);
        AdjustPoseSliderWidget adjustPoseSliderWidget = new AdjustPoseSliderWidget(100, 16, this.posePart, eulerAngleParameter, this.getArmorStand());
        LinearLayoutWidget linearLayoutWidget3 = LinearLayoutWidget.horizontal().defaultOffAxisContentAlignEnd().spacing(4);
        linearLayoutWidget3.add(LabelWidget.builder(this.field_22793, eulerAngleParameter.getDisplayName()).bgColor(BACKGROUND_COLOR).build(), (linearLayoutWidget, labelWidget) -> labelWidget.method_25358(100 - 3 * (16 + linearLayoutWidget.getSpacing())));
        linearLayoutWidget3.add(IconButtonWidget.builder(BuiltinIcon.MINUS_13, "armorstands").dimensions(16).onPress(class_41852 -> adjustPoseSliderWidget.decrement()).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.pose.subtract"))).build());
        linearLayoutWidget3.add(IconButtonWidget.builder(BuiltinIcon.PLUS_13, "armorstands").dimensions(16).onPress(class_41852 -> adjustPoseSliderWidget.increment()).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.pose.add"))).build());
        linearLayoutWidget3.add(IconButtonWidget.builder(BuiltinIcon.ROTATE_13, "armorstands").dimensions(16).onPress(class_41852 -> adjustPoseSliderWidget.zero()).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.pose.zero"))).build());
        linearLayoutWidget2.add(linearLayoutWidget3);
        linearLayoutWidget2.add(adjustPoseSliderWidget);
        this.layout.bottomRight.add(linearLayoutWidget2);
        return adjustPoseSliderWidget;
    }

    @Override
    public boolean method_25401(double d, double d2, double d3, double d4) {
        if (this.pitchSlider != null && this.pitchSlider.method_25401(d, d2, d3, d4)) {
            return true;
        }
        if (this.yawSlider != null && this.yawSlider.method_25401(d, d2, d3, d4)) {
            return true;
        }
        if (this.rollSlider != null && this.rollSlider.method_25401(d, d2, d3, d4)) {
            return true;
        }
        return super.method_25401(d, d2, d3, d4);
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        this.scaleSlider.tick();
        this.pitchSlider.tick();
        this.yawSlider.tick();
        this.rollSlider.tick();
    }

    @Override
    public void onPong() {
        super.onPong();
        if (this.scaleSlider != null) {
            this.scaleSlider.onPong();
        }
    }

    private void setActivePosePart(class_4185 class_41852, PosePart posePart) {
        this.posePart = posePart;
        this.pitchSlider.setPart(posePart);
        this.yawSlider.setPart(posePart);
        this.rollSlider.setPart(posePart);
        this.posePartLabelLeft.setText((class_2561)class_2561.method_43469((String)"armorstands.pose.editing", (Object[])new Object[]{this.posePart.getDisplayName()}));
        this.posePartLabelRight.setText((class_2561)class_2561.method_43469((String)"armorstands.pose.editing", (Object[])new Object[]{this.posePart.getDisplayName()}));
        if (this.activePosePartButton != null) {
            this.activePosePartButton.field_22763 = true;
        }
        this.activePosePartButton = class_41852;
        this.activePosePartButton.field_22763 = false;
        this.activePosePartFrame.frame((class_8021)this.activePosePartButton);
        this.layout.method_48222();
    }

    private void handleMirrorPose(class_4185 class_41852) {
        ClientNetworking.sendSetPosePacket(new Pose(this.getArmorStand()).mirror());
        this.pitchSlider.refresh();
        this.yawSlider.refresh();
        this.rollSlider.refresh();
    }

    private static enum SliderRange {
        FULL(-180, 180),
        HALF(-90, 90),
        TIGHT(-35, 35);

        private final int min;
        private final int max;

        private SliderRange(int n2, int n3) {
            this.min = n2;
            this.max = n3;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)("armorstands.pose.range." + this.name().toLowerCase()));
        }
    }
}

