/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.network.ClientNetworking;
import me.roundaround.armorstands.network.ArmorStandFlag;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.roundalib.client.gui.widget.ToggleWidget;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import net.minecraft.class_10799;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1735;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_490;

public class ArmorStandInventoryScreen
extends AbstractArmorStandScreen {
    private static final int BACKGROUND_WIDTH = 176;
    private static final int BACKGROUND_HEIGHT = 166;
    private static final int TOGGLE_HEIGHT = 16;
    private static final class_2960 CUSTOM_TEXTURE = class_2960.method_60655((String)"armorstands", (String)"textures/gui/container/inventory.png");
    private float prevMouseX;
    private float prevMouseY;
    private ToggleWidget showArmsToggle;
    private ToggleWidget lockInventoryToggle;

    public ArmorStandInventoryScreen(ArmorStandScreenHandler armorStandScreenHandler) {
        super(armorStandScreenHandler, ScreenType.INVENTORY.getDisplayName());
        this.utilizesInventory = true;
        this.passEvents = false;
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.INVENTORY;
    }

    @Override
    protected void populateLayout() {
        super.populateLayout();
        this.showArmsToggle = this.layout.bottomRight.add(this.createToggleWidget(ArmorStandFlag.SHOW_ARMS));
        this.lockInventoryToggle = this.layout.bottomRight.add(this.createToggleWidget(ArmorStandFlag.LOCK_INVENTORY));
    }

    private ToggleWidget createToggleWidget(ArmorStandFlag armorStandFlag) {
        return ToggleWidget.yesNoBuilder(this.field_22793, bl -> armorStandFlag.getDisplayName()).initially(this.getFlagValue(armorStandFlag)).onPress(toggleWidget -> ClientNetworking.sendSetFlagPacket(armorStandFlag, !this.getFlagValue(armorStandFlag))).matchTooltipToLabel().setHeight(16).labelBgColor(BACKGROUND_COLOR).build();
    }

    private boolean getFlagValue(ArmorStandFlag armorStandFlag) {
        return armorStandFlag.getValue(this.getArmorStand());
    }

    @Override
    protected void method_48640() {
        this.field_2776 = (this.field_22789 - 176) / 2;
        this.field_2800 = (this.field_22790 - 166) / 2;
        super.method_48640();
    }

    @Override
    public void method_25394(class_332 class_3322, int n, int n2, float f) {
        super.method_25394(class_3322, n, n2, f);
        this.method_2380(class_3322, n, n2);
        this.prevMouseX = n;
        this.prevMouseY = n2;
    }

    @Override
    protected void method_2389(class_332 class_3322, float f, int n, int n2) {
        class_3322.method_25290(class_10799.field_56883, CUSTOM_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, 176, 166, 256, 256);
        ImmutableList<Pair<class_1735, class_1304>> immutableList = ((ArmorStandScreenHandler)this.field_2797).getArmorSlots();
        for (int i = 0; i < immutableList.size(); ++i) {
            class_1735 class_17352 = (class_1735)((Pair)immutableList.get(i)).getFirst();
            class_1304 class_13042 = (class_1304)((Pair)immutableList.get(i)).getSecond();
            if (!ArmorStandScreenHandler.isSlotDisabled(this.armorStand, class_13042)) continue;
            class_3322.method_25294(this.field_2776 + class_17352.field_7873, this.field_2800 + class_17352.field_7872, this.field_2776 + class_17352.field_7873 + 16, this.field_2800 + class_17352.field_7872 + 16, Integer.MIN_VALUE);
        }
        class_490.method_2486((class_332)class_3322, (int)(this.field_2776 + 62), (int)(this.field_2800 + 8), (int)(this.field_2776 + 114), (int)(this.field_2800 + 78), (int)30, (float)0.0625f, (float)this.prevMouseX, (float)this.prevMouseY, (class_1309)this.getArmorStand());
    }

    @Override
    public void method_37432() {
        super.method_37432();
        this.showArmsToggle.setValue(ArmorStandFlag.SHOW_ARMS.getValue(this.getArmorStand()));
        this.lockInventoryToggle.setValue(ArmorStandFlag.LOCK_INVENTORY.getValue(this.getArmorStand()));
    }
}

