/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import me.roundaround.armorstands.client.ArmorStandsClientMod;
import me.roundaround.armorstands.client.gui.MessageRenderer;
import me.roundaround.armorstands.client.gui.screen.ArmorStandLayoutWidget;
import me.roundaround.armorstands.client.gui.screen.PassesEventsThrough;
import me.roundaround.armorstands.client.network.ClientNetworking;
import me.roundaround.armorstands.mixin.ArmorStandEntityAccessor;
import me.roundaround.armorstands.mixin.InGameHudAccessor;
import me.roundaround.armorstands.mixin.MouseAccessor;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.UtilityAction;
import me.roundaround.armorstands.roundalib.client.gui.icon.BuiltinIcon;
import me.roundaround.armorstands.roundalib.client.gui.icon.CustomIcon;
import me.roundaround.armorstands.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.armorstands.roundalib.client.gui.util.GuiUtil;
import me.roundaround.armorstands.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.FrameWidget;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8021;

public abstract class AbstractArmorStandScreen
extends class_465<ArmorStandScreenHandler>
implements PassesEventsThrough {
    protected static final CustomIcon COPY_ICON = new CustomIcon("copy", 20);
    protected static final CustomIcon PASTE_ICON = new CustomIcon("paste", 20);
    protected static final int BACKGROUND_COLOR = GuiUtil.genColorInt(0.0f, 0.0f, 0.0f, 0.7f);
    protected static final int ELEMENT_HEIGHT = 16;
    protected final ArmorStandLayoutWidget layout = new ArmorStandLayoutWidget((class_437)this);
    protected final class_1531 armorStand;
    protected final MessageRenderer messageRenderer;
    protected LinearLayoutWidget utilRow;
    protected LinearLayoutWidget navRow;
    protected IconButtonWidget activePageButton;
    protected boolean supportsUndoRedo = false;
    protected boolean utilizesInventory = false;
    protected boolean passEvents = true;
    protected long currentSyncDelay = 0L;
    private boolean cursorLocked = false;
    private long lastPing = 0L;

    protected AbstractArmorStandScreen(ArmorStandScreenHandler armorStandScreenHandler, class_2561 class_25612) {
        super((class_1703)armorStandScreenHandler, armorStandScreenHandler.getPlayerInventory(), class_25612);
        this.armorStand = armorStandScreenHandler.getArmorStand();
        this.messageRenderer = new MessageRenderer((class_437)this);
    }

    public abstract ScreenType getScreenType();

    public class_1531 getArmorStand() {
        return this.armorStand;
    }

    public MessageRenderer getMessageRenderer() {
        return this.messageRenderer;
    }

    @Override
    public boolean shouldPassEvents() {
        return this.passEvents;
    }

    public void method_25426() {
        this.populateLayout();
        this.collectElements();
        this.method_48640();
    }

    protected class_310 getClient() {
        return Objects.requireNonNull(this.field_22787);
    }

    protected class_746 getPlayer() {
        return this.getClient().field_1724;
    }

    protected void populateLayout() {
        this.initUtilityButtons();
        this.initNavigationButtons();
    }

    protected void initUtilityButtons() {
        if (!this.supportsUndoRedo) {
            return;
        }
        this.utilRow = LinearLayoutWidget.horizontal().spacing(2);
        this.utilRow.add(IconButtonWidget.builder(BuiltinIcon.HELP_18, "armorstands").vanillaSize().messageAndTooltip(this.buildHelpTooltipText()).build());
        this.utilRow.add(IconButtonWidget.builder(COPY_ICON, "armorstands").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"armorstands.utility.copy")).onPress(class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.COPY)).build());
        this.utilRow.add(IconButtonWidget.builder(PASTE_ICON, "armorstands").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"armorstands.utility.paste")).onPress(class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.PASTE)).build());
        this.utilRow.add(IconButtonWidget.builder(BuiltinIcon.UNDO_18, "armorstands").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"armorstands.utility.undo")).onPress(class_41852 -> ClientNetworking.sendUndoPacket(false)).build());
        this.utilRow.add(IconButtonWidget.builder(BuiltinIcon.REDO_18, "armorstands").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"armorstands.utility.redo")).onPress(class_41852 -> ClientNetworking.sendUndoPacket(true)).build());
        this.layout.topLeft.add(this.utilRow);
    }

    private class_2561 buildHelpTooltipText() {
        String string = class_2561.method_43471((String)"armorstands.help.alt").getString();
        String string2 = this.getClient().field_1690.field_1822.method_16007().getString();
        String string3 = class_3675.method_15985((int)256, (int)0).method_27445().getString();
        String string4 = ArmorStandsClientMod.highlightArmorStandKeyBinding.method_16007().getString();
        String string5 = class_2561.method_43471((String)("armorstands.help." + (class_310.field_1703 ? "cmd" : "ctrl"))).getString();
        String string6 = class_3675.method_15985((int)90, (int)0).method_27445().getString();
        String string7 = class_3675.method_15985((int)89, (int)0).method_27445().getString();
        String string8 = class_3675.method_15985((int)67, (int)0).method_27445().getString();
        String string9 = class_3675.method_15985((int)86, (int)0).method_27445().getString();
        return class_2561.method_43469((String)"armorstands.help", (Object[])new Object[]{string, string2, string3, ScreenType.values().length, string4, string5, string6, string5, string7, string5, string8, string5, string9});
    }

    protected void initNavigationButtons() {
        this.navRow = LinearLayoutWidget.horizontal().spacing(2);
        for (ScreenType screenType : ScreenType.values()) {
            IconButtonWidget iconButtonWidget = IconButtonWidget.builder(screenType.getIcon(), "armorstands").vanillaSize().disableIconDim().messageAndTooltip(screenType.getDisplayName()).onPress(class_41852 -> ClientNetworking.sendRequestScreenPacket(this.getArmorStand(), screenType)).build();
            if (this.getScreenType() == screenType) {
                iconButtonWidget.field_22763 = false;
                this.activePageButton = iconButtonWidget;
            }
            this.navRow.add(iconButtonWidget);
        }
        this.layout.topRight.add(this.navRow);
        if (this.activePageButton != null) {
            this.layout.nonPositioned.add(new FrameWidget((class_8021)this.activePageButton));
        }
    }

    protected void collectElements() {
        this.layout.method_48206(class_3642 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)class_3642);
        });
    }

    protected void method_48640() {
        this.layout.method_48222();
    }

    protected void method_37432() {
        assert (this.field_22787 != null);
        ((InGameHudAccessor)this.field_22787.field_1705).invokeUpdateVignetteDarkness(this.field_22787.method_1560());
        this.messageRenderer.tick();
    }

    public void method_25394(class_332 class_3322, int n, int n2, float f) {
        assert (this.field_22787 != null);
        int n3 = this.cursorLocked ? -1 : n;
        int n4 = this.cursorLocked ? -1 : n2;
        ((InGameHudAccessor)this.field_22787.field_1705).invokeRenderVignetteOverlay(class_3322, this.field_22787.method_1560());
        super.method_25394(class_3322, n3, n4, f);
        this.messageRenderer.render(class_3322);
    }

    public void method_52752(class_332 class_3322) {
    }

    protected void method_2389(class_332 class_3322, float f, int n, int n2) {
    }

    protected void method_2388(class_332 class_3322, int n, int n2) {
    }

    public void method_16014(double d, double d2) {
        if (this.cursorLocked) {
            return;
        }
        super.method_16014(d, d2);
    }

    public boolean method_25402(double d, double d2, int n) {
        if (this.cursorLocked) {
            return false;
        }
        class_364 class_3642 = this.method_25399();
        boolean bl = super.method_25402(d, d2, n);
        if (this.utilizesInventory) {
            this.method_25395(class_3642);
        }
        return bl;
    }

    public boolean method_25403(double d, double d2, int n, double d3, double d4) {
        if (this.cursorLocked) {
            return false;
        }
        if (this.utilizesInventory) {
            return super.method_25403(d, d2, n, d3, d4);
        }
        if (this.method_25399() != null && this.method_25397() && n == 0) {
            return this.method_25399().method_25403(d, d2, n, d3, d4);
        }
        return false;
    }

    public boolean method_25406(double d, double d2, int n) {
        if (this.cursorLocked) {
            return false;
        }
        if (this.utilizesInventory) {
            return super.method_25406(d, d2, n);
        }
        if (this.method_25397() && this.method_25399() != null && n == 0) {
            this.method_25398(false);
            return this.method_25399().method_25406(d, d2, n);
        }
        this.method_25398(false);
        return this.method_19355(d, d2).filter(class_3642 -> class_3642.method_25406(d, d2, n)).isPresent();
    }

    public boolean method_25401(double d, double d2, double d3, double d4) {
        if (this.cursorLocked) {
            return false;
        }
        if (this.navRow != null && this.navRow.getBounds().contains(d, d2)) {
            if (d4 > 0.0) {
                this.goToPreviousScreen();
            } else {
                this.goToNextScreen();
            }
            return true;
        }
        return super.method_25401(d, d2, d3, d4);
    }

    public Optional<class_364> method_19355(double d, double d2) {
        if (this.cursorLocked) {
            return Optional.empty();
        }
        return super.method_19355(d, d2);
    }

    public boolean method_25404(int n, int n2, int n3) {
        assert (this.field_22787 != null);
        if (this.field_22787.field_1690.field_1903.method_1417(n, n2)) {
            return false;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(n, n2)) {
            this.method_25419();
            return true;
        }
        switch (n) {
            case 256: {
                this.method_25419();
                return true;
            }
            case 342: 
            case 346: {
                if (!this.passEvents) break;
                this.lockCursor();
                return true;
            }
            case 263: {
                if (!class_437.method_25441()) break;
                GuiUtil.playClickSound();
                this.goToPreviousScreen();
                return true;
            }
            case 262: {
                if (!class_437.method_25441()) break;
                GuiUtil.playClickSound();
                this.goToNextScreen();
                return true;
            }
            case 90: {
                if (!this.supportsUndoRedo || !class_437.method_25441()) break;
                GuiUtil.playClickSound();
                ClientNetworking.sendUndoPacket(false);
                return true;
            }
            case 89: {
                if (!this.supportsUndoRedo || !class_437.method_25441()) break;
                GuiUtil.playClickSound();
                ClientNetworking.sendUndoPacket(true);
                return true;
            }
            case 67: {
                if (!this.supportsUndoRedo || !class_437.method_25441()) break;
                GuiUtil.playClickSound();
                ClientNetworking.sendUtilityActionPacket(UtilityAction.COPY);
                return true;
            }
            case 86: {
                if (!this.supportsUndoRedo || !class_437.method_25441()) break;
                GuiUtil.playClickSound();
                ClientNetworking.sendUtilityActionPacket(UtilityAction.PASTE);
                return true;
            }
        }
        for (ScreenType screenType : ScreenType.values()) {
            if (screenType == this.getScreenType() || !this.field_22787.field_1690.field_1852[screenType.getIndex()].method_1417(n, n2)) continue;
            GuiUtil.playClickSound();
            ClientNetworking.sendRequestScreenPacket(this.armorStand, screenType);
            return true;
        }
        if (this.method_25399() != null && this.method_25399().method_25404(n, n2, n3)) {
            return true;
        }
        return super.method_25404(n, n2, n3);
    }

    public boolean method_16803(int n, int n2, int n3) {
        if (this.passEvents && (n == 342 || n == 346)) {
            this.unlockCursor();
            return true;
        }
        return this.method_25399() != null && this.method_25399().method_16803(n, n2, n3);
    }

    public boolean shouldHighlight(class_1297 class_12972) {
        return ArmorStandsClientMod.highlightArmorStandKeyBinding.method_1434() && class_12972 == this.armorStand;
    }

    public boolean isCursorLocked() {
        return this.cursorLocked;
    }

    public void sendPing() {
        this.lastPing = System.currentTimeMillis();
        ClientNetworking.sendPingPacket(Objects.requireNonNull(this.field_22787).field_1724);
    }

    public void onPong() {
        this.currentSyncDelay = System.currentTimeMillis() - this.lastPing;
    }

    public void updatePosOnClient(double d, double d2, double d3) {
        this.armorStand.method_23327(d, d2, d3);
    }

    public void updateYawOnClient(float f) {
        this.armorStand.method_36456(f);
    }

    public void updatePitchOnClient(float f) {
        this.armorStand.method_36457(f);
    }

    public void updateInvulnerableOnClient(boolean bl) {
        this.armorStand.method_5684(bl);
    }

    public void updateDisabledSlotsOnClient(int n) {
        ((ArmorStandEntityAccessor)this.armorStand).setDisabledSlots(n);
    }

    protected void lockCursor() {
        assert (this.field_22787 != null);
        this.cursorLocked = true;
        int n = this.field_22787.method_22683().method_4480() / 2;
        int n2 = this.field_22787.method_22683().method_4507() / 2;
        ((MouseAccessor)this.field_22787.field_1729).setX(n);
        ((MouseAccessor)this.field_22787.field_1729).setY(n2);
        class_3675.method_15984((long)this.field_22787.method_22683().method_4490(), (int)212995, (double)n, (double)n2);
    }

    protected void unlockCursor() {
        assert (this.field_22787 != null);
        this.cursorLocked = false;
        int n = this.field_22787.method_22683().method_4480() / 2;
        int n2 = this.field_22787.method_22683().method_4507() / 2;
        ((MouseAccessor)this.field_22787.field_1729).setX(n);
        ((MouseAccessor)this.field_22787.field_1729).setY(n2);
        class_3675.method_15984((long)this.field_22787.method_22683().method_4490(), (int)212993, (double)n, (double)n2);
    }

    protected void goToPreviousScreen() {
        ClientNetworking.sendRequestScreenPacket(this.armorStand, this.getScreenType().previous());
    }

    protected void goToNextScreen() {
        ClientNetworking.sendRequestScreenPacket(this.armorStand, this.getScreenType().next());
    }

    protected static class_2561 getCurrentPosText(class_1297 class_12972) {
        String string = String.format("%.2f", class_12972.method_23317());
        String string2 = String.format("%.2f", class_12972.method_23318());
        String string3 = String.format("%.2f", class_12972.method_23321());
        return class_2561.method_43469((String)"armorstands.current.position", (Object[])new Object[]{string, string2, string3});
    }

    protected static class_2561 getCurrentBlockPosText(class_1297 class_12972) {
        class_2338 class_23382 = class_12972.method_24515();
        return class_2561.method_43469((String)"armorstands.current.block", (Object[])new Object[]{class_23382.method_10263(), class_23382.method_10264(), class_23382.method_10260()});
    }

    protected static class_2561 getCurrentRotationText(class_1297 class_12972) {
        float f = class_12972.method_36454();
        return class_2561.method_43469((String)"armorstands.current.rotation", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", Float.valueOf(class_3532.method_15393((float)f)))});
    }

    protected static class_2561 getCurrentFacingText(class_1297 class_12972) {
        return AbstractArmorStandScreen.getFacingText(class_2350.method_10150((double)class_12972.method_36454()));
    }

    protected static class_2561 getFacingText(class_2350 class_23502) {
        String string = switch (class_23502) {
            case class_2350.field_11043 -> "negZ";
            case class_2350.field_11035 -> "posZ";
            case class_2350.field_11039 -> "negX";
            default -> "posX";
        };
        class_5250 class_52502 = class_2561.method_43471((String)("armorstands.current.facing." + string));
        return class_2561.method_43469((String)"armorstands.current.facing", (Object[])new Object[]{class_23502.toString(), class_52502.getString()});
    }
}

