/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.AlternateCurrentMod;
import alternate.current.interfaces.mixin.IServerLevel;
import alternate.current.wire.UpdateOrder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_5218;

public interface Config {
    public static Config forLevel(class_3218 level, class_32.class_5143 storage) {
        if (level.method_27983() == class_1937.field_25179) {
            return new Primary(storage);
        }
        return new Derived(((IServerLevel)level.method_8503().method_30002()).alternate_current$getWireHandler().getConfig());
    }

    public boolean getEnabled();

    public void setEnabled(boolean var1);

    public UpdateOrder getUpdateOrder();

    public void setUpdateOrder(UpdateOrder var1);

    public void load();

    public void save(boolean var1);

    public static class Primary
    implements Config {
        private final Path path;
        private boolean enabled = true;
        private UpdateOrder updateOrder = UpdateOrder.HORIZONTAL_FIRST_OUTWARD;
        private boolean modified;

        public Primary(class_32.class_5143 storage) {
            this.path = storage.method_27010(class_5218.field_24188).resolve("alternate-current.conf");
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            AlternateCurrentMod.on = enabled;
            this.modified = true;
        }

        @Override
        public UpdateOrder getUpdateOrder() {
            return this.updateOrder;
        }

        @Override
        public void setUpdateOrder(UpdateOrder updateOrder) {
            this.updateOrder = Objects.requireNonNull(updateOrder);
            this.modified = true;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void load() {
            if (!Files.exists(this.path, new LinkOption[0])) {
                this.modified = true;
                return;
            }
            try {
                br = Files.newBufferedReader(this.path);
lbl6:
                // 3 sources

                try {
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("#") || (parts = line.split("[=]")).length != 2) continue;
                        key = parts[0];
                        value = parts[1];
                        try {
                            var6_9 = key;
                            var7_11 = -1;
                            switch (var6_9.hashCode()) {
                                case -1609594047: {
                                    if (!var6_9.equals("enabled")) break;
                                    var7_11 = 0;
                                    break;
                                }
                                case -2032772790: {
                                    if (!var6_9.equals("update-order")) break;
                                    var7_11 = 1;
                                    break;
                                }
                            }
                            switch (var7_11) {
                                case 0: {
                                    this.setEnabled(Boolean.parseBoolean(value));
                                    ** GOTO lbl6
                                }
                                case 1: {
                                    this.setUpdateOrder(UpdateOrder.byId(value));
                                    ** GOTO lbl6
                                }
                            }
                            AlternateCurrentMod.LOGGER.info("skipping unknown option '" + key + "' in Alternate Current config");
                        }
                        catch (Exception e) {
                            AlternateCurrentMod.LOGGER.info("skipping bad value '" + value + "' for option '" + key + "' in Alternate Current config!", (Throwable)e);
                        }
                    }
                    this.modified = false;
                    return;
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
            catch (IOException e) {
                AlternateCurrentMod.LOGGER.info("unable to load Alternate Current config!", (Throwable)e);
                this.modified = true;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void save(boolean silent) {
            if (this.modified) {
                if (!silent) {
                    AlternateCurrentMod.LOGGER.info("saving Alternate Current config");
                }
                try (BufferedWriter bw = Files.newBufferedWriter(this.path, new OpenOption[0]);){
                    bw.write("enabled");
                    bw.write(61);
                    bw.write(Boolean.toString(this.enabled));
                    bw.newLine();
                    bw.write("update-order");
                    bw.write(61);
                    bw.write(this.updateOrder.id());
                    bw.newLine();
                }
                catch (IOException e) {
                    AlternateCurrentMod.LOGGER.info("unable to save Alternate Current config!", (Throwable)e);
                }
                finally {
                    this.modified = false;
                }
            }
        }
    }

    public static class Derived
    implements Config {
        private final Config delegate;

        public Derived(Config delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean getEnabled() {
            return this.delegate.getEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.delegate.setEnabled(enabled);
        }

        @Override
        public UpdateOrder getUpdateOrder() {
            return this.delegate.getUpdateOrder();
        }

        @Override
        public void setUpdateOrder(UpdateOrder updateOrder) {
            this.delegate.setUpdateOrder(updateOrder);
        }

        @Override
        public void load() {
        }

        @Override
        public void save(boolean silent) {
        }
    }
}

