/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.command;

import alternate.current.interfaces.mixin.IServerLevel;
import alternate.current.util.profiler.ProfilerResults;
import alternate.current.wire.UpdateOrder;
import alternate.current.wire.WireHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class AlternateCurrentCommand {
    private static final DynamicCommandExceptionType NO_SUCH_UPDATE_ORDER = new DynamicCommandExceptionType(value -> class_2561.method_43470((String)("no such update order: " + String.valueOf(value))));
    private static final String[] UPDATE_ORDERS;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"alternatecurrent").requires(source -> source.method_9259(2))).executes(context -> AlternateCurrentCommand.queryEnabled((class_2168)context.getSource()))).then(class_2170.method_9247((String)"on").executes(context -> AlternateCurrentCommand.setEnabled((class_2168)context.getSource(), true)))).then(class_2170.method_9247((String)"off").executes(context -> AlternateCurrentCommand.setEnabled((class_2168)context.getSource(), false)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"updateOrder").executes(context -> AlternateCurrentCommand.queryUpdateOrder((class_2168)context.getSource()))).then(class_2170.method_9244((String)"updateOrder", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionBuilder) -> class_2172.method_9253((String[])UPDATE_ORDERS, (SuggestionsBuilder)suggestionBuilder)).executes(context -> AlternateCurrentCommand.setUpdateOrder((class_2168)context.getSource(), AlternateCurrentCommand.parseUpdateOrder((CommandContext<class_2168>)context, "updateOrder")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"resetProfiler").requires(source -> false)).executes(context -> AlternateCurrentCommand.resetProfiler((class_2168)context.getSource())));
        dispatcher.register(builder);
    }

    private static UpdateOrder parseUpdateOrder(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        String value = StringArgumentType.getString(context, (String)name);
        try {
            return UpdateOrder.byId(value);
        }
        catch (Exception e) {
            throw NO_SUCH_UPDATE_ORDER.create((Object)name);
        }
    }

    private static int queryEnabled(class_2168 source) {
        class_3218 level = source.method_9225();
        WireHandler wireHandler = ((IServerLevel)level).alternate_current$getWireHandler();
        String state = wireHandler.getConfig().getEnabled() ? "enabled" : "disabled";
        source.method_9226(() -> class_2561.method_43470((String)String.format("Alternate Current is currently %s", state)), false);
        return 1;
    }

    private static int setEnabled(class_2168 source, boolean on) {
        class_3218 level = source.method_9225();
        WireHandler wireHandler = ((IServerLevel)level).alternate_current$getWireHandler();
        wireHandler.getConfig().setEnabled(on);
        String state = wireHandler.getConfig().getEnabled() ? "enabled" : "disabled";
        source.method_9226(() -> class_2561.method_43470((String)String.format("Alternate Current has been %s!", state)), true);
        return 1;
    }

    private static int queryUpdateOrder(class_2168 source) {
        class_3218 level = source.method_9225();
        WireHandler wireHandler = ((IServerLevel)level).alternate_current$getWireHandler();
        String value = wireHandler.getConfig().getUpdateOrder().id();
        source.method_9226(() -> class_2561.method_43470((String)String.format("Update order is currently %s", value)), false);
        return 1;
    }

    private static int setUpdateOrder(class_2168 source, UpdateOrder updateOrder) {
        class_3218 level = source.method_9225();
        WireHandler wireHandler = ((IServerLevel)level).alternate_current$getWireHandler();
        wireHandler.getConfig().setUpdateOrder(updateOrder);
        String value = wireHandler.getConfig().getUpdateOrder().id();
        source.method_9226(() -> class_2561.method_43470((String)String.format("update order has been set to %s!", value)), true);
        return 1;
    }

    private static int resetProfiler(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"profiler results have been cleared!"), true);
        ProfilerResults.log();
        ProfilerResults.clear();
        return 1;
    }

    static {
        UpdateOrder[] updateOrders = UpdateOrder.values();
        UPDATE_ORDERS = new String[updateOrders.length];
        for (int i = 0; i < updateOrders.length; ++i) {
            AlternateCurrentCommand.UPDATE_ORDERS[i] = updateOrders[i].id();
        }
    }
}

