/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.favorites;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.CompoundFavoriteRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1934;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class GameModeFavoriteEntry
extends FavoriteEntry {
    public static final class_2960 ID = class_2960.method_60655((String)"roughlyenoughitems", (String)"gamemode");
    public static final String TRANSLATION_KEY = "favorite.section.gamemode";
    public static final String KEY = "mode";
    @Nullable
    private final class_1934 gameMode;

    public GameModeFavoriteEntry(@Nullable class_1934 gameMode) {
        this.gameMode = gameMode;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public Renderer getRenderer(boolean showcase) {
        if (this.gameMode == null) {
            List renderers = IntStream.range(0, 4).mapToObj(GameModeFavoriteEntry::getRenderer).collect(Collectors.toList());
            return new CompoundFavoriteRenderer(this, showcase, renderers, () -> class_310.method_1551().field_1761.method_2920().method_8379()){

                @Override
                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    return Tooltip.create(context.getPoint(), new class_2561[]{class_2561.method_43471((String)"text.rei.gamemode_button.tooltip.dropdown")});
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    return this.hashCode() == o.hashCode();
                }

                public int hashCode() {
                    return Objects.hash(this.getClass(), this.showcase);
                }
            };
        }
        return GameModeFavoriteEntry.getRenderer(this.gameMode.method_8379());
    }

    private static Renderer getRenderer(int id) {
        final class_1934 type = class_1934.method_8384((int)id);
        return new Renderer(){

            @Override
            public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color;
                int n = color = bounds.contains(mouseX, mouseY) ? -1118482 : -5592406;
                if (bounds.width > 4 && bounds.height > 4) {
                    graphics.method_51448().pushMatrix();
                    graphics.method_51448().translate((float)bounds.getCenterX(), (float)bounds.getCenterY());
                    graphics.method_51448().scale((float)bounds.getWidth() / 18.0f, (float)bounds.getHeight() / 18.0f);
                    this.renderGameModeText(graphics, type, 0, 0, color);
                    graphics.method_51448().popMatrix();
                }
            }

            private void renderGameModeText(class_332 graphics, class_1934 type2, int centerX, int centerY, int color) {
                class_5250 s = class_2561.method_43471((String)("text.rei.short_gamemode." + type2.method_8381()));
                class_327 font = class_310.method_1551().field_1772;
                graphics.method_51448().pushMatrix();
                graphics.method_51448().translate((float)centerX - (float)font.method_27525((class_5348)s) / 2.0f + 0.5f, (float)centerY - 3.5f);
                graphics.method_51439(font, (class_2561)s, 0, 0, color, false);
                graphics.method_51448().popMatrix();
            }

            @Override
            @Nullable
            public Tooltip getTooltip(TooltipContext context) {
                return Tooltip.create(context.getPoint(), new class_2561[]{class_2561.method_43469((String)"text.rei.gamemode_button.tooltip.entry", (Object[])new Object[]{type.method_8383().getString()})});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return this.hashCode() == o.hashCode();
            }

            public int hashCode() {
                return Objects.hash(this.getClass(), false, type);
            }
        };
    }

    @Override
    public boolean doAction(int button) {
        if (button == 0) {
            class_1934 mode = this.gameMode;
            if (mode == null) {
                mode = class_1934.method_8384((int)(class_310.method_1551().field_1761.method_2920().method_8379() + 1));
            }
            class_310.method_1551().field_1724.field_3944.method_45730(StringUtils.removeStart((String)ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", mode.name().toLowerCase(Locale.ROOT)), (String)"/"));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return false;
    }

    @Override
    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        if (this.gameMode == null) {
            return Optional.of(this::_getMenuEntries);
        }
        return Optional.empty();
    }

    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.filterAndMap(Arrays.asList(class_1934.values()), type -> type.method_8379() >= 0, GameModeMenuEntry::new);
    }

    @Override
    public long hashIgnoreAmount() {
        return this.gameMode == null ? 31290831290L : (long)this.gameMode.ordinal();
    }

    @Override
    public FavoriteEntry copy() {
        return this;
    }

    @Override
    public class_2960 getType() {
        return ID;
    }

    @Override
    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof GameModeFavoriteEntry)) {
            return false;
        }
        GameModeFavoriteEntry that = (GameModeFavoriteEntry)other;
        return Objects.equals(this.gameMode, that.gameMode);
    }

    public static class GameModeMenuEntry
    extends FavoriteMenuEntry {
        public final String text;
        public final class_1934 gameMode;
        private int x;
        private int y;
        private int width;
        private boolean selected;
        private boolean containsMouse;
        private boolean rendering;
        private int textWidth = -69;

        public GameModeMenuEntry(class_1934 gameMode) {
            this.text = gameMode.method_8383().getString();
            this.gameMode = gameMode;
        }

        private int getTextWidth() {
            if (this.textWidth == -69) {
                this.textWidth = Math.max(0, this.font.method_1727(this.text));
            }
            return this.textWidth;
        }

        @Override
        public int getEntryWidth() {
            return this.getTextWidth() + 4;
        }

        @Override
        public int getEntryHeight() {
            return 12;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        @Override
        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            boolean disabled;
            boolean bl = disabled = this.minecraft.field_1761.method_2920() == this.gameMode;
            if (this.selected && !disabled) {
                graphics.method_25294(this.x, this.y, this.x + this.width, this.y + 12, -12237499);
            }
            if (!disabled && this.selected && this.containsMouse) {
                REIRuntime.getInstance().queueTooltip(Tooltip.create(new class_2561[]{class_2561.method_43469((String)"text.rei.gamemode_button.tooltip.entry", (Object[])new Object[]{this.text})}));
            }
            Object s = this.text;
            if (disabled) {
                s = String.valueOf(class_124.field_1055) + (String)s;
            }
            graphics.method_51433(this.font, (String)s, this.x + 2, this.y + 2, this.selected && !disabled ? 0xFFFFFF : 0x888888, false);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            class_310.method_1551().field_1724.field_3944.method_45730(StringUtils.removeStart((String)ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", this.gameMode.name().toLowerCase(Locale.ROOT)), (String)"/"));
            this.minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.closeMenu();
            return true;
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            boolean disabled = this.minecraft.field_1761.method_2920() == this.gameMode;
            return this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12) && !disabled;
        }
    }

    public static enum Type implements FavoriteEntryType<GameModeFavoriteEntry>
    {
        INSTANCE;


        @Override
        public DataResult<GameModeFavoriteEntry> read(class_2487 object) {
            String stringValue = object.method_68564(GameModeFavoriteEntry.KEY, "NOT_SET");
            class_1934 type = stringValue.equals("NOT_SET") ? null : class_1934.valueOf((String)stringValue);
            return DataResult.success((Object)new GameModeFavoriteEntry(type), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public DataResult<GameModeFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create GameModeFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof class_1934)) {
                return DataResult.error(() -> "Creation of GameModeFavoriteEntry from args expected GameType as the first argument!");
            }
            class_1934 type = (class_1934)object;
            return DataResult.success((Object)new GameModeFavoriteEntry(type), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public class_2487 save(GameModeFavoriteEntry entry, class_2487 tag) {
            tag.method_10582(GameModeFavoriteEntry.KEY, entry.gameMode == null ? "NOT_SET" : entry.gameMode.name());
            return tag;
        }
    }
}

