/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsedStack;

public abstract class CollapsingEntryListWidget
extends EntryListWidget {
    private List<Object> collapsedStacks = new ArrayList<Object>();
    private Int2ObjectMap<CollapsedStack> collapsedStackIndexed = new Int2ObjectOpenHashMap();
    protected int updatedCount;
    protected int lastUpdatedCount;

    public abstract List<Object> getStacks();

    protected abstract void setStacks(List<Object> var1);

    protected final Int2ObjectMap<CollapsedStack> getCollapsedStackIndexed() {
        return this.collapsedStackIndexed;
    }

    @Override
    public boolean isEmpty() {
        return this.collapsedStacks.isEmpty();
    }

    @Override
    protected void setCollapsedStacks(List<Object> stacks) {
        this.collapsedStacks = stacks;
        this.updateStacks();
    }

    @Override
    public void updateEntriesPosition() {
        if (this.updatedCount != this.lastUpdatedCount) {
            this.updateStacks();
        }
        super.updateEntriesPosition();
    }

    public void updateStacks() {
        this.lastUpdatedCount = this.updatedCount;
        ArrayList<Object> stacks = new ArrayList<Object>((int)((double)this.collapsedStacks.size() * 1.5));
        Reference2ObjectOpenHashMap collapsedStackMap = new Reference2ObjectOpenHashMap();
        Int2ObjectOpenHashMap collapsedStackIndexed = new Int2ObjectOpenHashMap();
        for (Object obj : this.collapsedStacks) {
            if (obj instanceof EntryStack) {
                EntryStack entryStack = (EntryStack)obj;
                stacks.add(entryStack);
                continue;
            }
            if (!(obj instanceof CollapsedStack)) continue;
            CollapsedStack stack = (CollapsedStack)obj;
            List<EntryStack<?>> ingredient = stack.getIngredient();
            if (stack.isExpanded()) {
                stacks.addAll(ingredient);
                collapsedStackMap.put(ingredient.get(0), stack);
                continue;
            }
            stacks.add(ingredient);
            collapsedStackMap.put(ingredient, stack);
        }
        this.setStacks(stacks);
        int index = 0;
        for (Object e : stacks) {
            CollapsedStack collapsedStack = (CollapsedStack)collapsedStackMap.get(e);
            if (collapsedStack != null) {
                collapsedStackIndexed.put(index, (Object)collapsedStack);
                if (collapsedStack.isExpanded()) {
                    int size = collapsedStack.getIngredient().size();
                    for (int i = 1; i < size; ++i) {
                        collapsedStackIndexed.put(index + i, (Object)collapsedStack);
                    }
                }
            }
            ++index;
        }
        this.collapsedStackIndexed = collapsedStackIndexed;
    }
}

