/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config;

import com.google.common.base.Preconditions;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.components.ConfigEntriesListWidget;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigCategories;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import me.shedaniel.rei.impl.client.gui.config.options.OptionCategory;
import me.shedaniel.rei.impl.client.gui.config.options.OptionGroup;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.widget.basewidgets.TextFieldWidget;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class REIConfigScreen
extends class_437
implements ConfigAccess {
    private final class_437 parent;
    private final List<OptionCategory> categories;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final Map<String, ?> defaultOptions = new HashMap();
    private final Map<String, ?> options = new HashMap();
    private OptionCategory activeCategory;
    private boolean searching;
    @Nullable
    private Menu menu;
    @Nullable
    private Widget menuWidget;
    @Nullable
    private CompositeOption<ModifierKeyCode> focusedKeycodeOption = null;
    private ModifierKeyCode partialKeycode = null;

    public REIConfigScreen(class_437 parent) {
        this(parent, AllREIConfigCategories.CATEGORIES);
    }

    public REIConfigScreen(class_437 parent, List<OptionCategory> categories) {
        super((class_2561)class_2561.method_43471((String)"config.roughlyenoughitems.title"));
        this.parent = parent;
        this.categories = CollectionUtils.map(categories, OptionCategory::copy);
        this.cleanRequiresLevel();
        Preconditions.checkArgument((!this.categories.isEmpty() ? 1 : 0) != 0, (Object)"Categories cannot be empty!");
        this.activeCategory = this.categories.get(0);
        ConfigObjectImpl defaultConfig = new ConfigObjectImpl();
        ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
        for (OptionCategory category : this.categories) {
            for (OptionGroup group : category.getGroups()) {
                for (CompositeOption<?> option : group.getOptions()) {
                    this.defaultOptions.put(option.getId(), option.getBind().apply(defaultConfig));
                    this.options.put(option.getId(), option.getBind().apply(config));
                }
            }
        }
    }

    private void cleanRequiresLevel() {
        if (REIRuntime.getInstance().getPreviousContainerScreen() != null && class_310.method_1551().method_1562() != null) {
            return;
        }
        for (OptionCategory category : this.categories) {
            for (OptionGroup group : category.getGroups()) {
                group.getOptions().replaceAll(option -> {
                    if (option.isRequiresLevel()) {
                        return new CompositeOption<Integer>(option.getId(), option.getName(), option.getDescription(), i -> 0, (i, v) -> new Object()).entry(value -> ConfigUtils.translatable("config.rei.texts.requires_level").method_27692(class_124.field_1061)).defaultValue(() -> 1);
                    }
                    return option;
                });
            }
        }
    }

    public void method_25426() {
        super.method_25426();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Alpha REI Build: Config not yet implemented!"), false);
            player.method_7353((class_2561)class_2561.method_43470((String)"Click here to open the config file...").method_27695(new class_124[]{class_124.field_1073, class_124.field_1075}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10607(Platform.getConfigFolder().resolve("roughlyenoughitems")))), false);
        }
        class_310.method_1551().method_1507(null);
    }

    private Widget createEntriesList(boolean singlePane, int singleSideWidth, int sideWidth) {
        return ConfigEntriesListWidget.create(this, new Rectangle(singlePane ? 8 + singleSideWidth : 12 + sideWidth, 32, singlePane ? this.field_22789 - 16 - singleSideWidth : this.field_22789 - 20 - sideWidth, this.field_22790 - 32 - 32), this.activeCategory.getGroups());
    }

    public Map<String, ?> getDefaultOptions() {
        return this.defaultOptions;
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.method_25394(graphics, mouseX, mouseY, delta);
        }
        ScreenOverlayImpl.getInstance().lateRender(graphics, mouseX, mouseY, delta);
    }

    public void method_25419() {
        if (this.searching) {
            this.setSearching(false);
        } else {
            this.field_22787.method_1507(this.parent);
        }
    }

    public List<? extends class_364> method_25396() {
        return this.widgets;
    }

    public boolean method_25400(char character, int modifiers) {
        if (this.menu != null && this.menu.method_25400(character, modifiers)) {
            return true;
        }
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25400(character, modifiers)) continue;
            return true;
        }
        return super.method_25400(character, modifiers);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.menu != null && this.menu.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25403(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.menu != null) {
            if (!this.menu.method_25402(mouseX, mouseY, button)) {
                this.closeMenu();
            }
            return true;
        }
        if (this.focusedKeycodeOption != null && this.partialKeycode != null) {
            if (this.partialKeycode.isUnknown()) {
                this.partialKeycode.setKeyCode(class_3675.class_307.field_1672.method_1447(button));
            } else if (this.partialKeycode.getType() == class_3675.class_307.field_1668) {
                Modifier modifier = this.partialKeycode.getModifier();
                int code = this.partialKeycode.getKeyCode().method_1444();
                if (class_310.field_1703 ? code == 343 || code == 347 : code == 341 || code == 345) {
                    this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)true, (boolean)modifier.hasShift()));
                    this.partialKeycode.setKeyCode(class_3675.class_307.field_1672.method_1447(button));
                    return true;
                }
                if (code == 344 || code == 340) {
                    this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)modifier.hasControl(), (boolean)true));
                    this.partialKeycode.setKeyCode(class_3675.class_307.field_1672.method_1447(button));
                    return true;
                }
                if (code == 342 || code == 346) {
                    this.partialKeycode.setModifier(Modifier.of((boolean)true, (boolean)modifier.hasControl(), (boolean)modifier.hasShift()));
                    this.partialKeycode.setKeyCode(class_3675.class_307.field_1672.method_1447(button));
                    return true;
                }
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public Optional<class_364> method_19355(double mouseX, double mouseY) {
        if (this.menu != null && this.menu.containsMouse(mouseX, mouseY)) {
            return Optional.of(this.menu);
        }
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.containsMouse(mouseX, mouseY)) continue;
            return Optional.of(widget);
        }
        return Optional.empty();
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.menu != null && this.menu.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (this.focusedKeycodeOption != null && this.partialKeycode != null && !this.partialKeycode.isUnknown()) {
            this.set(this.focusedKeycodeOption, this.partialKeycode);
            this.focusKeycode(null);
            return true;
        }
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25406(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.menu != null && this.menu.method_25401(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        for (class_364 class_3642 : this.method_25396()) {
            if (!class_3642.method_25401(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.focusedKeycodeOption != null) {
            if (keyCode != 256) {
                if (this.partialKeycode.isUnknown()) {
                    this.partialKeycode.setKeyCode(class_3675.method_15985((int)keyCode, (int)scanCode));
                } else {
                    Modifier modifier = this.partialKeycode.getModifier();
                    if (this.partialKeycode.getType() == class_3675.class_307.field_1668) {
                        int code = this.partialKeycode.getKeyCode().method_1444();
                        if (class_310.field_1703 ? code == 343 || code == 347 : code == 341 || code == 345) {
                            this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)true, (boolean)modifier.hasShift()));
                            this.partialKeycode.setKeyCode(class_3675.method_15985((int)keyCode, (int)scanCode));
                            return true;
                        }
                        if (code == 344 || code == 340) {
                            this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)modifier.hasControl(), (boolean)true));
                            this.partialKeycode.setKeyCode(class_3675.method_15985((int)keyCode, (int)scanCode));
                            return true;
                        }
                        if (code == 342 || code == 346) {
                            this.partialKeycode.setModifier(Modifier.of((boolean)true, (boolean)modifier.hasControl(), (boolean)modifier.hasShift()));
                            this.partialKeycode.setKeyCode(class_3675.method_15985((int)keyCode, (int)scanCode));
                            return true;
                        }
                    }
                    if (class_310.field_1703 ? keyCode == 343 || keyCode == 347 : keyCode == 341 || keyCode == 345) {
                        this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)true, (boolean)modifier.hasShift()));
                        return true;
                    }
                    if (keyCode == 344 || keyCode == 340) {
                        this.partialKeycode.setModifier(Modifier.of((boolean)modifier.hasAlt(), (boolean)modifier.hasControl(), (boolean)true));
                        return true;
                    }
                    if (keyCode == 342 || keyCode == 346) {
                        this.partialKeycode.setModifier(Modifier.of((boolean)true, (boolean)modifier.hasControl(), (boolean)modifier.hasShift()));
                        return true;
                    }
                }
            } else {
                this.set(this.focusedKeycodeOption, ModifierKeyCode.unknown());
                this.focusKeycode(null);
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.focusedKeycodeOption != null && this.partialKeycode != null) {
            this.set(this.focusedKeycodeOption, this.partialKeycode);
            this.focusKeycode(null);
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    @Override
    public void openMenu(Menu menu) {
        if (this.menu != null) {
            this.widgets.remove(this.menuWidget);
        }
        this.menu = menu;
        this.menuWidget = menu;
        this.widgets.add(this.menuWidget);
    }

    @Override
    public void closeMenu() {
        this.widgets.remove(this.menuWidget);
        this.menu = null;
        this.menuWidget = null;
    }

    @Override
    public <T> T get(CompositeOption<T> option) {
        return (T)this.getOptions().get(option.getId());
    }

    @Override
    public <T> void set(CompositeOption<T> option, T value) {
        this.getOptions().put(option.getId(), value);
    }

    @Override
    public <T> T getDefault(CompositeOption<T> option) {
        return (T)this.getDefaultOptions().get(option.getId());
    }

    @Override
    public void focusKeycode(CompositeOption<ModifierKeyCode> option) {
        this.focusedKeycodeOption = option;
        if (this.focusedKeycodeOption != null) {
            this.partialKeycode = this.get(this.focusedKeycodeOption);
            this.partialKeycode.setKeyCodeAndModifier(class_3675.field_16237, Modifier.none());
        } else {
            this.partialKeycode = null;
        }
    }

    @Override
    @Nullable
    public CompositeOption<ModifierKeyCode> getFocusedKeycode() {
        return this.focusedKeycodeOption;
    }

    public void setSearching(boolean searching) {
        this.searching = searching;
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    public boolean isSearching() {
        return this.searching;
    }

    private /* synthetic */ void lambda$init$9(Button button) {
        for (OptionCategory optionCategory : this.categories) {
            for (OptionGroup group : optionCategory.getGroups()) {
                for (CompositeOption<?> option : group.getOptions()) {
                    option.getSave().accept(ConfigManagerImpl.getInstance().getConfig(), this.get(option));
                }
            }
        }
        ConfigManagerImpl.getInstance().saveConfig();
        EntryRegistry.getInstance().refilter();
        REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
        if (REIRuntimeImpl.getSearchField() != null) {
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        }
        class_310.method_1551().method_1507(this.parent);
    }

    private /* synthetic */ void lambda$init$8(Button button) {
        class_310.method_1551().method_1507(this.parent);
    }

    private static /* synthetic */ void lambda$init$7(TextFieldWidget textField, class_332 graphics, int mouseX, int mouseY, float delta) {
        textField.setSuggestion(!textField.method_25370() && textField.getText().isEmpty() ? class_1074.method_4662((String)"config.rei.texts.search_options", (Object[])new Object[0]) : null);
        if (!textField.method_25370()) {
            return;
        }
        Rectangle bounds = textField.getBounds();
        graphics.method_25294(bounds.x - 6, bounds.y - 6, bounds.getMaxX() + 4, bounds.y - 5, -2039584);
        graphics.method_25294(bounds.x - 6, bounds.getMaxY() + 1, bounds.getMaxX() + 4, bounds.getMaxY() + 2, -2039584);
        graphics.method_25294(bounds.x - 6, bounds.y - 6, bounds.x - 7, bounds.getMaxY() + 2, -2039584);
        graphics.method_25294(bounds.getMaxX() + 3, bounds.y - 6, bounds.getMaxX() + 4, bounds.getMaxY() + 2, -2039584);
    }

    private /* synthetic */ void lambda$init$6(Button button) {
        this.setSearching(false);
    }
}

