/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.plugins;

import dev.architectury.utils.EnvExecutor;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.registry.ParentReloadable;
import me.shedaniel.rei.api.common.registry.Reloadable;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.Internals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.ApiStatus;

public interface PluginManager<P extends REIPlugin<?>>
extends ParentReloadable<P> {
    @Environment(value=EnvType.CLIENT)
    public static PluginManager<REIClientPlugin> getClientInstance() {
        return ClientInternals.getPluginManager();
    }

    public static PluginManager<REICommonPlugin> getInstance() {
        return Internals.getPluginManager();
    }

    public static List<PluginManager<? extends REIPlugin<?>>> getActiveInstances() {
        return (List)EnvExecutor.getEnvSpecific(() -> () -> List.of(PluginManager.getInstance(), PluginManager.getClientInstance()), () -> () -> List.of(PluginManager.getInstance()));
    }

    public static boolean areAnyReloading() {
        return CollectionUtils.anyMatch(PluginManager.getActiveInstances(), PluginManager::isReloading);
    }

    public boolean isReloading();

    public <T extends Reloadable<? super P>> T get(Class<T> var1);

    public List<REIPluginProvider<P>> getPluginProviders();

    public Iterable<P> getPlugins();

    @ApiStatus.Internal
    public PluginView<P> view();
}

