/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9887;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.client.recipe.CookingPotRecipeDisplay;
import vectorwing.farmersdelight.common.crafting.CookingPotBookCategory;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModRecipeBookCategories;
import vectorwing.farmersdelight.common.registry.ModRecipeSerializers;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;
import vectorwing.farmersdelight.refabricated.inventory.RecipeWrapper;

public class CookingPotRecipe
implements class_1860<RecipeWrapper> {
    private final String group;
    private final CookingPotBookCategory category;
    private final List<class_1856> inputItems;
    private final class_1799 result;
    private final class_1799 container;
    private final class_1799 containerOverride;
    private final float experience;
    private final int cookTime;
    private class_9887 placementInfo;

    public CookingPotRecipe(String group, @Nullable CookingPotBookCategory tab, List<class_1856> inputItems, class_1799 output, class_1799 container, float experience, int cookTime) {
        this.group = group;
        this.category = tab;
        this.inputItems = inputItems;
        this.result = output;
        this.container = !container.method_7960() ? container : (!output.getRecipeRemainder().method_7960() ? output.getRecipeRemainder() : class_1799.field_8037);
        this.containerOverride = container;
        this.experience = experience;
        this.cookTime = cookTime;
    }

    public List<class_1856> input() {
        return this.inputItems;
    }

    public class_1799 result() {
        return this.result;
    }

    @Nullable
    public CookingPotBookCategory category() {
        return this.category;
    }

    public class_1799 container() {
        return this.container;
    }

    public class_1799 containerOverride() {
        return this.containerOverride;
    }

    public class_1799 assemble(RecipeWrapper inv, class_7225.class_7874 provider) {
        return this.result.method_7972();
    }

    public class_1865<? extends class_1860<RecipeWrapper>> method_8119() {
        return ModRecipeSerializers.COOKING.get();
    }

    public class_3956<? extends class_1860<RecipeWrapper>> method_17716() {
        return ModRecipeTypes.COOKING.get();
    }

    public List<class_10295> method_64664() {
        return List.of(new CookingPotRecipeDisplay(this.input().stream().map(class_1856::method_64673).toList(), this.container.method_7960() ? Optional.empty() : Optional.of(new class_10302.class_10307(this.container)), (class_10302)new class_10302.class_10307(this.result()), (class_10302)new class_10302.class_10306(ModItems.COOKING_POT.get()), this.cookTime, this.experience));
    }

    public class_9887 method_61671() {
        if (this.placementInfo == null) {
            this.placementInfo = class_9887.method_61686(this.inputItems);
        }
        return this.placementInfo;
    }

    public class_10355 method_64668() {
        return switch (this.category()) {
            default -> throw new IncompatibleClassChangeError();
            case CookingPotBookCategory.MEALS -> ModRecipeBookCategories.COOKING_MEALS.get();
            case CookingPotBookCategory.DRINKS -> ModRecipeBookCategories.COOKING_DRINKS.get();
            case CookingPotBookCategory.MISC -> ModRecipeBookCategories.COOKING_MISC.get();
        };
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public boolean matches(RecipeWrapper inv, class_1937 level) {
        return inv.ingredientAmount() == this.inputItems.size() && inv.stackedContents().method_61538((class_1860)this, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CookingPotRecipe that = (CookingPotRecipe)o;
        if (Float.compare(that.getExperience(), this.getExperience()) != 0) {
            return false;
        }
        if (this.getCookTime() != that.getCookTime()) {
            return false;
        }
        if (!this.method_8112().equals(that.method_8112())) {
            return false;
        }
        if (this.category != that.category) {
            return false;
        }
        if (!this.inputItems.equals(that.inputItems)) {
            return false;
        }
        if (!this.result.equals(that.result)) {
            return false;
        }
        return this.container.equals(that.container);
    }

    public int hashCode() {
        int result = this.method_8112().hashCode();
        result = 31 * result + (this.category() != null ? this.category().hashCode() : 0);
        result = 31 * result + this.inputItems.hashCode();
        result = 31 * result + this.result.hashCode();
        result = 31 * result + this.container.hashCode();
        result = 31 * result + (this.getExperience() != 0.0f ? Float.floatToIntBits(this.getExperience()) : 0);
        result = 31 * result + this.getCookTime();
        return result;
    }

    public static class Serializer
    implements class_1865<CookingPotRecipe> {
        private static final MapCodec<CookingPotRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1860::method_8112), (App)CookingPotBookCategory.CODEC.optionalFieldOf("category", (Object)CookingPotBookCategory.MISC).forGetter(CookingPotRecipe::category), (App)class_1856.field_46095.listOf(1, 6).fieldOf("ingredients").forGetter(CookingPotRecipe::input), (App)class_1799.field_51397.fieldOf("result").forGetter(r -> r.result), (App)class_1799.field_51397.optionalFieldOf("container", (Object)class_1799.field_8037).forGetter(CookingPotRecipe::containerOverride), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(CookingPotRecipe::getExperience), (App)Codec.INT.optionalFieldOf("cookingtime", (Object)200).forGetter(CookingPotRecipe::getCookTime)).apply((Applicative)inst, CookingPotRecipe::new));
        public static final class_9139<class_9129, CookingPotRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CookingPotRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CookingPotRecipe> method_56104() {
            return STREAM_CODEC;
        }

        private static CookingPotRecipe fromNetwork(class_9129 buffer) {
            String groupIn = buffer.method_19772();
            CookingPotBookCategory tabIn = (CookingPotBookCategory)((Object)CookingPotBookCategory.STREAM_CODEC.decode((Object)buffer));
            List inputItemsIn = (List)class_1856.field_48355.method_56433(class_9135.method_58000((int)6)).decode((Object)buffer);
            class_1799 outputIn = (class_1799)class_1799.field_48349.decode((Object)buffer);
            class_1799 container = (class_1799)class_1799.field_49268.decode((Object)buffer);
            float experienceIn = buffer.readFloat();
            int cookTimeIn = buffer.method_10816();
            return new CookingPotRecipe(groupIn, tabIn, inputItemsIn, outputIn, container, experienceIn, cookTimeIn);
        }

        private static void toNetwork(class_9129 buffer, CookingPotRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10814(recipe.category != null ? recipe.category.toString() : "");
            class_1856.field_48355.method_56433(class_9135.method_58000((int)6)).encode((Object)buffer, recipe.inputItems);
            class_1799.field_48349.encode((Object)buffer, (Object)recipe.result);
            class_1799.field_49268.encode((Object)buffer, (Object)recipe.container);
            buffer.method_52941(recipe.experience);
            buffer.method_10804(recipe.cookTime);
        }
    }
}

