/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.awt.Rectangle;
import java.util.Objects;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.mixin.MultiPlayerGameModeAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_636;

public enum BreakProgressProvider implements IEventListener
{
    INSTANCE;

    boolean wasBreaking = false;
    float progressDelayTimer = 0.0f;
    float lastProgress = 0.0f;
    float lastTargetProgress = 0.0f;

    @Override
    public void onAfterTooltipRender(class_332 ctx, Rectangle rect, ICommonAccessor accessor, IPluginConfig config) {
        boolean isInDelay;
        if (!config.getBoolean(Options.BREAKING_PROGRESS)) {
            return;
        }
        class_636 gameMode = Objects.requireNonNull(class_310.method_1551().field_1761);
        MultiPlayerGameModeAccess gameModeAccess = (MultiPlayerGameModeAccess)gameMode;
        float dt = class_310.method_1551().method_61966().method_60638();
        boolean isBreaking = gameMode.method_2923();
        float targetProgress = gameModeAccess.wthit_destroyProgress();
        if (!isBreaking && this.wasBreaking && this.progressDelayTimer <= 0.0f) {
            this.progressDelayTimer = 4.0f;
        }
        boolean bl = isInDelay = this.progressDelayTimer > 0.0f;
        if (isInDelay) {
            targetProgress = gameModeAccess.wthit_destroyDelay() > 0 ? 1.0f : this.lastTargetProgress;
        }
        float progressDiff = targetProgress - this.lastProgress;
        float progressChangeAmount = progressDiff * dt;
        float actualProgress = class_3532.method_15363((float)(this.lastProgress + progressChangeAmount), (float)0.0f, (float)1.0f);
        float lineLength = 0.0f;
        lineLength = config.getBoolean(Options.BREAKING_PROGRESS_BOTTOM_ONLY) ? (float)(rect.width - 2) * actualProgress : (float)((rect.width + rect.height - 4) * 2) * actualProgress;
        if (lineLength >= 1.0f) {
            int hLength = rect.width - 2;
            int vLength = rect.height - 4;
            int x = rect.x + 1;
            int y = rect.y + rect.height - 2;
            int color = config.getInt(Options.BREAKING_PROGRESS_COLOR);
            ctx.method_51738(x, x + (int)Math.min(lineLength, (float)hLength) - 1, y, color);
            lineLength -= (float)hLength;
            if (lineLength > 0.0f) {
                x = rect.x + rect.width - 2;
                y = rect.y + rect.height - 2;
                ctx.method_51742(x, y, y - (int)Math.min(lineLength, (float)vLength) - 1, color);
                lineLength -= (float)vLength;
                if (lineLength > 0.0f) {
                    x = rect.x + rect.width - 2;
                    y = rect.y + 1;
                    ctx.method_51738(x, x - (int)Math.min(lineLength, (float)hLength) + 1, y, color);
                    lineLength -= (float)hLength;
                    if (lineLength > 0.0f) {
                        x = rect.x + 1;
                        y = rect.y + 1;
                        ctx.method_51742(x, y, y + (int)Math.min(lineLength, (float)vLength) + 1, color);
                    }
                }
            }
        }
        this.wasBreaking = isBreaking;
        this.lastProgress = actualProgress;
        this.lastTargetProgress = targetProgress;
        if (isInDelay) {
            this.progressDelayTimer -= dt;
        }
    }
}

