/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.theme;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeAccessor;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.api.util.WRenders;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class NinePatchTheme
implements ITheme {
    public static final IThemeType<NinePatchTheme> TYPE = IThemeType.of(NinePatchTheme.class).property("texture", "waila:textures/ninepatch_example.png").property("useResourcePack", true).property("textColor", IntFormat.RGB_HEX, 0xA0A0A0).property("textureWidth", 16).property("textureHeight", 16).property("regionTop", 3).property("regionBottom", 3).property("regionLeft", 3).property("regionRight", 3).property("mode", Mode.STRETCH).build();
    private static final class_2960 PATH_TEXTURE_ID = class_2960.method_60655((String)"waila", (String)"nine_patch_path");
    private String texture;
    private boolean useResourcePack;
    private int textColor;
    private int textureWidth;
    private int textureHeight;
    private int regionTop;
    private int regionBottom;
    private int regionLeft;
    private int regionRight;
    private Mode mode;
    private class_11231 textureSetup;
    private float uCenter;
    private float uRight;
    private float vMiddle;
    private float vBottom;

    @Override
    public void processProperties(IThemeAccessor accessor) {
        this.textColor = class_3532.method_15340((int)this.textColor, (int)0, (int)0xFFFFFF);
        this.regionTop = class_3532.method_15340((int)this.regionTop, (int)0, (int)this.textureHeight);
        this.regionBottom = class_3532.method_15340((int)this.regionBottom, (int)0, (int)(this.textureHeight - this.regionTop));
        this.regionLeft = class_3532.method_15340((int)this.regionLeft, (int)0, (int)this.textureWidth);
        this.regionRight = class_3532.method_15340((int)this.regionRight, (int)0, (int)(this.textureWidth - this.regionLeft));
        class_1060 textureManager = class_310.method_1551().method_1531();
        if (this.useResourcePack) {
            this.textureSetup = class_11231.method_70900((GpuTextureView)textureManager.method_4619(class_2960.method_60654((String)this.texture)).method_71659());
        } else {
            try {
                class_1011 image = class_1011.method_4309((InputStream)Files.newInputStream(accessor.getPath(this.texture), new OpenOption[0]));
                this.textureSetup = class_11231.method_70900((GpuTextureView)new class_1043(() -> "WTHIT NinePatchTheme", image).method_71659());
            }
            catch (Exception e) {
                this.textureSetup = class_11231.method_70900((GpuTextureView)textureManager.method_4619(class_1060.field_5285).method_71659());
            }
        }
        float tw = this.textureWidth;
        float th = this.textureHeight;
        this.uCenter = (float)this.regionLeft / tw;
        this.uRight = (tw - (float)this.regionRight) / tw;
        this.vMiddle = (float)this.regionTop / th;
        this.vBottom = (th - (float)this.regionBottom) / th;
    }

    @Override
    public int getDefaultTextColor() {
        return this.textColor;
    }

    @Override
    public void setPadding(ITheme.Padding padding) {
        padding.set(this.regionTop, this.regionRight, this.regionBottom, this.regionLeft);
    }

    @Override
    public void renderTooltipBackground(class_332 ctx, int x, int y, int width, int height, @Range(from=0L, to=255L) int alpha, class_9779 delta) {
        WRenders.state(ctx).method_70919((class_11244)new RenderState(alpha, new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), new class_8030(x, y, width, height)));
    }

    private class RenderState
    implements class_11244 {
        final int alpha;
        final Matrix3x2f matrix;
        final class_8030 bounds;

        private RenderState(int alpha, Matrix3x2f matrix, class_8030 bounds) {
            this.alpha = alpha;
            this.matrix = matrix;
            this.bounds = bounds;
        }

        @Nullable
        public class_8030 comp_4274() {
            return this.bounds;
        }

        public void method_70917(class_4588 buf, float z) {
            int x = this.bounds.method_49620();
            int y = this.bounds.method_49618();
            int width = this.bounds.comp_1196();
            int height = this.bounds.comp_1197();
            this.patch(buf, this.matrix, x, y, z, NinePatchTheme.this.regionLeft, NinePatchTheme.this.regionTop, 0.0f, NinePatchTheme.this.uCenter, 0.0f, NinePatchTheme.this.vMiddle, this.alpha);
            this.patch(buf, this.matrix, x + width, y, z, -NinePatchTheme.this.regionRight, NinePatchTheme.this.regionTop, NinePatchTheme.this.uRight, 1.0f, 0.0f, NinePatchTheme.this.vMiddle, this.alpha);
            this.patch(buf, this.matrix, x, y + height, z, NinePatchTheme.this.regionLeft, -NinePatchTheme.this.regionBottom, 0.0f, NinePatchTheme.this.uCenter, NinePatchTheme.this.vBottom, 1.0f, this.alpha);
            this.patch(buf, this.matrix, x + width, y + height, z, -NinePatchTheme.this.regionRight, -NinePatchTheme.this.regionBottom, NinePatchTheme.this.uRight, 1.0f, NinePatchTheme.this.vBottom, 1.0f, this.alpha);
            int centerX = x + NinePatchTheme.this.regionLeft;
            int centerY = y + NinePatchTheme.this.regionTop;
            int centerWidth = width - (NinePatchTheme.this.regionLeft + NinePatchTheme.this.regionRight);
            int centerHeight = height - (NinePatchTheme.this.regionTop + NinePatchTheme.this.regionBottom);
            block0 : switch (NinePatchTheme.this.mode.ordinal()) {
                case 0: {
                    int regionCenter = NinePatchTheme.this.textureWidth - (NinePatchTheme.this.regionLeft + NinePatchTheme.this.regionRight);
                    int regionMiddle = NinePatchTheme.this.textureHeight - (NinePatchTheme.this.regionTop + NinePatchTheme.this.regionBottom);
                    int maxX = Math.max(x + width - NinePatchTheme.this.regionRight, 0);
                    int maxY = Math.max(y + height - NinePatchTheme.this.regionBottom, 0);
                    for (int cx = centerX; cx < maxX; cx += regionCenter) {
                        int clampedCenter = Math.min(regionCenter, maxX - cx);
                        float uCenter1 = (float)(NinePatchTheme.this.regionLeft + clampedCenter) / (float)NinePatchTheme.this.textureWidth;
                        this.patch(buf, this.matrix, cx, y, z, clampedCenter, NinePatchTheme.this.regionTop, NinePatchTheme.this.uCenter, uCenter1, 0.0f, NinePatchTheme.this.vMiddle, this.alpha);
                        this.patch(buf, this.matrix, cx, maxY, z, clampedCenter, NinePatchTheme.this.regionBottom, NinePatchTheme.this.uCenter, uCenter1, NinePatchTheme.this.vBottom, 1.0f, this.alpha);
                        for (int cy = centerY; cy < maxY; cy += regionMiddle) {
                            int clampedMiddle = Math.min(regionMiddle, maxY - cy);
                            float vMiddle1 = (float)(NinePatchTheme.this.regionTop + clampedMiddle) / (float)NinePatchTheme.this.textureWidth;
                            if (cx == centerX) {
                                this.patch(buf, this.matrix, x, cy, z, NinePatchTheme.this.regionLeft, clampedMiddle, 0.0f, NinePatchTheme.this.uCenter, NinePatchTheme.this.vMiddle, vMiddle1, this.alpha);
                                this.patch(buf, this.matrix, centerX + centerWidth, cy, z, NinePatchTheme.this.regionRight, clampedMiddle, NinePatchTheme.this.uRight, 1.0f, NinePatchTheme.this.vMiddle, vMiddle1, this.alpha);
                            }
                            this.patch(buf, this.matrix, cx, cy, z, clampedCenter, clampedMiddle, NinePatchTheme.this.uCenter, uCenter1, NinePatchTheme.this.vMiddle, vMiddle1, this.alpha);
                            if (regionMiddle <= 0) break;
                        }
                        if (regionCenter <= 0) break block0;
                    }
                    break;
                }
                case 1: {
                    this.patch(buf, this.matrix, centerX, y, z, centerWidth, NinePatchTheme.this.regionTop, NinePatchTheme.this.uCenter, NinePatchTheme.this.uRight, 0.0f, NinePatchTheme.this.vMiddle, this.alpha);
                    this.patch(buf, this.matrix, x, centerY, z, NinePatchTheme.this.regionLeft, centerHeight, 0.0f, NinePatchTheme.this.uCenter, NinePatchTheme.this.vMiddle, NinePatchTheme.this.vBottom, this.alpha);
                    this.patch(buf, this.matrix, centerX, centerY, z, centerWidth, centerHeight, NinePatchTheme.this.uCenter, NinePatchTheme.this.uRight, NinePatchTheme.this.vMiddle, NinePatchTheme.this.vBottom, this.alpha);
                    this.patch(buf, this.matrix, centerX + centerWidth, centerY, z, NinePatchTheme.this.regionRight, centerHeight, NinePatchTheme.this.uRight, 1.0f, NinePatchTheme.this.vMiddle, NinePatchTheme.this.vBottom, this.alpha);
                    this.patch(buf, this.matrix, centerX, centerY + centerHeight, z, centerWidth, NinePatchTheme.this.regionBottom, NinePatchTheme.this.uCenter, NinePatchTheme.this.uRight, NinePatchTheme.this.vBottom, 1.0f, this.alpha);
                }
            }
        }

        private void patch(class_4588 buf, Matrix3x2f matrix, int x0, int y0, float z, int w, int h, float u0, float u1, float v0, float v1, int alpha) {
            if (w == 0 || h == 0) {
                return;
            }
            int x1 = x0 + w;
            int y1 = y0 + h;
            if (x1 < x0) {
                int x0r = x0;
                x0 = x1;
                x1 = x0r;
            }
            if (y1 < y0) {
                int y0r = y0;
                y0 = y1;
                y1 = y0r;
            }
            buf.method_70815(matrix, (float)x0, (float)y1, z).method_22913(u0, v1).method_1336(255, 255, 255, alpha);
            buf.method_70815(matrix, (float)x1, (float)y1, z).method_22913(u1, v1).method_1336(255, 255, 255, alpha);
            buf.method_70815(matrix, (float)x1, (float)y0, z).method_22913(u1, v0).method_1336(255, 255, 255, alpha);
            buf.method_70815(matrix, (float)x0, (float)y0, z).method_22913(u0, v0).method_1336(255, 255, 255, alpha);
        }

        public RenderPipeline comp_4055() {
            return class_10799.field_56883;
        }

        public class_11231 comp_4056() {
            return NinePatchTheme.this.textureSetup;
        }

        @Nullable
        public class_8030 comp_4069() {
            return null;
        }
    }

    public static enum Mode {
        TILE,
        STRETCH;

    }
}

