/*
 * Decompiled with CFR 0.152.
 */
package net.iamaprogrammer.toggleableitemframes.compat.modmenu.screen;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.iamaprogrammer.toggleableitemframes.ToggleableItemFrames;
import net.iamaprogrammer.toggleableitemframes.compat.modmenu.screen.ConfigItem;
import net.iamaprogrammer.toggleableitemframes.compat.modmenu.widgets.IntSliderWidget;
import net.iamaprogrammer.toggleableitemframes.config.core.Config;
import net.iamaprogrammer.toggleableitemframes.config.core.ConfigUtil;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5676;
import net.minecraft.class_9848;

public class ConfigScreen<C extends Config>
extends class_437 {
    private static final int MARGIN_TOP = 10;
    private static final int SPACE_FOR_TEXT = 10;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 150;
    private final class_437 parentScreen;
    private final SaveCallback<C> saveCallback;
    private final C config;
    private final Class<C> configClass;
    private final List<ConfigItem> widgets;

    protected ConfigScreen(class_437 parentScreen, SaveCallback<C> saveCallback, C config, Class<C> configClass, class_2561 title, List<ConfigItem> widgets) {
        super(title);
        this.parentScreen = parentScreen;
        this.saveCallback = saveCallback;
        this.config = config;
        this.configClass = configClass;
        this.widgets = widgets;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)this.saveButton());
        this.method_37063((class_364)this.cancelButton());
        for (int i = 0; i < this.widgets.size(); ++i) {
            ConfigItem configItem = this.widgets.get(i);
            class_339 widget = configItem.getWidget();
            int posX = this.field_22789 / 2 - 75;
            int posY = 40 * i + 10 + 10;
            widget.method_48229(posX, posY);
            this.method_37063((class_364)widget);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            int posX = this.field_22789 / 2 - 75;
            int posY = 40 * i + 10;
            class_2561 text = this.widgets.get(i).getLabel();
            context.method_51439(this.field_22793, text, posX, posY, class_9848.method_61317((float)1.0f), true);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private class_4185 saveButton() {
        return class_4185.method_46430((class_2561)class_2561.method_43471((String)"toggleableitemframes.option.save"), button -> {
            this.closeScreen();
            if (!ConfigUtil.save(this.config)) {
                ToggleableItemFrames.LOGGER.error("Could not save config.");
            } else {
                Path path = Path.of(ConfigUtil.CONFIG_PATH.toString(), this.config.fileName() + ".json");
                this.saveCallback.onSave(ConfigUtil.load(path, this.configClass));
            }
        }).method_46437(150, 20).method_46433((this.field_22789 / 2 - 150) / 2 + this.field_22789 / 2, this.field_22790 - 20).method_46431();
    }

    private class_4185 cancelButton() {
        return class_4185.method_46430((class_2561)class_2561.method_43471((String)"toggleableitemframes.option.cancel"), button -> this.closeScreen()).method_46437(150, 20).method_46433((this.field_22789 / 2 - 150) / 2, this.field_22790 - 20).method_46431();
    }

    private void closeScreen() {
        this.method_25419();
        class_310.method_1551().method_1507(this.parentScreen);
    }

    public static <C extends Config> Builder<C> builder(class_437 parentScreen, C config, Class<C> configClass, SaveCallback<C> saveCallback) {
        return new Builder<C>(parentScreen, config, configClass, saveCallback);
    }

    public static interface SaveCallback<C> {
        public void onSave(C var1);
    }

    public static class Builder<C extends Config> {
        private final class_437 parentScreen;
        private final C config;
        private final Class<C> configClass;
        private final SaveCallback<C> saveCallback;
        private final List<ConfigItem> widgets = new ArrayList<ConfigItem>();

        public Builder(class_437 parentScreen, C config, Class<C> configClass, SaveCallback<C> saveCallback) {
            this.parentScreen = parentScreen;
            this.config = config;
            this.configClass = configClass;
            this.saveCallback = saveCallback;
        }

        public ConfigScreen<C> build() {
            return new ConfigScreen<C>(this.parentScreen, this.saveCallback, this.config, this.configClass, (class_2561)class_2561.method_43470((String)"Config"), this.widgets);
        }

        public <T> Builder<C> addCyclingButtonWidget(class_2561 desc, List<T> values, UpdateCallback<C, T> callback, LoadCallback<C, T> loadCallback) {
            class_5676 widget = class_5676.method_32606(val -> class_2561.method_30163((String)String.valueOf(val))).method_32620(values).method_32617(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"toggleableitemframes.option.value"), (button, value) -> callback.modifyConfigCallback(this.config, value));
            widget.method_32605(loadCallback.onLoad(this.config));
            this.widgets.add(new ConfigItem(desc, (class_339)widget));
            return this;
        }

        public Builder<C> addSliderWidget(class_2561 desc, int min, int max, UpdateCallback<C, Integer> callback, LoadCallback<C, Integer> loadCallback) {
            IntSliderWidget<C> widget = IntSliderWidget.builder(this.config).setBounds(min, max).setSize(150, 20).defaultValue(loadCallback.onLoad(this.config)).build(callback);
            this.widgets.add(new ConfigItem(desc, (class_339)widget));
            return this;
        }
    }

    public static interface LoadCallback<C, T> {
        public T onLoad(C var1);
    }

    public static interface UpdateCallback<C, T> {
        public void modifyConfigCallback(C var1, T var2);
    }
}

