/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.entity;

import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import net.frozenblock.lib.wind.api.WindDisturbingEntity;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawner;
import net.frozenblock.trailiertales.block.entity.coffin.impl.EntityCoffinInterface;
import net.frozenblock.trailiertales.entity.ThrownItemProjectile;
import net.frozenblock.trailiertales.entity.ai.apparition.ApparitionAi;
import net.frozenblock.trailiertales.mod_compat.FrozenLibIntegration;
import net.frozenblock.trailiertales.particle.options.GlowingDustColorTransitionOptions;
import net.frozenblock.trailiertales.registry.TTMemoryModuleTypes;
import net.frozenblock.trailiertales.registry.TTSounds;
import net.frozenblock.trailiertales.tag.TTEntityTags;
import net.minecraft.class_10209;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_3856;
import net.minecraft.class_3902;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6067;
import net.minecraft.class_7;
import net.minecraft.class_8103;
import net.minecraft.class_9463;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Apparition
extends class_1588
implements class_6067,
class_1603,
WindDisturbingEntity {
    private static final Vector3f BASE_DUST_COLOR = new Vector3f(0.63529414f, 0.70980394f, 0.8509804f);
    private static final Vector3f AID_DUST_COLOR = new Vector3f(0.09411765f, 0.9882353f, 1.0f);
    private static final Vector3f POLTERGEIST_DUST_COLOR = new Vector3f(0.87058824f, 0.6156863f, 0.8784314f);
    private static final Vector3f WHITE = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final class_2940<class_1799> ITEM_STACK = class_2945.method_12791(Apparition.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Float> TRANSPARENCY = class_2945.method_12791(Apparition.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> OUTER_TRANSPARENCY = class_2945.method_12791(Apparition.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> AID_ANIM_PROGRESS = class_2945.method_12791(Apparition.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> POLTERGEIST_ANIM_PROGRESS = class_2945.method_12791(Apparition.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> HIDING = class_2945.method_12791(Apparition.class, (class_2941)class_2943.field_13323);
    private final class_1277 inventory = new class_1277(1);
    private float transparency;
    private float outerTransparency;
    public int hiddenTicks;
    private float prevTransparency;
    private float prevOuterTransparency;
    private float aidAnimProgress;
    private float prevAidAnimProgress;
    private float poltergeistAnimProgress;
    private float prevPoltergeistAnimProgress;
    private float flicker;
    private float prevFlicker;
    private static final double BRIGHTNESS_OFFSET = 6.0;
    private static final double BRIGHTNESS_DIVISOR = 9.0;

    public Apparition(class_1299<? extends Apparition> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        Arrays.stream(class_7.values()).forEach(pathType -> this.method_5941((class_7)pathType, 0.0f));
        this.method_5941(class_7.field_22, 8.0f);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5952(this.method_5936());
        this.field_23807 = false;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ITEM_STACK, (Object)class_1799.field_8037);
        builder.method_56912(TRANSPARENCY, (Object)Float.valueOf(0.0f));
        builder.method_56912(OUTER_TRANSPARENCY, (Object)Float.valueOf(0.0f));
        builder.method_56912(AID_ANIM_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.method_56912(POLTERGEIST_ANIM_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.method_56912(HIDING, (Object)true);
    }

    @NotNull
    public static class_5132.class_5133 createApparitionAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23720, 0.5).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23717, 24.0).method_26868(class_5134.field_23718, 0.375);
    }

    @NotNull
    protected class_1408 method_5965(class_1937 level) {
        class_1407 flyingPathNavigation = new class_1407((class_1308)this, level);
        flyingPathNavigation.method_6354(false);
        flyingPathNavigation.method_70687(false);
        flyingPathNavigation.method_6342().method_15(true);
        return flyingPathNavigation;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.method_18868().method_24525(TTMemoryModuleTypes.AID_COOLDOWN, (Object)class_3902.field_17274, 100L);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.method_18382();
    }

    public boolean method_5679(class_3218 level, class_1282 damageSource) {
        return super.method_5679(level, damageSource) || this.isHiding();
    }

    @NotNull
    protected class_4048 method_55694(class_4050 pose) {
        return this.isHiding() ? this.method_5864().method_18386().method_18383(0.0f) : super.method_55694(pose);
    }

    public void setHiding(boolean hiding) {
        this.field_6011.method_12778(HIDING, (Object)hiding);
    }

    public boolean isHiding() {
        return (Boolean)this.field_6011.method_12789(HIDING);
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_52535() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_29920() {
        return false;
    }

    public boolean method_5721() {
        return false;
    }

    public boolean method_5771() {
        return false;
    }

    public boolean method_5799() {
        return false;
    }

    public int method_5970() {
        return 200;
    }

    public float method_6149(class_2338 pos) {
        EntityCoffinInterface entityCoffinInterface;
        class_1937 level = this.method_37908();
        boolean isPosSafe = !level.method_8320(pos).method_26234((class_1922)level, pos);
        float successValue = 20.0f - Math.max(5.0f, (float)level.method_22335(pos, 0) * 0.5f);
        float punishmentValue = -1.0f;
        Apparition apparition = this;
        if (apparition instanceof EntityCoffinInterface && (entityCoffinInterface = (EntityCoffinInterface)((Object)apparition)).trailierTales$getCoffinData() != null && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            boolean withinCatacombs = CoffinSpawner.isInCatacombsBounds(pos, serverLevel.method_27056());
            if (withinCatacombs) {
                punishmentValue = 0.0f;
            }
            isPosSafe = isPosSafe && withinCatacombs;
            successValue *= 2.0f;
        }
        return isPosSafe ? successValue : punishmentValue;
    }

    public float method_6144(class_2338 pos, @NotNull class_4538 world) {
        return !world.method_8320(pos).method_26234((class_1922)world, pos) ? 15.0f : -0.75f;
    }

    public boolean shouldReturnToHome(@NotNull class_4208 globalPos) {
        if (globalPos.comp_2207() == this.method_37908().method_27983()) {
            return this.method_19538().method_1022(class_243.method_24953((class_2382)globalPos.comp_2208())) >= 58.0;
        }
        return false;
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public boolean method_33189() {
        return true;
    }

    @NotNull
    public class_1277 method_35199() {
        return this.inventory;
    }

    public class_1799 getVisibleItem() {
        return (class_1799)this.field_6011.method_12789(ITEM_STACK);
    }

    public void setVisibleItem(@NotNull class_1799 itemStack) {
        this.method_5841().method_12778(ITEM_STACK, (Object)itemStack);
    }

    public boolean method_5936() {
        return !this.isOnPickupCooldown();
    }

    private boolean isOnPickupCooldown() {
        return this.method_18868().method_18876(class_4140.field_38397, class_4141.field_18456);
    }

    public boolean wantsToPickUp(class_3218 level, @NotNull class_1542 item) {
        return this.method_20820(level, item.method_6983()) && this.method_5968() != null;
    }

    public boolean method_20820(class_3218 level, class_1799 stack) {
        return ((class_1799)this.inventory.method_54454().getFirst()).method_7960();
    }

    protected void method_5949(class_3218 level, class_1542 item) {
        class_1542 newItemEntity = new class_1542(this.method_37908(), item.method_23317(), item.method_23318(), item.method_23321(), item.method_6983().method_7971(1));
        this.method_37908().method_8649((class_1297)newItemEntity);
        class_6067.method_43544((class_3218)level, (class_1308)this, (class_6067)this, (class_1542)newItemEntity);
    }

    protected void method_16078(class_3218 level) {
        super.method_16078(level);
        this.inventory.method_24514().forEach(it -> this.method_5775(level, (class_1799)it));
    }

    public float getInnerTransparency() {
        return ((Float)this.field_6011.method_12789(TRANSPARENCY)).floatValue();
    }

    public void setTransparency(float transparency) {
        this.field_6011.method_12778(TRANSPARENCY, (Object)Float.valueOf(transparency));
    }

    public float getOuterTransparency() {
        return ((Float)this.field_6011.method_12789(OUTER_TRANSPARENCY)).floatValue();
    }

    public void setOuterTransparency(float transparency) {
        this.field_6011.method_12778(OUTER_TRANSPARENCY, (Object)Float.valueOf(transparency));
    }

    public float getAidAnimProgress() {
        return ((Float)this.field_6011.method_12789(AID_ANIM_PROGRESS)).floatValue();
    }

    public void setAidAnimProgress(float progress) {
        this.field_6011.method_12778(AID_ANIM_PROGRESS, (Object)Float.valueOf(progress));
    }

    public float getPoltergeistAnimProgress() {
        return ((Float)this.field_6011.method_12789(POLTERGEIST_ANIM_PROGRESS)).floatValue();
    }

    public void setPoltergeistAnimProgress(float progress) {
        this.field_6011.method_12778(POLTERGEIST_ANIM_PROGRESS, (Object)Float.valueOf(progress));
    }

    public float getItemYRot(float partialTick) {
        return class_3532.method_15362((float)(((float)this.field_6012 + partialTick) / 8.0f)) * 0.35f;
    }

    public float getItemZRot(float partialTick) {
        return class_3532.method_15374((float)(((float)this.field_6012 + partialTick) / 8.0f)) * 0.35f;
    }

    public float getFlicker(float partialTick) {
        return 1.0f - class_3532.method_16439((float)partialTick, (float)this.prevFlicker, (float)this.flicker);
    }

    @Nullable
    protected class_3414 method_5994() {
        return TTSounds.APPARITION_IDLE;
    }

    @NotNull
    protected class_3414 method_6011(class_1282 source) {
        return TTSounds.APPARITION_HURT;
    }

    @NotNull
    protected class_3414 method_6002() {
        return TTSounds.APPARITION_DEATH;
    }

    public float method_6107() {
        return 0.75f;
    }

    public void method_5773() {
        this.field_5960 = true;
        super.method_5773();
        this.field_5960 = false;
        this.method_5875(true);
        if (!this.method_37908().field_9236) {
            this.tickTransparency();
            boolean isHidden = this.isHiding();
            if (!isHidden) {
                this.spawnParticles(this.field_5974.method_43051(0, 2), this.createAmbientParticleOptions());
            }
            this.hiddenTicks = Math.max(0, this.hiddenTicks - 1);
            boolean hiding = this.hiddenTicks > 0;
            this.setHiding(hiding);
            if (isHidden != hiding) {
                this.method_18382();
            }
            this.setVisibleItem(((class_1799)this.inventory.method_54454().getFirst()).method_7972());
        } else {
            this.prevTransparency = this.transparency;
            this.prevOuterTransparency = this.outerTransparency;
            this.transparency = this.getInnerTransparency();
            this.outerTransparency = this.getOuterTransparency();
            this.prevFlicker = this.flicker;
            this.flicker += Math.max(0.0f, this.field_5974.method_43057() * 0.175f - this.flicker) * 0.5f;
            this.prevAidAnimProgress = this.aidAnimProgress;
            this.aidAnimProgress += (this.getAidAnimProgress() - this.aidAnimProgress) * 0.3f;
            this.prevPoltergeistAnimProgress = this.poltergeistAnimProgress;
            this.poltergeistAnimProgress += (this.getPoltergeistAnimProgress() - this.poltergeistAnimProgress) * 0.3f;
        }
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        class_3695 profilerFiller = class_10209.method_64146();
        profilerFiller.method_15396("move");
        class_243 vec3 = this.method_17835(movement);
        this.method_5814(this.method_23317() + vec3.field_1352, this.method_23318() + vec3.field_1351, this.method_23321() + vec3.field_1350);
        profilerFiller.method_15407();
        profilerFiller.method_15396("rest");
        boolean horizontalCollisionX = !class_3532.method_20390((double)movement.field_1352, (double)vec3.field_1352);
        boolean horizontalCollisionZ = !class_3532.method_20390((double)movement.field_1350, (double)vec3.field_1350);
        this.field_5976 = horizontalCollisionX || horizontalCollisionZ;
        this.field_5992 = movement.field_1351 != vec3.field_1351;
        this.field_36331 = this.field_5992 && movement.field_1351 < 0.0;
        this.field_34927 = this.field_5976 ? this.method_39759(vec3) : false;
        if (this.method_31481()) {
            profilerFiller.method_15407();
        } else {
            if (this.field_5976) {
                class_243 vec32 = this.method_18798();
                this.method_18800(horizontalCollisionX ? 0.0 : vec32.field_1352, vec32.field_1351, horizontalCollisionZ ? 0.0 : vec32.field_1350);
            }
            profilerFiller.method_15407();
        }
    }

    @Contract(value=" -> new")
    @NotNull
    private class_2394 createAmbientParticleOptions() {
        float aidProgress = this.getAidAnimProgress();
        float poltergeistProgress = this.getPoltergeistAnimProgress();
        Vector3f finalColor = new Vector3f((Vector3fc)BASE_DUST_COLOR);
        finalColor = finalColor.lerp((Vector3fc)AID_DUST_COLOR, aidProgress);
        finalColor = finalColor.lerp((Vector3fc)POLTERGEIST_DUST_COLOR, poltergeistProgress);
        return new GlowingDustColorTransitionOptions(finalColor, WHITE, 1.0f);
    }

    public void method_5674(class_2940<?> data) {
        if (HIDING.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public boolean method_17326() {
        return super.method_17326() || !this.getVisibleItem().method_7960();
    }

    public boolean method_49108() {
        return super.method_49108() && this.getInnerTransparency() > 0.0f;
    }

    public boolean method_64397(class_3218 level, @NotNull class_1282 source, float amount) {
        class_1297 class_12972;
        boolean bl;
        class_1297 class_12973;
        if (source.method_48789(class_8103.field_42247) && (class_12973 = source.method_5526()) instanceof class_1676) {
            class_1676 projectile = (class_1676)class_12973;
            if (projectile instanceof class_1665) {
                class_1665 abstractArrow = (class_1665)projectile;
                this.swapItem(abstractArrow.method_54759());
                abstractArrow.method_31472();
                return false;
            }
            if (projectile instanceof class_3856) {
                class_3856 itemSupplier = (class_3856)projectile;
                this.swapItem(itemSupplier.method_7495());
                projectile.method_31472();
                return false;
            }
        }
        if ((bl = super.method_64397(level, source, amount)) && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            ApparitionAi.wasHurtBy(level, this, livingEntity);
        }
        return bl;
    }

    public void swapItem(@NotNull class_1799 itemStack) {
        if (!itemStack.method_7960() && !this.method_37908().field_9236) {
            this.dropItem();
            this.inventory.method_5447(0, itemStack);
        }
    }

    public void dropItem() {
        class_1799 currentStack = ((class_1799)this.inventory.method_54454().getFirst()).method_51164();
        if (!currentStack.method_7960()) {
            this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), currentStack));
        }
    }

    @NotNull
    public class_238 method_53511() {
        return super.method_53511();
    }

    public void tickTransparency() {
        float outerTransparency;
        float transparency = 0.0f;
        boolean isHidden = this.isHiding();
        if (this.isAiding()) {
            transparency = 1.0f;
            outerTransparency = 1.5f;
        } else if (isHidden) {
            transparency = 0.0f;
            outerTransparency = 0.0f;
        } else {
            double brightness = Math.max(0.0, (double)this.method_37908().method_22339(class_2338.method_49638((class_2374)this.method_33571())) - 6.0);
            transparency = (float)Math.max((double)transparency, brightness / 9.0);
            outerTransparency = transparency * 0.5f;
        }
        float interpolationFactor = isHidden ? 0.9f : 0.3f;
        this.transparency += (transparency - this.transparency) * interpolationFactor;
        if (this.transparency < 0.025f && this.transparency != 0.0f && transparency == 0.0f) {
            this.transparency = 0.0f;
            if (isHidden) {
                this.spawnParticles(this.field_5974.method_43051(3, 7), (class_2394)class_2398.field_11203);
            }
        } else if (this.transparency > 0.975f && transparency == 1.0f) {
            this.transparency = 1.0f;
        }
        this.setTransparency(this.transparency);
        this.outerTransparency += (outerTransparency - this.outerTransparency) * interpolationFactor;
        if (this.outerTransparency < 0.025f && this.outerTransparency != 0.0f && outerTransparency == 0.0f) {
            this.outerTransparency = 0.0f;
        } else if (this.outerTransparency > 0.975f && outerTransparency == 1.0f) {
            this.outerTransparency = 1.0f;
        }
        this.setOuterTransparency(this.outerTransparency);
    }

    public float getInnerTransparency(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevTransparency, (float)this.transparency) * 0.8f * (1.0f - this.getOtherAnimProgress(partialTick));
    }

    public float getOuterTransparency(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevOuterTransparency, (float)this.outerTransparency) * 0.75f * (1.0f - this.getOtherAnimProgress(partialTick));
    }

    private float getOtherAnimProgress(float partialTick) {
        return Math.max(this.getAidAnimProgress(partialTick), this.getPoltergeistAnimProgress(partialTick));
    }

    public float getAidAnimProgress(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevAidAnimProgress, (float)this.aidAnimProgress) * 0.85f;
    }

    public float getPoltergeistAnimProgress(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevPoltergeistAnimProgress, (float)this.poltergeistAnimProgress) * 0.85f;
    }

    public float totalTransparency(float partialTick) {
        return Math.max(Math.max(this.getInnerTransparency(partialTick), this.getPoltergeistAnimProgress(partialTick)), this.getAidAnimProgress(partialTick));
    }

    @Nullable
    public class_1309 method_5968() {
        return this.method_59664();
    }

    public void method_5749(@NotNull class_11368 valueInput) {
        super.method_5749(valueInput);
        this.method_46400(valueInput);
        this.setTransparency(valueInput.method_71423("Transparency", 0.0f));
        this.setOuterTransparency(valueInput.method_71423("OuterTransparency", 0.0f));
        this.setAidAnimProgress(valueInput.method_71423("AidAnimProgress", 0.0f));
        this.setPoltergeistAnimProgress(valueInput.method_71423("PoltergeistAnimProgress", 0.0f));
        this.setHiding(valueInput.method_71433("Hiding", false));
        this.setVisibleItem(((class_1799)this.inventory.method_54454().getFirst()).method_7972());
    }

    public void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        this.method_46399(valueOutput);
        valueOutput.method_71464("Transparency", this.getInnerTransparency());
        valueOutput.method_71464("OuterTransparency", this.getOuterTransparency());
        valueOutput.method_71464("AidAnimProgress", this.getAidAnimProgress());
        valueOutput.method_71464("PoltergeistAnimProgress", this.getPoltergeistAnimProgress());
        valueOutput.method_71472("Hiding", this.isHiding());
    }

    @NotNull
    protected class_4095.class_5303<Apparition> method_28306() {
        return class_4095.method_28311(ApparitionAi.MEMORY_TYPES, ApparitionAi.SENSOR_TYPES);
    }

    @NotNull
    protected class_4095<Apparition> method_18867(Dynamic<?> dynamic) {
        return ApparitionAi.makeBrain(this, (class_4095<Apparition>)this.method_28306().method_28335(dynamic));
    }

    public boolean isAiding() {
        return this.method_18868().method_18896(TTMemoryModuleTypes.AIDING_TIME);
    }

    @NotNull
    public class_4095<Apparition> method_18868() {
        return super.method_18868();
    }

    protected void method_5958(class_3218 level) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("apparitionBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("apparitionActivityUpdate");
        ApparitionAi.updateActivity(this);
        profiler.method_15407();
        super.method_5958(level);
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canTargetEntity(@Nullable class_1297 entity, class_3218 level) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 livingEntity = (class_1309)entity;
        if (this.method_37908() != livingEntity.method_37908()) return false;
        if (this.method_37908().method_8407().equals((Object)class_1267.field_5801)) return false;
        if (!class_1301.field_6156.test(livingEntity)) return false;
        if (this.method_5722((class_1297)livingEntity)) return false;
        if (!entity.method_5864().method_20210(TTEntityTags.APPARITION_TARGETABLE)) return false;
        if (livingEntity.method_5655()) return false;
        if (livingEntity.method_29504()) return false;
        if (livingEntity.method_31481()) return false;
        if (!this.method_37908().method_8621().method_11966(livingEntity.method_5829())) return false;
        return true;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
    }

    public void spawnParticles(int count, class_2394 particleOptions) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            level.method_65096(particleOptions, this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), count, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    public void method_7105(class_1309 target, float pullProgress) {
        class_1799 itemStack = (class_1799)this.inventory.method_54454().getFirst();
        if (!itemStack.method_7960()) {
            ThrownItemProjectile projectile;
            class_1799 singleItem = itemStack.method_51164();
            class_1792 class_17922 = singleItem.method_7909();
            if (class_17922 instanceof class_9463) {
                class_9463 projectileItem = (class_9463)class_17922;
                projectile = projectileItem.method_58648(this.method_37908(), (class_2374)this.method_33571(), singleItem, this.method_5735());
            } else {
                projectile = new ThrownItemProjectile(this.method_37908(), (class_1309)this, singleItem);
            }
            projectile.method_7432((class_1297)this);
            double targetY = target.method_23320() - (double)1.1f;
            double xDifference = target.method_23317() - this.method_23317();
            double yDifference = targetY - projectile.method_23318();
            double zDifference = target.method_23321() - this.method_23321();
            double yAdjustment = Math.sqrt(xDifference * xDifference + zDifference * zDifference) * (double)0.2f;
            projectile.method_7485(xDifference, yDifference + yAdjustment, zDifference, Math.max(0.5f, pullProgress), 14 - this.method_37908().method_8407().method_5461() * 4);
            this.method_5783(TTSounds.APPARITION_THROW, 1.0f, 0.4f / (this.method_59922().method_43057() * 0.4f + 0.8f));
            this.method_37908().method_8649((class_1297)projectile);
        }
    }

    @NotNull
    public class_2960 frozenLib$getWindDisturbanceLogicID() {
        return FrozenLibIntegration.APPARITION_WIND_DISTURBANCE;
    }

    public double frozenLib$getWindWidth() {
        return 12.0;
    }

    public double frozenLib$getWindHeight() {
        return 12.0;
    }

    public double frozenLib$getWindAreaYOffset() {
        return 0.0;
    }

    public boolean frozenLib$useSyncPacket() {
        return false;
    }
}

