/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.config;

import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.instance.json.JsonConfig;
import net.frozenblock.lib.config.api.instance.json.JsonType;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.api.sync.annotation.EntrySyncData;
import net.frozenblock.trailiertales.TTPreLoadConstants;

public final class TTWorldgenConfig {
    public static final Config<TTWorldgenConfig> INSTANCE = ConfigRegistry.register((Config)new JsonConfig<TTWorldgenConfig>("trailiertales", TTWorldgenConfig.class, TTPreLoadConstants.configPath("worldgen", true), JsonType.JSON5){

        public void onSave() throws Exception {
            super.onSave();
            this.onSync(null);
        }

        public void onSync(TTWorldgenConfig syncInstance) {
            TTWorldgenConfig config = (TTWorldgenConfig)this.config();
            GENERATE_CATACOMBS = config.catacombs;
            GENERATE_GENERIC_RUINS = config.ruins.generic;
            GENERATE_SNOWY_RUINS = config.ruins.snowy;
            GENERATE_JUNGLE_RUINS = config.ruins.jungle;
            GENERATE_SAVANNA_RUINS = config.ruins.savanna;
            GENERATE_DESERT_RUINS = config.ruins.desert;
            GENERATE_BADLANDS_RUINS = config.ruins.badlands;
            GENERATE_DEEPSLATE_RUINS = config.ruins.deepslate;
        }
    });
    public static volatile boolean GENERATE_CATACOMBS = true;
    public static volatile boolean GENERATE_GENERIC_RUINS = true;
    public static volatile boolean GENERATE_SNOWY_RUINS = true;
    public static volatile boolean GENERATE_JUNGLE_RUINS = true;
    public static volatile boolean GENERATE_SAVANNA_RUINS = true;
    public static volatile boolean GENERATE_DESERT_RUINS = true;
    public static volatile boolean GENERATE_BADLANDS_RUINS = true;
    public static volatile boolean GENERATE_DEEPSLATE_RUINS = true;
    @ConfigEntry.Gui.CollapsibleObject
    public final Ruins ruins = new Ruins();
    @ConfigEntry.Gui.CollapsibleObject
    public final Vegetation vegetation = new Vegetation();
    @ConfigEntry.Gui.CollapsibleObject
    public final EndCity endCity = new EndCity();
    @EntrySyncData(value="catacombs")
    public boolean catacombs = true;

    public static TTWorldgenConfig get() {
        return TTWorldgenConfig.get(false);
    }

    public static TTWorldgenConfig get(boolean real) {
        if (real) {
            return (TTWorldgenConfig)INSTANCE.instance();
        }
        return (TTWorldgenConfig)INSTANCE.config();
    }

    public static TTWorldgenConfig getWithSync() {
        return (TTWorldgenConfig)INSTANCE.configWithSync();
    }

    public static class Ruins {
        @EntrySyncData(value="generic")
        public boolean generic = true;
        @EntrySyncData(value="snowy")
        public boolean snowy = true;
        @EntrySyncData(value="jungle")
        public boolean jungle = true;
        @EntrySyncData(value="savanna")
        public boolean savanna = true;
        @EntrySyncData(value="desert")
        public boolean desert = true;
        @EntrySyncData(value="badlands")
        public boolean badlands = true;
        @EntrySyncData(value="deepslate")
        public boolean deepslate = true;
    }

    public static class Vegetation {
        @EntrySyncData(value="generateTorchflower")
        public boolean generateTorchflower = false;
        @EntrySyncData(value="generatePitcher")
        public boolean generatePitcher = false;
        @EntrySyncData(value="generateCyanRose")
        public boolean generateCyanRose = false;
        @EntrySyncData(value="generateManedrop")
        public boolean generateManedrop = false;
        @EntrySyncData(value="generateDawntrail")
        public boolean generateDawntrail = false;
    }

    public static class EndCity {
        @EntrySyncData(value="generateCracked")
        public boolean generateCracked = true;
        @EntrySyncData(value="generateChoral")
        public boolean generateChoral = true;
        @EntrySyncData(value="generateChiseled")
        public boolean generateChiseled = true;
    }
}

