/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.client.renderer.debug;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.debug.client.impl.DebugRenderManager;
import net.frozenblock.trailiertales.block.entity.coffin.impl.EntityCoffinData;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_863;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CoffinDebugRenderer
implements class_863.class_864 {
    private static final int CONNECTION_COLOR = class_9848.method_61324((int)255, (int)50, (int)125, (int)90);
    private static final int SELECTED_CONNECTION_COLOR = class_9848.method_61324((int)255, (int)255, (int)50, (int)255);
    private static final int TEXT_COLOR = class_9848.method_61324((int)255, (int)255, (int)255, (int)255);
    private final class_310 minecraft;
    private final IntArrayList scheduledRemovals = new IntArrayList();
    private final Map<Integer, EntityCoffinData> connections = Maps.newHashMap();
    @Nullable
    private Integer lastLookedAtId;
    private long gameTime;

    public CoffinDebugRenderer(class_310 client) {
        this.minecraft = client;
    }

    private void clearRemovedEntities() {
        this.connections.entrySet().removeIf(entry -> {
            int id = (Integer)entry.getKey();
            if (this.scheduledRemovals.contains(id)) {
                return true;
            }
            class_1297 entity = this.minecraft.field_1687.method_8469(id);
            return entity == null || entity.method_31481();
        });
    }

    public void addConnection(int entityId, class_2338 coffinPos, long lastInteractionTime, long gameTime) {
        this.connections.put(entityId, new EntityCoffinData(coffinPos, UUID.randomUUID(), lastInteractionTime));
        this.gameTime = gameTime;
    }

    public void scheduleRemoval(int entityId) {
        this.scheduledRemovals.add(entityId);
    }

    public void method_20414() {
        this.connections.clear();
        this.scheduledRemovals.clear();
        this.lastLookedAtId = null;
    }

    public void method_23109(class_4587 matrices, @NotNull class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        this.clearRemovedEntities();
        this.scheduledRemovals.removeIf(id -> true);
        if (!this.minecraft.field_1724.method_7325()) {
            this.updateLastLookedAtUuid();
        }
        for (Map.Entry<Integer, EntityCoffinData> connectionInfo : this.connections.entrySet()) {
            class_1297 entity;
            EntityCoffinData coffinData = connectionInfo.getValue();
            boolean selected = false;
            Integer id2 = connectionInfo.getKey();
            if (id2 == null || (entity = this.minecraft.field_1687.method_8469(id2.intValue())) == null) continue;
            if (id2.equals(this.lastLookedAtId)) {
                selected = true;
                CoffinDebugRenderer.highlightPos(matrices, vertexConsumers, coffinData.getPos());
                class_243 entityTextPos = entity.method_5836(DebugRenderManager.PARTIAL_TICK);
                CoffinDebugRenderer.renderTextOverPos(matrices, vertexConsumers, entity.method_5476().getString(), entityTextPos, 3, TEXT_COLOR);
                CoffinDebugRenderer.renderTextOverPos(matrices, vertexConsumers, "Last Interaction: " + (this.gameTime - coffinData.lastInteraction()), entityTextPos, 2, TEXT_COLOR);
            }
            CoffinDebugRenderer.drawLine(matrices, vertexConsumers, cameraX, cameraY, cameraZ, entity.method_5836(DebugRenderManager.PARTIAL_TICK), class_243.method_24953((class_2382)coffinData.getPos()), selected ? SELECTED_CONNECTION_COLOR : CONNECTION_COLOR);
        }
    }

    private void updateLastLookedAtUuid() {
        class_863.method_23101((class_1297)this.minecraft.method_1560(), (int)8).ifPresent(entity -> {
            this.lastLookedAtId = entity.method_5628();
        });
    }

    private static void highlightPos(class_4587 matrices, class_4597 vertexConsumers, class_2338 pos) {
        class_863.method_23103((class_4587)matrices, (class_4597)vertexConsumers, (class_2338)pos, (float)0.05f, (float)0.2f, (float)0.2f, (float)1.0f, (float)0.3f);
        CoffinDebugRenderer.renderTextOverPos(matrices, vertexConsumers, "Coffin", pos.method_46558(), 0, TEXT_COLOR);
    }

    private static void drawLine(@NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ, @NotNull class_243 start, @NotNull class_243 target, int color) {
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_49043((double)4.0));
        vertexConsumer.method_56824(matrices.method_23760(), (float)(start.field_1352 - cameraX), (float)(start.field_1351 - cameraY), (float)(start.field_1350 - cameraZ)).method_39415(color);
        vertexConsumer.method_56824(matrices.method_23760(), (float)(target.field_1352 - cameraX), (float)(target.field_1351 - cameraY), (float)(target.field_1350 - cameraZ)).method_39415(color);
    }

    private static void renderTextOverPos(class_4587 matrices, class_4597 vertexConsumers, String string, @NotNull class_243 pos, int offsetY, int color) {
        double g = pos.field_1351 + (double)offsetY * 0.2;
        class_863.method_23107((class_4587)matrices, (class_4597)vertexConsumers, (String)string, (double)pos.field_1352, (double)g, (double)pos.field_1350, (int)color, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
    }
}

