/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.client.renderer.blockentity;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.trailiertales.block.CoffinBlock;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinBlockEntity;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerState;
import net.frozenblock.trailiertales.block.impl.CoffinPart;
import net.frozenblock.trailiertales.client.TTModelLayers;
import net.frozenblock.trailiertales.client.model.CoffinModel;
import net.frozenblock.trailiertales.registry.TTBlockEntityTypes;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_5599;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class CoffinRenderer
implements class_827<CoffinBlockEntity> {
    private final CoffinModel headModel;
    private final CoffinModel footModel;

    public CoffinRenderer(@NotNull class_5614.class_5615 context) {
        this(context.method_32142());
    }

    public CoffinRenderer(@NotNull class_5599 entityModelSet) {
        this.headModel = new CoffinModel(entityModelSet.method_32072(TTModelLayers.COFFIN_HEAD));
        this.footModel = new CoffinModel(entityModelSet.method_32072(TTModelLayers.COFFIN_FOOT));
    }

    @NotNull
    public static class_2960 getCoffinTexture(@NotNull CoffinPart part, CoffinSpawnerState state, boolean ominous) {
        return part == CoffinPart.HEAD ? state.getHeadTexture() : state.getFootTexture();
    }

    public void render(@NotNull CoffinBlockEntity blockEntity, float partialTick, @NotNull class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, class_243 cameraPos) {
        class_1937 level = blockEntity.method_10997();
        if (level != null) {
            float openProg = blockEntity.getOpenProgress(partialTick);
            openProg = 1.0f - openProg;
            openProg = 1.0f - openProg * openProg * openProg;
            class_2680 blockState = blockEntity.method_11010();
            class_4732.class_4734 neighborCombineResult = class_4732.method_24173(TTBlockEntityTypes.COFFIN, CoffinBlock::getBlockType, CoffinBlock::getConnectedDirection, (class_2769)CoffinBlock.field_11177, (class_2680)blockState, (class_1936)level, (class_2338)blockEntity.method_11016(), (world, pos) -> false);
            float wobbleProgress = ((float)(level.method_8510() - blockEntity.wobbleStartedAtTick) + partialTick) / 15.0f;
            int i = ((Int2IntFunction)neighborCombineResult.apply((class_4732.class_3923)new class_4737())).get(packedLight);
            CoffinPart part = (CoffinPart)((Object)blockState.method_11654(CoffinBlock.PART));
            CoffinSpawnerState coffinSpawnerState = (CoffinSpawnerState)((Object)blockState.method_11654(CoffinBlock.STATE));
            class_2350 direction = (class_2350)blockState.method_11654((class_2769)CoffinBlock.field_11177);
            this.renderPiece(poseStack, buffer, part == CoffinPart.HEAD ? this.headModel : this.footModel, CoffinRenderer.getCoffinTexture(part, coffinSpawnerState, false), null, openProg, wobbleProgress, i, packedOverlay, false, direction);
        }
    }

    public void renderInHand(@NotNull class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay, class_2960 headTexture, class_2960 footTexture, float openness) {
        poseStack.method_46416(0.0f, -0.1f, 0.0f);
        this.renderPiece(poseStack, buffer, this.headModel, headTexture, null, openness, 0.0f, packedLight, packedOverlay, false, class_2350.field_11035);
        this.renderPiece(poseStack, buffer, this.footModel, footTexture, null, openness, 0.0f, packedLight, packedOverlay, true, class_2350.field_11035);
    }

    private void renderPiece(@NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, @NotNull CoffinModel model, @NotNull class_2960 texture, @Nullable class_2960 glowingTexture, float openProgress, float wobbleProgress, int packedLight, int packedOverlay, boolean renderAsOffsetFoot, class_2350 direction) {
        poseStack.method_22903();
        CoffinRenderer.prepareModelAndPose(model, poseStack, renderAsOffsetFoot, direction, openProgress, wobbleProgress);
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23576((class_2960)texture));
        model.method_60879(poseStack, vertexConsumer, packedLight, packedOverlay);
        if (glowingTexture != null) {
            class_4588 glowingConsumer = bufferSource.getBuffer(class_1921.method_23026((class_2960)glowingTexture));
            model.method_60879(poseStack, glowingConsumer, packedLight, packedOverlay);
        }
        poseStack.method_22909();
    }

    private static void prepareModelAndPose(CoffinModel model, @NotNull class_4587 poseStack, boolean renderAsOffsetFoot, @NotNull class_2350 direction, float openProgress, float wobbleProgress) {
        poseStack.method_46416(0.5f, 0.5f, 0.5f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-direction.method_10144()));
        poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        if (wobbleProgress >= 0.0f && wobbleProgress <= 1.0f) {
            float coffinWobble = wobbleProgress * (float)Math.PI * 2.5f;
            float wobbleDampen = 1.0f - wobbleProgress;
            float wobble = -3.0f * class_3532.method_15362((float)coffinWobble) * class_3532.method_15374((float)coffinWobble) * wobbleDampen;
            poseStack.method_49278((Quaternionfc)class_7833.field_40718.rotation(wobble * 0.015625f), 0.5f, 0.0f, 0.5f);
            float lidWobble = (wobbleProgress + 0.16666667f) * (float)Math.PI * 2.5f;
            openProgress += Math.max(0.0f, class_3532.method_15362((float)lidWobble) * -0.25f * (class_3532.method_15374((float)lidWobble) * -0.25f)) * wobbleDampen;
        }
        model.setupAnim(openProgress * 1.5707964f);
        if (renderAsOffsetFoot) {
            poseStack.method_46416(0.0f, 0.0f, -1.0f);
        }
    }

    public void getExtents(Set<Vector3f> set) {
        class_4587 poseStack = new class_4587();
        CoffinRenderer.prepareModelAndPose(this.headModel, poseStack, false, class_2350.field_11035, 0.0f, 0.0f);
        this.headModel.method_63512().method_72152(poseStack, set);
        poseStack.method_34426();
        CoffinRenderer.prepareModelAndPose(this.footModel, poseStack, true, class_2350.field_11035, 0.0f, 0.0f);
        this.footModel.method_63512().method_72152(poseStack, set);
    }
}

