/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.block.entity.coffin.impl;

import java.util.Optional;
import java.util.UUID;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.networking.FrozenNetworking;
import net.frozenblock.trailiertales.block.CoffinBlock;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinBlockEntity;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawner;
import net.frozenblock.trailiertales.block.entity.coffin.impl.EntityCoffinInterface;
import net.frozenblock.trailiertales.entity.Apparition;
import net.frozenblock.trailiertales.networking.packet.CoffinDebugPacket;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5996;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCoffinData {
    private final class_2338 pos;
    private final UUID coffinUUID;
    private long lastInteractionAt;

    public EntityCoffinData(class_2338 pos, UUID coffinUUID, long lastInteractionAt) {
        this.pos = pos;
        this.coffinUUID = coffinUUID;
        this.lastInteractionAt = lastInteractionAt;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public UUID getCoffinUUID() {
        return this.coffinUUID;
    }

    public static boolean entityHasCoffinData(@NotNull class_1297 entity) {
        EntityCoffinInterface entityCoffinInterface;
        return entity instanceof EntityCoffinInterface && (entityCoffinInterface = (EntityCoffinInterface)entity).trailierTales$getCoffinData() != null;
    }

    public void tick(class_1309 entity, @NotNull class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            long gameTime = level.method_8510();
            boolean canUntrackFromTime = gameTime - this.lastInteractionAt > 1800L && !(entity instanceof Apparition);
            Optional<CoffinSpawner> optionalCoffinSpawner = this.getSpawner(level);
            if (optionalCoffinSpawner.isEmpty() || canUntrackFromTime) {
                CoffinBlock.onCoffinUntrack(serverLevel, (class_1297)entity, null, true);
            } else {
                if (FrozenLibConfig.IS_DEBUG) {
                    FrozenNetworking.sendPacketToAllPlayers((class_3218)serverLevel, (class_8710)new CoffinDebugPacket(entity.method_5628(), this.lastInteractionAt, this.pos, gameTime));
                }
                if (entity instanceof class_1308) {
                    class_1308 mob = (class_1308)entity;
                    if (optionalCoffinSpawner.get().isOminous()) {
                        CoffinSpawner coffinSpawner = optionalCoffinSpawner.get();
                        Optional<class_1657> optionalPlayer = coffinSpawner.getData().getClosestDetectedPlayer(level, entity.method_19538());
                        optionalPlayer.ifPresent(arg_0 -> ((class_1308)mob).method_5980(arg_0));
                    }
                }
            }
        }
    }

    public Optional<CoffinSpawner> getSpawner(@NotNull class_1937 level) {
        CoffinBlockEntity coffinBlockEntity;
        class_2586 class_25862;
        if (level.method_8477(this.getPos()) && (class_25862 = level.method_8321(this.getPos())) instanceof CoffinBlockEntity && (coffinBlockEntity = (CoffinBlockEntity)class_25862).getCoffinSpawner().getUUID().equals(this.getCoffinUUID())) {
            return Optional.of(coffinBlockEntity.getCoffinSpawner());
        }
        return Optional.empty();
    }

    @class_5996
    public Optional<CoffinSpawner> getSpawnerIgnoringUUID(@NotNull class_1937 level) {
        class_2586 class_25862;
        if (level.method_8477(this.getPos()) && (class_25862 = level.method_8321(this.getPos())) instanceof CoffinBlockEntity) {
            CoffinBlockEntity coffinBlockEntity = (CoffinBlockEntity)class_25862;
            return Optional.of(coffinBlockEntity.getCoffinSpawner());
        }
        return Optional.empty();
    }

    public long lastInteraction() {
        return this.lastInteractionAt;
    }

    public void updateLastInteraction(long newTime) {
        this.lastInteractionAt = newTime;
    }

    public void save(@NotNull class_11372 valueOutput) {
        class_11372 coffinDataTag = valueOutput.method_71461("TrailierTales_CoffinData");
        coffinDataTag.method_71465("X", this.pos.method_10263());
        coffinDataTag.method_71465("Y", this.pos.method_10264());
        coffinDataTag.method_71465("Z", this.pos.method_10260());
        coffinDataTag.method_71468("CoffinUUID", class_4844.field_25122, (Object)this.coffinUUID);
        coffinDataTag.method_71466("LastInteractionAt", this.lastInteractionAt);
    }

    @Nullable
    public static EntityCoffinData load(@NotNull class_11368 valueInput) {
        Optional optional = valueInput.method_71420("TrailierTales_CoffinData");
        if (optional.isPresent()) {
            class_11368 coffinData = (class_11368)optional.get();
            class_2338 pos = new class_2338(coffinData.method_71424("X", 0), coffinData.method_71424("Y", 0), coffinData.method_71424("Z", 0));
            UUID coffinUUID = coffinData.method_71426("CoffinUUID", class_4844.field_25122).orElse(null);
            long lastInteractionAt = coffinData.method_71440("LastInteractionAt").orElse(0L);
            return new EntityCoffinData(pos, coffinUUID, lastInteractionAt);
        }
        return null;
    }
}

