/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.block.entity.coffin;

import java.util.Optional;
import java.util.UUID;
import net.frozenblock.trailiertales.TTConstants;
import net.frozenblock.trailiertales.block.CoffinBlock;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawner;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerConfig;
import net.frozenblock.trailiertales.block.entity.coffin.CoffinSpawnerData;
import net.frozenblock.trailiertales.particle.options.GlowingDustColorTransitionOptions;
import net.frozenblock.trailiertales.registry.TTSounds;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public enum CoffinSpawnerState implements class_3542
{
    INACTIVE("inactive", 0, false, false, Optional.empty()),
    COOLDOWN("cooldown", 0, false, false, Optional.empty()),
    ACTIVE("active", 3, true, false, Optional.of(GlowingDustColorTransitionOptions.ofSingleColor(new Vector3f(0.5372549f, 0.6901961f, 0.95686275f), 1.0f))),
    IRRITATED("irritated", 5, true, false, Optional.of(GlowingDustColorTransitionOptions.ofSingleColor(new Vector3f(0.72156864f, 0.58431375f, 0.85882354f), 1.0f))),
    AGGRESSIVE("aggressive", 7, true, true, Optional.of(GlowingDustColorTransitionOptions.ofSingleColor(new Vector3f(0.8784314f, 0.50980395f, 0.50980395f), 1.0f))),
    OMINOUS("ominous", 7, true, true, Optional.of(GlowingDustColorTransitionOptions.ofSingleColor(new Vector3f(0.87058824f, 0.2509804f, 0.34509805f), 1.0f)));

    private final String name;
    private final int lightLevel;
    private final boolean isCapableOfSpawning;
    private final boolean finalWave;
    private final Optional<class_2394> emitParticle;
    private final class_2960 headTexture;
    private final class_2960 footTexture;

    private CoffinSpawnerState(String name, int lightLevel, boolean isCapableOfSpawning, boolean finalWave, Optional<class_2394> emitParticle) {
        this.name = name;
        this.lightLevel = lightLevel;
        this.isCapableOfSpawning = isCapableOfSpawning;
        this.finalWave = finalWave;
        this.emitParticle = emitParticle;
        this.headTexture = CoffinSpawnerState.getTexture(name, false);
        this.footTexture = CoffinSpawnerState.getTexture(name, true);
    }

    CoffinSpawnerState tickAndGetNext(class_2338 pos, @NotNull CoffinSpawner spawner, class_2680 state, class_3218 level) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> CoffinSpawnerState.getInactiveState(pos, spawner, state, level);
            case 2 -> CoffinSpawnerState.activeTickAndGetNext(this, pos, spawner, state, level);
            case 3 -> CoffinSpawnerState.activeTickAndGetNext(this, pos, spawner, state, level);
            case 4 -> CoffinSpawnerState.activeTickAndGetNext(this, pos, spawner, state, level);
            case 5 -> CoffinSpawnerState.activeTickAndGetNext(this, pos, spawner, state, level);
        };
    }

    static CoffinSpawnerState getStateForPower(class_3218 level, @NotNull CoffinSpawner coffinSpawner) {
        CoffinSpawnerData coffinSpawnerData = coffinSpawner.getData();
        if (coffinSpawnerData.detectedAnyPlayers()) {
            if (!coffinSpawnerData.isPowerCooldownFinished(level)) {
                if (coffinSpawner.getIrritatedConfig().powerForNextLevel() <= coffinSpawnerData.power) {
                    return AGGRESSIVE;
                }
                if (coffinSpawner.getNormalConfig().powerForNextLevel() <= coffinSpawnerData.power) {
                    return IRRITATED;
                }
            }
            return ACTIVE;
        }
        return CoffinSpawnerState.getCooldownOrInactiveState((class_1937)level, coffinSpawner);
    }

    private static CoffinSpawnerState getInactiveState(class_2338 pos, @NotNull CoffinSpawner spawner, class_2680 state, @NotNull class_3218 level) {
        CoffinSpawnerData coffinSpawnerData = spawner.getData();
        if (!coffinSpawnerData.hasMobToSpawn(level.field_9229) || coffinSpawnerData.isOnCooldown((class_1937)level)) {
            return CoffinSpawnerState.getCooldownOrInactiveState((class_1937)level, spawner);
        }
        class_2350 direction = CoffinBlock.getConnectedDirection(state);
        coffinSpawnerData.tryDetectPlayers(level, pos, direction, spawner);
        if (spawner.canSpawnApparition((class_1937)level, pos, false)) {
            spawner.spawnApparition(level, pos);
        }
        return CoffinSpawnerState.getStateForPower(level, spawner);
    }

    private static CoffinSpawnerState activeTickAndGetNext(CoffinSpawnerState coffinSpawnerState, class_2338 pos, @NotNull CoffinSpawner spawner, class_2680 state, @NotNull class_3218 level) {
        CoffinSpawnerData coffinSpawnerData = spawner.getData();
        CoffinSpawnerConfig coffinSpawnerConfig = spawner.getConfig();
        if (!coffinSpawnerData.hasMobToSpawn(level.field_9229)) {
            return CoffinSpawnerState.getCooldownOrInactiveState((class_1937)level, spawner);
        }
        class_2350 direction = CoffinBlock.getConnectedDirection(state);
        coffinSpawnerData.tryDetectPlayers(level, pos, direction, spawner);
        if (!coffinSpawnerData.detectedAnyPlayers()) {
            return CoffinSpawnerState.getCooldownOrInactiveState((class_1937)level, spawner);
        }
        int additionalPlayers = coffinSpawnerData.countAdditionalPlayers();
        if (spawner.canSpawnApparition((class_1937)level, pos, false)) {
            spawner.spawnApparition(level, pos);
        }
        if (!coffinSpawnerState.finalWave && !coffinSpawnerData.isPowerCooldownFinished(level) && coffinSpawnerData.power >= coffinSpawnerConfig.powerForNextLevel()) {
            coffinSpawnerData.powerCooldownEndsAt = level.method_8510() + (long)spawner.getPowerCooldownLength();
            coffinSpawnerData.power = coffinSpawnerState == AGGRESSIVE ? spawner.getConfig().powerForNextLevel() : coffinSpawnerData.power;
            level.method_8396(null, pos, TTSounds.COFFIN_INCREASE_POWER, class_3419.field_15245, 0.5f, 0.9f + level.field_9229.method_43057() * 0.2f);
            return coffinSpawnerState.getNextPowerState();
        }
        if (coffinSpawnerData.hasFinishedSpawningAllMobs(coffinSpawnerConfig, additionalPlayers)) {
            if (coffinSpawnerData.haveAllCurrentMobsDied()) {
                coffinSpawnerData.totalMobsSpawned = 0;
                if (coffinSpawnerState.finalWave) {
                    coffinSpawnerData.nextMobSpawnsAt = 0L;
                    coffinSpawnerData.power = 0;
                    coffinSpawnerData.powerCooldownEndsAt = 0L;
                    long cooldownTime = 36000L;
                    coffinSpawnerData.nextApparitionSpawnsAt = level.method_8510() + cooldownTime;
                    coffinSpawnerData.cooldownEndsAt = level.method_8510() + cooldownTime;
                    if (coffinSpawnerData.haveAllCurrentApparitionsDied()) {
                        return COOLDOWN;
                    }
                }
            }
        } else if (coffinSpawnerData.isReadyToSpawnNextMob(level, coffinSpawnerConfig, additionalPlayers)) {
            spawner.spawnMob(level, pos).ifPresent(uuid -> {
                coffinSpawnerData.currentMobs.add((UUID)uuid);
                ++coffinSpawnerData.totalMobsSpawned;
                coffinSpawnerData.nextMobSpawnsAt = level.method_8510() + (long)coffinSpawnerConfig.ticksBetweenSpawn();
                coffinSpawnerData.spawnPotentials().method_34992(level.method_8409()).ifPresent(spawnData -> {
                    coffinSpawnerData.nextSpawnData = Optional.of(spawnData);
                    spawner.markUpdated();
                });
            });
        }
        return coffinSpawnerState;
    }

    public void emitParticles(class_3218 level, class_2338 pos, class_2350 coffinOrientation) {
        this.getParticleOptionsForState().ifPresent(particleOptions -> {
            if (level.field_9229.method_43057() <= 0.05f) {
                CoffinBlock.spawnParticlesFrom(level, particleOptions, level.field_9229.method_43051(1, 2), 0.5, coffinOrientation, pos, 0.5);
            }
        });
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public boolean isCapableOfSpawning() {
        return this.isCapableOfSpawning;
    }

    public class_2960 getHeadTexture() {
        return this.headTexture;
    }

    public class_2960 getFootTexture() {
        return this.footTexture;
    }

    public CoffinSpawnerState getNextPowerState() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> ACTIVE;
            case 2 -> IRRITATED;
            case 3, 4 -> AGGRESSIVE;
            case 5 -> OMINOUS;
        };
    }

    public static CoffinSpawnerState getCooldownOrInactiveState(class_1937 level, @NotNull CoffinSpawner coffinSpawner) {
        return coffinSpawner.getData().isOnCooldown(level) ? COOLDOWN : INACTIVE;
    }

    public Optional<class_2394> getParticleOptionsForState() {
        return this.emitParticle;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    private static class_2960 getTexture(String stateName, boolean foot) {
        return TTConstants.id("textures/entity/coffin/coffin_" + (foot ? "foot_" : "head_") + stateName + ".png");
    }

    @NotNull
    public String method_15434() {
        return this.name;
    }
}

