/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales.block.entity;

import java.util.List;
import java.util.Optional;
import net.frozenblock.trailiertales.block.SurveyorBlock;
import net.frozenblock.trailiertales.block.impl.TTClipContextShapeGetters;
import net.frozenblock.trailiertales.registry.TTBlockEntityTypes;
import net.frozenblock.trailiertales.tag.TTBlockTags;
import net.frozenblock.trailiertales.tag.TTEntityTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5575;
import org.jetbrains.annotations.NotNull;

public class SurveyorBlockEntity
extends class_2586 {
    private int detectionCooldown;
    private int lastDetectionPower;

    public SurveyorBlockEntity(class_2338 pos, class_2680 state) {
        super(TTBlockEntityTypes.SURVEYOR, pos, state);
    }

    private static class_243 chooseClosestPos(@NotNull class_243 origin, class_243 posA, class_243 posB) {
        if (origin.method_1022(posA) > origin.method_1022(posB)) {
            return posB;
        }
        return posA;
    }

    @NotNull
    public static class_243 getEyePosition(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return SurveyorBlockEntity.getEyePosition(pos, state, 0.55);
    }

    @NotNull
    public static class_243 getViewEndPosition(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return SurveyorBlockEntity.getEyePosition(pos, state, 15.5);
    }

    @NotNull
    public static class_243 getEyePosition(@NotNull class_2338 pos, @NotNull class_2680 state, double distanceFromCenter) {
        class_2350 direction = (class_2350)state.method_11654(SurveyorBlock.FACING);
        return pos.method_46558().method_1031(distanceFromCenter * (double)direction.method_10148(), distanceFromCenter * (double)direction.method_10164(), distanceFromCenter * (double)direction.method_10165());
    }

    protected void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        this.lastDetectionPower = valueInput.method_71424("last_detection_power", 0);
        this.detectionCooldown = valueInput.method_71424("detection_cooldown", 0);
    }

    protected void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71465("last_detection_power", this.lastDetectionPower);
        valueOutput.method_71465("detection_cooldown", this.detectionCooldown);
    }

    public void tickServer(class_3218 serverLevel, class_2338 pos, class_2680 state) {
        if (this.detectionCooldown <= 0) {
            boolean isBlocked;
            this.detectionCooldown = 2;
            int closestDetection = 16;
            class_2350 facing = (class_2350)state.method_11654(SurveyorBlock.FACING);
            class_2338 inFrontPos = pos.method_10093(facing);
            class_2680 inFrontState = serverLevel.method_8320(pos.method_10093(facing));
            boolean bl = isBlocked = !SurveyorBlockEntity.canSeeThroughBlock((class_1922)serverLevel, inFrontState, inFrontPos);
            if (!isBlocked) {
                class_243 surveyorCenterPos = class_243.method_24953((class_2382)pos);
                class_243 startClipPos = SurveyorBlockEntity.getEyePosition(pos, state);
                class_243 endClipPos = SurveyorBlockEntity.getViewEndPosition(pos, state);
                class_2338 startBlockPos = class_2338.method_49638((class_2374)startClipPos);
                class_2338 endBlockPos = class_2338.method_49638((class_2374)endClipPos);
                class_238 detectionBox = class_238.method_54784((class_2338)startBlockPos, (class_2338)endBlockPos);
                List players = serverLevel.method_18023(class_5575.method_31795(class_1657.class), detectionBox, class_1301.field_6155);
                for (class_1657 player : players) {
                    class_3965 blockHitResult;
                    class_239 hitResult;
                    int distance;
                    class_243 closestPoint = this.closestPointTo(player.method_5829(), startClipPos);
                    Optional<Object> headPoint = Optional.empty();
                    Optional<Object> footPoint = Optional.empty();
                    if (player.method_5767() && player.method_6118(class_1304.field_6172).method_7960() && player.method_6118(class_1304.field_6174).method_7960()) {
                        if (!player.method_6118(class_1304.field_6166).method_7960() && detectionBox.method_1006(player.method_19538())) {
                            footPoint = Optional.of(player.method_19538());
                        }
                        if (!player.method_6118(class_1304.field_6169).method_7960() && detectionBox.method_1006(player.method_33571())) {
                            headPoint = Optional.of(player.method_33571());
                        }
                        if (headPoint.isPresent() && footPoint.isPresent()) {
                            closestPoint = SurveyorBlockEntity.chooseClosestPos(closestPoint, (class_243)headPoint.get(), (class_243)footPoint.get());
                        } else if (headPoint.isPresent()) {
                            closestPoint = (class_243)headPoint.get();
                        } else {
                            if (!footPoint.isPresent()) continue;
                            closestPoint = (class_243)footPoint.get();
                        }
                    }
                    if ((distance = (int)closestPoint.method_1022(startClipPos)) >= closestDetection || (hitResult = class_1675.method_18074((class_243)closestPoint, (class_1297)player, class_1301.field_6155.and(entity -> !entity.method_5767() && !entity.method_5864().method_20210(TTEntityTags.SURVEYOR_IGNORES)), (class_243)surveyorCenterPos.method_1020(closestPoint), (class_1937)serverLevel, (float)0.0f, (class_3959.class_3960)TTClipContextShapeGetters.SURVEYOR_SIGHT)).method_17783() != class_239.class_240.field_1332 || !(blockHitResult = (class_3965)hitResult).method_17777().equals((Object)pos)) continue;
                    closestDetection = distance;
                }
            }
            int previousDetection = this.lastDetectionPower;
            this.lastDetectionPower = Math.clamp((long)(15 - closestDetection), 0, 15);
            boolean updateNeighbors = previousDetection != this.lastDetectionPower;
            SurveyorBlock.updatePower((class_1937)serverLevel, pos, state, this.lastDetectionPower, updateNeighbors);
        } else {
            --this.detectionCooldown;
        }
    }

    public static boolean canSeeThroughBlock(class_1922 level, @NotNull class_2680 blockState, class_2338 pos) {
        if (blockState.method_26164(TTBlockTags.SURVEYOR_CAN_SEE_THROUGH) && !blockState.method_26164(TTBlockTags.SURVEYOR_CANNOT_SEE_THROUGH)) {
            return true;
        }
        return !blockState.method_26234(level, pos);
    }

    private class_243 closestPointTo(@NotNull class_238 aabb, @NotNull class_243 point) {
        class_243[] vec3s = new class_243[1];
        double d = class_3532.method_15350((double)point.method_10216(), (double)aabb.field_1323, (double)aabb.field_1320);
        double e = class_3532.method_15350((double)point.method_10214(), (double)aabb.field_1322, (double)aabb.field_1325);
        double f = class_3532.method_15350((double)point.method_10215(), (double)aabb.field_1321, (double)aabb.field_1324);
        if (vec3s[0] == null || point.method_1028(d, e, f) < point.method_1025(vec3s[0])) {
            vec3s[0] = new class_243(d, e, f);
        }
        return vec3s[0];
    }

    public int getLastDetectionPower() {
        return this.lastDetectionPower;
    }

    public void setLastDetectionPower(int lastDetectionPower) {
        this.lastDetectionPower = lastDetectionPower;
    }
}

