/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.trailiertales;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.frozenblock.lib.debug.client.api.DebugRendererEvents;
import net.frozenblock.lib.debug.client.impl.DebugRenderManager;
import net.frozenblock.lib.menu.api.SplashTextAPI;
import net.frozenblock.lib.music.api.client.pitch.MusicPitchApi;
import net.frozenblock.trailiertales.TTConstants;
import net.frozenblock.trailiertales.client.TTBlockRenderLayers;
import net.frozenblock.trailiertales.client.TTModelLayers;
import net.frozenblock.trailiertales.client.TTParticleEngine;
import net.frozenblock.trailiertales.client.renderer.debug.CoffinDebugRenderer;
import net.frozenblock.trailiertales.config.TTMiscConfig;
import net.frozenblock.trailiertales.networking.packet.CoffinDebugPacket;
import net.frozenblock.trailiertales.networking.packet.CoffinRemoveDebugPacket;
import net.frozenblock.trailiertales.worldgen.structure.datagen.CatacombsGenerator;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class TrailierTalesClient
implements ClientModInitializer {
    public void onInitializeClient() {
        SplashTextAPI.addSplashLocation((class_2960)TTConstants.id("texts/splashes.txt"));
        TTBlockRenderLayers.init();
        TTModelLayers.init();
        TTParticleEngine.init();
        MusicPitchApi.registerForStructureInside((class_2960)CatacombsGenerator.CATACOMBS_KEY.method_29177(), TrailierTalesClient::calculateCatacombsMusicPitch);
        DebugRendererEvents.DEBUG_RENDERERS_CREATED.register(client -> {
            CoffinDebugRenderer coffinDebugRenderer = new CoffinDebugRenderer(client);
            ClientPlayNetworking.registerGlobalReceiver(CoffinDebugPacket.PACKET_TYPE, (packet, ctx) -> coffinDebugRenderer.addConnection(packet.entityId(), packet.coffinPos(), packet.lastInteractionTime(), packet.gameTime()));
            ClientPlayNetworking.registerGlobalReceiver(CoffinRemoveDebugPacket.PACKET_TYPE, (packet, ctx) -> coffinDebugRenderer.scheduleRemoval(packet.entityId()));
            DebugRenderManager.addClearRunnable(coffinDebugRenderer::method_20414);
            DebugRenderManager.registerRenderer((class_2960)TTConstants.id("coffin"), coffinDebugRenderer::method_23109);
        });
    }

    private static float calculateCatacombsMusicPitch(long gameTime) {
        if (!TTMiscConfig.Client.DISTORTED_CATACOMBS_MUSIC) {
            return 1.0f;
        }
        float basePitch = 0.98f + class_3532.method_15374((float)((float)((double)gameTime * Math.PI / 1000.0))) * 0.005f;
        float additionalPitchChangeA = class_3532.method_15363((float)(class_3532.method_15362((float)((float)((double)gameTime * Math.PI / 600.0))) * 0.5f), (float)-0.00975f, (float)0.00975f);
        float additionalWobble = class_3532.method_15374((float)((float)((double)gameTime * Math.PI / 20.0))) * 0.005f;
        return basePitch + additionalPitchChangeA + additionalWobble;
    }
}

