/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.configuration;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.network.ConfigurationMessageContext;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import com.mrcrayfish.framework.network.FrameworkCodecs;
import com.mrcrayfish.framework.network.message.ConfigurationMessage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9139;
import org.apache.commons.lang3.tuple.Pair;

public record S2CSyncedEntityData(Map<class_2960, List<Pair<class_2960, Integer>>> keyMap) {
    public static final class_9139<class_2540, S2CSyncedEntityData> STREAM_CODEC = class_9139.method_56434(FrameworkCodecs.ENTITY_DATA_KEYS, S2CSyncedEntityData::keyMap, S2CSyncedEntityData::new);

    public static void handle(S2CSyncedEntityData message, ConfigurationMessageContext context) {
        Constants.LOG.debug(ConfigurationMessage.MARKER, "Receiving synced entity keys from server");
        boolean[] failed = new boolean[1];
        CountDownLatch block = new CountDownLatch(1);
        context.execute(() -> {
            if (!SyncedEntityData.instance().updateMappings(message)) {
                failed[0] = true;
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            failed[0] = true;
        }
        if (failed[0]) {
            context.disconnect((class_2561)class_2561.method_43471((String)"framework.gui.sync_entity_data_failed"));
        }
    }

    public Map<class_2960, List<Pair<class_2960, Integer>>> getKeyMap() {
        return this.keyMap;
    }
}

