/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.client.resources.IDataLoader;
import com.mrcrayfish.framework.client.resources.IResourceSupplier;
import com.mrcrayfish.framework.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.apache.commons.lang3.tuple.Pair;

public final class JsonDataManager
extends class_4080<List<Pair<IDataLoader<IResourceSupplier>, List<Pair<IResourceSupplier, DataObject>>>>> {
    public static final class_2960 ID = Utils.rl("json_data_manager");
    private static final Gson GSON = new GsonBuilder().create();
    private static JsonDataManager instance;
    private final List<IDataLoader<IResourceSupplier>> loaders = new ArrayList<IDataLoader<IResourceSupplier>>();

    public static JsonDataManager getInstance() {
        if (instance == null) {
            instance = new JsonDataManager();
        }
        return instance;
    }

    private JsonDataManager() {
    }

    public void addLoader(IDataLoader<?> loader) {
        this.loaders.add(loader);
    }

    protected List<Pair<IDataLoader<IResourceSupplier>, List<Pair<IResourceSupplier, DataObject>>>> prepare(class_3300 manager, class_3695 filler) {
        ArrayList<Pair<IDataLoader<IResourceSupplier>, List<Pair<IResourceSupplier, DataObject>>>> list = new ArrayList<Pair<IDataLoader<IResourceSupplier>, List<Pair<IResourceSupplier, DataObject>>>>();
        this.loaders.forEach(loader -> {
            ArrayList pairs = new ArrayList();
            loader.getResourceSuppliers().forEach(supplier -> {
                class_2960 location = supplier.getLocation();
                Optional optional = manager.method_14486(location);
                if (optional.isPresent()) {
                    try (BufferedReader reader = ((class_3298)optional.get()).method_43039();){
                        JsonElement element = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
                        if (element == null) {
                            return;
                        }
                        DataObject dataObject = DataObject.convert(element);
                        if (dataObject == null) {
                            return;
                        }
                        pairs.add(Pair.of((Object)supplier, (Object)dataObject));
                    }
                    catch (IOException e) {
                        Constants.LOG.error("Failed to json data", (Throwable)e);
                        pairs.add(Pair.of((Object)supplier, (Object)DataObject.EMPTY));
                    }
                } else {
                    pairs.add(Pair.of((Object)supplier, (Object)DataObject.EMPTY));
                }
            });
            list.add(Pair.of((Object)loader, pairs));
        });
        return list;
    }

    protected void apply(List<Pair<IDataLoader<IResourceSupplier>, List<Pair<IResourceSupplier, DataObject>>>> list, class_3300 p_10794_, class_3695 p_10795_) {
        list.forEach(pair -> ((IDataLoader)pair.getLeft()).process((List)pair.getRight()));
    }
}

