/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.text;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.playerdata.PlayerProfile;
import com.fibermc.essentialcommands.text.ECTextImpl;
import com.fibermc.essentialcommands.text.PlayerECTextImpl;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.fibermc.essentialcommands.types.IStyleProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class ECText {
    protected final Map<String, String> stringMap;
    private static final Gson GSON = new Gson();
    private static final Pattern TOKEN_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
    public static final String DEFAULT_LANGUAGE_SPEC = "en_us";
    private static volatile ECText instance = ECText.create(EssentialCommands.CONFIG.LANGUAGE);
    private static MinecraftServer server;

    protected ECText(Map<String, String> stringMap) {
        this.stringMap = stringMap;
    }

    public static void init(MinecraftServer server) {
        ECText.server = server;
    }

    private static ECText create(String langId) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String resourceFString = "/assets/essential_commands/lang/%s.json";
        String resourceLocation = String.format("/assets/essential_commands/lang/%s.json", langId);
        try {
            InputStream inputStream = ECText.class.getResourceAsStream(resourceLocation);
            if (inputStream == null) {
                EssentialCommands.LOGGER.info(String.format("No EC lang file for the language '%s' found. Defaulting to 'en_us'.", langId));
                inputStream = ECText.class.getResourceAsStream(String.format("/assets/essential_commands/lang/%s.json", DEFAULT_LANGUAGE_SPEC));
            }
            try {
                ECText.load(inputStream, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (JsonParseException | IOException ex) {
            EssentialCommands.LOGGER.error("Couldn't read strings from {}", (Object)resourceLocation, (Object)ex);
        }
        ImmutableMap map = builder.build();
        instance = server == null ? new ECTextImpl((Map<String, String>)map, ParserContext.of()) : ECTextImpl.forServer((Map<String, String>)map, server);
        return instance;
    }

    public static void load(InputStream inputStream, BiConsumer<String, String> entryConsumer) {
        JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry stringJsonElementEntry : jsonObject.entrySet()) {
            String key = (String)stringJsonElementEntry.getKey();
            JsonElement value = (JsonElement)stringJsonElementEntry.getValue();
            String string = TOKEN_PATTERN.matcher(class_3518.method_15287((JsonElement)value, (String)key)).replaceAll("%$1s");
            entryConsumer.accept(key, string);
        }
    }

    public static ECText getInstance() {
        return instance;
    }

    public abstract String getString(String var1);

    public abstract class_5250 getText(String var1, class_2561 ... var2);

    public abstract class_5250 getText(String var1, TextFormatType var2, class_2561 ... var3);

    public abstract class_5250 getText(String var1, TextFormatType var2, IStyleProvider var3, class_2561 ... var4);

    public abstract boolean hasTranslation(String var1);

    public abstract boolean isRightToLeft();

    public abstract class_5481 reorder(class_5348 var1);

    public class_5250 literal(String str) {
        return class_2561.method_43470((String)str).method_10862(EssentialCommands.CONFIG.FORMATTING_DEFAULT);
    }

    public class_5250 accent(String str) {
        return class_2561.method_43470((String)str).method_10862(EssentialCommands.CONFIG.FORMATTING_ACCENT);
    }

    public class_5250 error(String str) {
        return class_2561.method_43470((String)str).method_10862(EssentialCommands.CONFIG.FORMATTING_ERROR);
    }

    public List<class_5481> reorder(List<class_5348> texts) {
        return (List)texts.stream().map(this::reorder).collect(ImmutableList.toImmutableList());
    }

    public static ECText forPlayer(class_3222 player) {
        return new PlayerECTextImpl(ECText.getInstance().stringMap, ParserContext.of((ParserContext.Key)PlaceholderContext.KEY, (Object)PlaceholderContext.of((class_3222)player)), PlayerProfile.access(player));
    }

    public static ECText access(@Nullable class_3222 player) {
        return player == null ? ECText.getInstance() : ((ServerPlayerEntityAccess)player).ec$getEcText();
    }

    static {
        EssentialCommands.BACKING_CONFIG.LANGUAGE.changeEvent.register(langId -> {
            instance = ECText.create(langId);
        });
    }
}

