/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.teleportation;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.events.PlayerDamageCallback;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.playerdata.PlayerDataManager;
import com.fibermc.essentialcommands.playerdata.PlayerProfile;
import com.fibermc.essentialcommands.teleportation.PlayerTeleporter;
import com.fibermc.essentialcommands.teleportation.QueuedLocationTeleport;
import com.fibermc.essentialcommands.teleportation.QueuedTeleport;
import com.fibermc.essentialcommands.teleportation.TeleportRequest;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import dev.jpcode.eccore.util.TimeUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import net.minecraft.class_1282;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public final class TeleportManager {
    private final List<TeleportRequest> activeTeleportRequests;
    private final List<PlayerData> playersOnTeleportCooldown;
    private final Map<UUID, QueuedTeleport> queuedTeleportMap;
    private static TeleportManager instance;

    private TeleportManager() {
        instance = this;
        this.activeTeleportRequests = new LinkedList<TeleportRequest>();
        this.playersOnTeleportCooldown = new LinkedList<PlayerData>();
        this.queuedTeleportMap = new ConcurrentHashMap<UUID, QueuedTeleport>();
    }

    public static TeleportManager getInstance() {
        if (instance == null) {
            instance = new TeleportManager();
        }
        return instance;
    }

    public static void init() {
        TeleportManager.getInstance();
        PlayerDamageCallback.EVENT.register((playerEntity, source) -> instance.onPlayerDamaged(playerEntity, source));
        PlayerDataManager.TICK_EVENT.register((playerDataManager, server) -> instance.tick(server));
    }

    public void tick(MinecraftServer server) {
        this.activeTeleportRequests.removeIf(TeleportRequest::isEnded);
        for (TeleportRequest teleportRequest : this.activeTeleportRequests) {
            teleportRequest.incrementAgeTicks();
            if (teleportRequest.getAgeTicks() <= EssentialCommands.CONFIG.TELEPORT_REQUEST_DURATION_TICKS) continue;
            teleportRequest.end();
            teleportRequest.getSenderPlayerData().sendMessage("teleport.request.expired.sender", teleportRequest.getTargetPlayer().method_5476());
            teleportRequest.getTargetPlayerData().sendMessage("teleport.request.expired.receiver", teleportRequest.getSenderPlayer().method_5476());
        }
        ListIterator<PlayerData> tpCooldownIterator = this.playersOnTeleportCooldown.listIterator();
        while (tpCooldownIterator.hasNext()) {
            PlayerData playerData = tpCooldownIterator.next();
            playerData.tickTpCooldown();
            if (playerData.getTpCooldown() >= 0) continue;
            tpCooldownIterator.remove();
        }
        boolean shouldInterruptTeleportOnMove = EssentialCommands.CONFIG.TELEPORT_INTERRUPT_ON_MOVE;
        double maxMoveBeforeInterrupt = EssentialCommands.CONFIG.TELEPORT_INTERRUPT_ON_MOVE_AMOUNT;
        Iterator<Map.Entry<UUID, QueuedTeleport>> tpQueueIter = this.queuedTeleportMap.entrySet().iterator();
        while (tpQueueIter.hasNext()) {
            Map.Entry<UUID, QueuedTeleport> entry = tpQueueIter.next();
            QueuedTeleport queuedTeleport = entry.getValue();
            queuedTeleport.tick(server);
            PlayerData playerData = queuedTeleport.getPlayerData();
            if (shouldInterruptTeleportOnMove && playerData.hasMovedThisTick() && playerData.getPlayer().method_19538().method_1022(queuedTeleport.initialPosition) > maxMoveBeforeInterrupt && !PlayerTeleporter.playerHasTpRulesBypass(playerData.getPlayer(), "essentialcommands.bypass.teleport_interrupt_on_move")) {
                playerData.sendError("teleport.interrupted.moved", new class_2561[0]);
                tpQueueIter.remove();
                continue;
            }
            if (queuedTeleport.getTicksRemaining() >= 0) continue;
            tpQueueIter.remove();
            PlayerTeleporter.teleport(queuedTeleport);
        }
    }

    public void onPlayerDamaged(class_3222 playerEntity, class_1282 damageSource) {
        if (!EssentialCommands.CONFIG.TELEPORT_INTERRUPT_ON_DAMAGED) {
            return;
        }
        ServerPlayerEntityAccess playerAccess = (ServerPlayerEntityAccess)playerEntity;
        if (playerAccess.ec$getQueuedTeleport() != null && !PlayerTeleporter.playerHasTpRulesBypass(playerEntity, "essentialcommands.bypass.teleport_interrupt_on_damaged")) {
            playerAccess.ec$endQueuedTeleport();
            this.queuedTeleportMap.remove(playerEntity.method_5667());
            playerAccess.ec$getPlayerData().sendError("teleport.interrupted.damage", new class_2561[0]);
        }
    }

    public void startTpRequest(class_3222 requestSender, class_3222 targetPlayer, TeleportRequest.Type requestType) {
        PlayerData senderPlayerData = PlayerData.access(requestSender);
        PlayerData targetPlayerData = PlayerData.access(targetPlayer);
        TeleportRequest teleportRequest = new TeleportRequest(requestSender, targetPlayer, requestType);
        senderPlayerData.addSentTeleportRequest(teleportRequest);
        targetPlayerData.addIncomingTeleportRequest(teleportRequest);
        this.activeTeleportRequests.add(teleportRequest);
    }

    public void startTpCooldown(class_3222 player) {
        int teleportCooldownTicks = (int)(EssentialCommands.CONFIG.TELEPORT_COOLDOWN * 20.0);
        PlayerData playerData = PlayerData.access(player);
        playerData.setTpCooldown(teleportCooldownTicks);
        this.playersOnTeleportCooldown.add(playerData);
    }

    void queueTeleport(class_3222 player, MinecraftLocation dest, class_5250 destName) {
        this.queueTeleport(new QueuedLocationTeleport(PlayerData.access(player), dest, destName));
    }

    void queueTeleport(QueuedTeleport queuedTeleport) {
        PlayerData playerData = queuedTeleport.getPlayerData();
        ServerPlayerEntityAccess playerAccess = (ServerPlayerEntityAccess)playerData.getPlayer();
        QueuedTeleport prevValue = this.queuedTeleportMap.put(queuedTeleport.getPlayerData().getPlayer().method_5667(), queuedTeleport);
        if (prevValue != null) {
            PlayerProfile profile = playerAccess.ec$getProfile();
            UnaryOperator styleUpdater = profile.nonOverwritingColorUpdater(TextFormatType.Accent);
            prevValue.getPlayerData().sendMessage("teleport.request.canceled_by_new", new class_2561[]{prevValue.getDestName().method_27694(styleUpdater), queuedTeleport.getDestName().method_27694(styleUpdater)});
        }
        playerAccess.ec$setQueuedTeleport(queuedTeleport);
        playerData.sendMessage("teleport.queued", new class_2561[]{queuedTeleport.getDestName().method_10862(playerAccess.ec$getProfile().getStyle(TextFormatType.Accent)), playerAccess.ec$getEcText().accent(String.format("%.1f", TimeUtil.ticksToSeconds((int)EssentialCommands.CONFIG.TELEPORT_DELAY_TICKS)))});
    }
}

