/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.playerdata;

import com.fibermc.essentialcommands.ECAbilitySources;
import com.fibermc.essentialcommands.ECPerms;
import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.access.ServerPlayerEntityAccess;
import com.fibermc.essentialcommands.codec.Codecs;
import com.fibermc.essentialcommands.commands.CommandUtil;
import com.fibermc.essentialcommands.commands.InvulnCommand;
import com.fibermc.essentialcommands.commands.helpers.IFeedbackReceiver;
import com.fibermc.essentialcommands.events.PlayerActCallback;
import com.fibermc.essentialcommands.playerdata.IServerPlayerEntityData;
import com.fibermc.essentialcommands.playerdata.PlayerDataManager;
import com.fibermc.essentialcommands.teleportation.OutgoingTeleportRequests;
import com.fibermc.essentialcommands.teleportation.TeleportRequest;
import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.NamedLocationStorage;
import com.fibermc.essentialcommands.types.NamedMinecraftLocation;
import com.fibermc.essentialcommands.util.NicknameTextUtil;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.jpcode.eccore.util.TextUtil;
import dev.jpcode.eccore.util.TimeUtil;
import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.Pal;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.VanillaAbilities;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.drex.vanish.api.VanishAPI;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_2792;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import org.jetbrains.annotations.NotNull;

public class PlayerData
extends class_18
implements IServerPlayerEntityData,
IFeedbackReceiver {
    private class_3222 player;
    private UUID pUuid;
    private File saveFile;
    private final OutgoingTeleportRequests outgoingTeleportRequests = new OutgoingTeleportRequests();
    private final LinkedHashMap<UUID, TeleportRequest> incomingTeleportRequests;
    NamedLocationStorage homes;
    private MinecraftLocation previousLocation;
    private int tpCooldown;
    private class_2561 nickname;
    private class_5250 fullNickname;
    private int timeUsedRtp;
    private boolean afk;
    private class_243 lastTickPos;
    private boolean isInCombat;
    private int lastActionTick;
    private int lastMovedTick;
    private boolean hasMovedThisTick;
    private boolean isSleepingFromCommand;
    public final Event<PlayerActCallback> playerActEvent = EventFactory.createArrayBacked(PlayerActCallback.class, listeners -> packet -> {
        for (PlayerActCallback event : listeners) {
            event.onPlayerAct((class_2596<class_2792>)packet);
        }
    });
    public static final Codec<PlayerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NamedLocationStorage.CODEC.optionalFieldOf("homes", (Object)new NamedLocationStorage()).forGetter(pd -> pd.homes), (App)Codecs.MINECRAFT_LOCATION.optionalFieldOf("previousLocation").forGetter(pd -> Optional.ofNullable(pd.previousLocation)), (App)class_8824.field_46597.optionalFieldOf("nickname").forGetter(pd -> Optional.ofNullable(pd.nickname)), (App)Codec.LONG.optionalFieldOf("timeUsedRtpEpochMs", (Object)0L).forGetter(pd -> TimeUtil.tickTimeToEpochMs((int)pd.timeUsedRtp)), (App)Codec.INT.optionalFieldOf("tpCooldown", (Object)0).forGetter(pd -> pd.tpCooldown)).apply((Applicative)instance, PlayerData::createWithData));

    public PlayerData(class_3222 player, File saveFile) {
        this.incomingTeleportRequests = new LinkedHashMap();
        this.homes = new NamedLocationStorage();
        this.initializeRuntimeState(player, saveFile);
    }

    public PlayerData(File saveFile) {
        this.saveFile = saveFile;
        this.incomingTeleportRequests = new LinkedHashMap();
        this.homes = new NamedLocationStorage();
    }

    private PlayerData() {
        this.saveFile = null;
        this.incomingTeleportRequests = new LinkedHashMap();
    }

    public static PlayerData createWithData(NamedLocationStorage homes, Optional<MinecraftLocation> previousLocation, Optional<class_2561> nickname, long timeUsedRtpEpochMs, int tpCooldown) {
        PlayerData pd = new PlayerData();
        pd.homes = homes;
        pd.previousLocation = previousLocation.orElse(null);
        pd.nickname = nickname.orElse(null);
        pd.timeUsedRtp = TimeUtil.epochTimeMsToTicks((long)timeUsedRtpEpochMs);
        pd.tpCooldown = tpCooldown;
        return pd;
    }

    public void initializeRuntimeState(class_3222 player, File saveFile) {
        this.player = player;
        this.saveFile = saveFile;
        this.lastTickPos = player.method_19538();
        this.lastActionTick = player.method_5682().method_3780();
        this.pUuid = player.method_5667();
        this.playerActEvent.register(packet -> {
            this.updateLastActionTick();
            this.setAfk(false);
        });
        if (this.nickname != null) {
            try {
                this.reloadFullNickname();
            }
            catch (NullPointerException ignore) {
                EssentialCommands.LOGGER.warn("Could not refresh player full nickname, as ServerPlayerEntity was null in PlayerData.");
            }
        }
        Pal.revokeAbility((class_1657)player, (PlayerAbility)VanillaAbilities.INVULNERABLE, (AbilitySource)ECAbilitySources.SLEEP_INVULN);
        this.updatePlayerEntity(player);
    }

    public OutgoingTeleportRequests getSentTeleportRequests() {
        return this.outgoingTeleportRequests;
    }

    public void addSentTeleportRequest(TeleportRequest request) {
        this.outgoingTeleportRequests.add(request);
    }

    public void removeSentTeleportRequest(TeleportRequest request) {
        this.outgoingTeleportRequests.remove(request);
    }

    public LinkedHashMap<UUID, TeleportRequest> getIncomingTeleportRequests() {
        return this.incomingTeleportRequests;
    }

    public TeleportRequest getIncomingTeleportRequest(UUID tpAsker) {
        return this.incomingTeleportRequests.get(tpAsker);
    }

    public void addIncomingTeleportRequest(TeleportRequest teleportRequest) {
        this.incomingTeleportRequests.put(teleportRequest.getSenderPlayer().method_5667(), teleportRequest);
    }

    public void removeIncomingTeleportRequest(UUID tpAsker) {
        this.incomingTeleportRequests.remove(tpAsker);
    }

    @Override
    public class_3222 getPlayer() {
        return this.player;
    }

    public void addHome(String homeName, MinecraftLocation minecraftLocation) throws CommandSyntaxException {
        int playerMaxHomes = ECPerms.getHighestNumericPermission(this.player.method_64396(), ECPerms.Registry.Group.home_limit_group);
        if (this.homes.size() >= playerMaxHomes) {
            ECText ecText = ECText.access(this.player);
            class_5250 homeNameText = ecText.accent(homeName);
            class_5250 maxHomesText = ecText.accent(String.valueOf(playerMaxHomes));
            throw CommandUtil.createSimpleException((Message)ecText.getText("cmd.home.set.error.limit", TextFormatType.Error, new class_2561[]{homeNameText, maxHomesText}));
        }
        this.homes.putCommand(homeName, minecraftLocation);
        this.method_80();
    }

    public boolean existsHome(String homeName) {
        return this.homes.containsKey(homeName);
    }

    @Override
    public void sendCommandFeedback(class_2561 text) {
        this.player.method_64396().method_9226(() -> text, EssentialCommands.CONFIG.BROADCAST_TO_OPS);
    }

    @Override
    public void sendCommandFeedback(String messageKey, class_2561 ... args) {
        this.sendCommandFeedback((class_2561)ECText.access(this.player).getText(messageKey, TextFormatType.Default, args));
    }

    @Override
    public void sendCommandError(class_2561 text) {
        this.player.method_64396().method_9213(text);
    }

    @Override
    public void sendCommandError(String messageKey, class_2561 ... args) {
        this.sendCommandError((class_2561)ECText.access(this.player).getText(messageKey, TextFormatType.Error, args));
    }

    public void sendMessage(String messageKey, class_2561 ... args) {
        this.player.method_64398((class_2561)ECText.access(this.player).getText(messageKey, TextFormatType.Default, args));
    }

    public void sendError(String messageKey, class_2561 ... args) {
        this.player.method_64398((class_2561)ECText.access(this.player).getText(messageKey, TextFormatType.Error, args));
    }

    public Set<String> getHomeNames() {
        return this.homes.keySet();
    }

    public Set<Map.Entry<String, NamedMinecraftLocation>> getHomeEntries() {
        return this.homes.entrySet();
    }

    public NamedMinecraftLocation getHomeLocation(String homeName) {
        return (NamedMinecraftLocation)this.homes.get(homeName);
    }

    public void setAfk(boolean afk) {
        if (this.afk == afk) {
            return;
        }
        if (afk) {
            if (!EssentialCommands.CONFIG.ENABLE_AFK) {
                return;
            }
            if (EssentialCommands.CONFIG.INVULN_WHILE_AFK) {
                Pal.grantAbility((class_1657)this.player, (PlayerAbility)VanillaAbilities.INVULNERABLE, (AbilitySource)ECAbilitySources.AFK_INVULN);
            }
            if (!EssentialCommands.VANISH_PRESENT || !VanishAPI.isVanished((class_1297)this.player)) {
                this.player.method_5682().method_3760().method_43514((class_2561)ECText.getInstance().getText("player.afk.enter", this.player.method_5476()), false);
            }
            this.afk = true;
        } else {
            this.afk = false;
            Pal.revokeAbility((class_1657)this.player, (PlayerAbility)VanillaAbilities.INVULNERABLE, (AbilitySource)ECAbilitySources.AFK_INVULN);
            if (!EssentialCommands.VANISH_PRESENT || !VanishAPI.isVanished((class_1297)this.player)) {
                this.player.method_5682().method_3760().method_43514((class_2561)ECText.getInstance().getText("player.afk.exit", this.player.method_5476()), false);
            }
        }
        PlayerDataManager.getInstance().markNicknameDirty(this);
    }

    public boolean isAfk() {
        return this.afk;
    }

    public void onTickEnd() {
        int ticks = this.player.method_5682().method_3780();
        class_243 currentPos = this.player.method_19538();
        boolean bl = this.hasMovedThisTick = !this.lastTickPos.equals((Object)currentPos);
        if (this.hasMovedThisTick) {
            this.lastMovedTick = ticks;
        }
        if (this.afk) {
            if (EssentialCommands.CONFIG.INVULN_WHILE_AFK) {
                this.player.method_5859(this.lastTickPos.field_1352, this.lastTickPos.field_1351, this.lastTickPos.field_1350);
            } else if (this.hasMovedThisTick) {
                this.setAfk(false);
            }
        } else if (EssentialCommands.CONFIG.AUTO_AFK_ENABLED && ticks - Math.max(this.lastMovedTick, this.lastActionTick) > EssentialCommands.CONFIG.AUTO_AFK_TICKS) {
            this.setAfk(true);
        }
        this.lastTickPos = this.player.method_19538();
    }

    public class_243 getLastTickPos() {
        return this.lastTickPos;
    }

    public boolean isInCombat() {
        return this.isInCombat;
    }

    public void setInCombat(boolean inCombat) {
        this.isInCombat = inCombat;
    }

    public boolean hasMovedThisTick() {
        return this.hasMovedThisTick;
    }

    public double distanceMovedThisTick() {
        return this.lastTickPos.method_1022(this.player.method_19538());
    }

    public int getLastActionTick() {
        return this.lastActionTick;
    }

    public int ticksSinceLastActionOrMove() {
        return this.player.method_5682().method_3780() - Math.max(this.lastMovedTick, this.lastActionTick);
    }

    public void updateLastActionTick() {
        this.lastActionTick = this.player.method_5682().method_3780();
    }

    public boolean isSleepingFromCommand() {
        return this.isSleepingFromCommand;
    }

    public void setIsSleepingFromCommand(boolean sleepingFromCommand) {
        this.isSleepingFromCommand = sleepingFromCommand;
        if (EssentialCommands.CONFIG.SLEEP_INVULN && sleepingFromCommand) {
            Pal.grantAbility((class_1657)this.player, (PlayerAbility)VanillaAbilities.INVULNERABLE, (AbilitySource)ECAbilitySources.SLEEP_INVULN);
        }
    }

    public void fromNbt(class_2487 tag) {
        class_2487 dataTag = tag.method_10562("data").orElse(tag);
        DataResult result = CODEC.parse((DynamicOps)class_2509.field_11560, (Object)dataTag);
        if (result.isSuccess()) {
            PlayerData loaded = (PlayerData)result.getOrThrow();
            this.homes = loaded.homes;
            this.previousLocation = loaded.previousLocation;
            this.nickname = loaded.nickname;
            this.timeUsedRtp = loaded.timeUsedRtp;
            this.tpCooldown = loaded.tpCooldown;
            if (this.nickname != null && this.player != null) {
                try {
                    this.reloadFullNickname();
                }
                catch (NullPointerException ignore) {
                    EssentialCommands.LOGGER.warn("Could not refresh player full nickname, as ServerPlayerEntity was null in PlayerData.");
                }
            }
        } else {
            EssentialCommands.LOGGER.warn("Failed to parse PlayerData with codec, falling back to legacy parsing: {}", (Object)result.error());
            this.legacyFromNbt(dataTag);
        }
        if (this.player != null) {
            this.updatePlayerEntity(this.player);
        }
    }

    private void legacyFromNbt(class_2487 dataTag) {
        this.homes = dataTag.method_67491("homes", NamedLocationStorage.CODEC).orElseGet(NamedLocationStorage::new);
        dataTag.method_10558("nickname").ifPresent(nick -> {
            if ("null".equals(nick)) {
                return;
            }
            this.nickname = TextUtil.parseText((String)nick);
        });
        dataTag.method_10537("timeUsedRtpEpochMs").ifPresent(time -> {
            this.timeUsedRtp = TimeUtil.epochTimeMsToTicks((long)time);
        });
        if (EssentialCommands.CONFIG.PERSIST_BACK_LOCATION) {
            dataTag.method_10562("previousLocation").ifPresent(nbt -> {
                this.previousLocation = MinecraftLocation.fromNbt(nbt);
            });
        }
    }

    public class_2487 toNbt() {
        DataResult result = CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this);
        if (result.isSuccess()) {
            return (class_2487)((class_2520)result.getOrThrow()).method_68571().orElseThrow();
        }
        throw new RuntimeException("Failed to encode PlayerData with codec: " + String.valueOf(result.error()));
    }

    public void setPreviousLocation(MinecraftLocation location) {
        this.previousLocation = location;
        this.method_80();
    }

    public MinecraftLocation getPreviousLocation() {
        return this.previousLocation;
    }

    public boolean removeHome(String homeName) {
        MinecraftLocation old = (MinecraftLocation)this.homes.remove(homeName);
        if (old != null) {
            this.method_80();
            return true;
        }
        return false;
    }

    @Override
    public void updatePlayerEntity(class_3222 serverPlayerEntity) {
        boolean couldFly = VanillaAbilities.ALLOW_FLYING.getTracker((class_1657)this.player).isGrantedBy(ECAbilitySources.FLY_COMMAND);
        this.player = serverPlayerEntity;
        this.setFlight(couldFly);
    }

    private void updateFlight() {
        this.player.method_7355();
    }

    public void setFlight(boolean canFly) {
        this.setFlight(canFly, false);
    }

    public void setFlight(boolean canFly, boolean flyImmediately) {
        class_1656 abilities = this.player.method_31549();
        if (canFly) {
            Pal.grantAbility((class_1657)this.player, (PlayerAbility)VanillaAbilities.ALLOW_FLYING, (AbilitySource)ECAbilitySources.FLY_COMMAND);
            if (flyImmediately) {
                abilities.field_7479 = true;
            }
        } else {
            Pal.revokeAbility((class_1657)this.player, (PlayerAbility)VanillaAbilities.ALLOW_FLYING, (AbilitySource)ECAbilitySources.FLY_COMMAND);
        }
        PlayerDataManager.getInstance().scheduleTask(this::updateFlight);
    }

    public void clearAbilitiesWithoutPermisisons() {
        List<String> grantedAbilityPerms = ECPerms.getGrantedStatefulPlayerAbilityPermissions(this.player).toList();
        List<String> flyPermisisons = List.of(ECPerms.Registry.Group.fly_group);
        if (grantedAbilityPerms.stream().noneMatch(flyPermisisons::contains)) {
            this.setFlight(false);
        }
        List<String> invulnPermissions = List.of(ECPerms.Registry.Group.invuln_group);
        if (grantedAbilityPerms.stream().noneMatch(invulnPermissions::contains)) {
            InvulnCommand.exec(this.player, false);
        }
    }

    public void tickTpCooldown() {
        --this.tpCooldown;
    }

    public int getTpCooldown() {
        return this.tpCooldown;
    }

    public void setTpCooldown(int cooldown) {
        this.tpCooldown = cooldown;
    }

    public Optional<class_5250> getNickname() {
        return Optional.ofNullable(this.nickname != null ? this.nickname.method_27661() : null);
    }

    public class_5250 getFullNickname() {
        return this.fullNickname;
    }

    public class_5250 copyFullNickname() {
        return this.fullNickname != null ? TextUtil.deepCopy((class_2561)this.fullNickname) : null;
    }

    public int setNickname(class_2561 nickname) {
        int resultCode = 0;
        if (nickname == null) {
            this.nickname = null;
            resultCode = 1;
            EssentialCommands.LOGGER.info("Cleared {}'s nickname", (Object)this.player.method_7334().getName());
        } else {
            if (nickname.getString().length() > EssentialCommands.CONFIG.NICKNAME_MAX_LENGTH) {
                return -2;
            }
            boolean hasRequiredPerms = NicknameTextUtil.checkPerms(nickname, this.player.method_64396());
            if (!hasRequiredPerms) {
                EssentialCommands.LOGGER.info("{} attempted to set nickname to '{}', with insufficient permissions to do so.", (Object)this.player.method_7334().getName(), (Object)nickname);
                return -1;
            }
            EssentialCommands.LOGGER.info("Set {}'s nickname to '{}'.", (Object)this.player.method_7334().getName(), (Object)nickname);
            this.nickname = nickname;
        }
        this.reloadFullNickname();
        PlayerDataManager.getInstance().markNicknameDirty(this);
        this.method_80();
        return resultCode;
    }

    public void save() {
        class_2487 data = this.toNbt();
        try {
            class_2507.method_30614((class_2487)data, (Path)this.saveFile.toPath());
        }
        catch (IOException e) {
            EssentialCommands.LOGGER.error("Could not save data {}", (Object)this, (Object)e);
        }
    }

    public void setTimeUsedRtp(int i) {
        this.timeUsedRtp = i;
        this.method_80();
    }

    public int getTimeUsedRtp() {
        return this.timeUsedRtp;
    }

    private void reloadFullNickname() {
        class_5250 baseName = class_2561.method_43470((String)this.getPlayer().method_7334().getName());
        class_5250 tempFullNickname = class_2561.method_43473();
        if (this.nickname != null) {
            tempFullNickname.method_10852(EssentialCommands.CONFIG.NICKNAME_PREFIX).method_10852(this.nickname);
        } else {
            tempFullNickname.method_10852((class_2561)baseName);
        }
        if (EssentialCommands.CONFIG.NICK_REVEAL_ON_HOVER) {
            tempFullNickname.method_10862(tempFullNickname.method_10866().method_10949((class_2568)new class_2568.class_10613((class_2561)baseName)));
        }
        this.fullNickname = tempFullNickname;
    }

    public static PlayerData access(@NotNull class_3222 player) {
        return ((ServerPlayerEntityAccess)player).ec$getPlayerData();
    }

    public static PlayerData accessFromContextOrThrow(CommandContext<class_2168> context) throws CommandSyntaxException {
        return PlayerData.access(((class_2168)context.getSource()).method_9207());
    }

    private static final class StorageKey {
        static final String PLAYER_UUID = "playerUuid";
        static final String HOMES = "homes";
        static final String NICKNAME = "nickname";
        static final String TIME_USED_RTP_EPOCH_MS = "timeUsedRtpEpochMs";
        static final String PREVIOUS_LOCATION = "previousLocation";

        private StorageKey() {
        }
    }
}

