/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.datafixer;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.function.Supplier;

public final class NamedLocationStorageDataFixer {
    public static final DSL.TypeReference TYPE = () -> "named_location_storage";

    private NamedLocationStorageDataFixer() {
    }

    public static DataFixerBuilder createDataFixer() {
        DataFixerBuilder builder = new DataFixerBuilder(1);
        V1 schemaV0 = new V1(DataFixUtils.makeKey((int)1, (int)0), null);
        V1 schemaV1 = new V1(DataFixUtils.makeKey((int)2, (int)0), schemaV0);
        builder.addSchema((Schema)schemaV0);
        builder.addSchema((Schema)schemaV1);
        builder.addFixer((DataFix)new AddNameFieldFix(schemaV1));
        return builder;
    }

    public static class V1
    extends Schema {
        public V1(int versionKey, Schema parent) {
            super(versionKey, parent);
        }

        public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> entityTypes, Map<String, Supplier<TypeTemplate>> blockEntityTypes) {
            super.registerTypes(schema, entityTypes, blockEntityTypes);
            schema.registerType(false, TYPE, this::v1);
        }

        private TypeTemplate v1() {
            return DSL.compoundList((TypeTemplate)DSL.constType((Type)DSL.string()), (TypeTemplate)DSL.and((TypeTemplate)DSL.field((String)"WorldRegistryKey", (TypeTemplate)DSL.constType((Type)DSL.string())), (TypeTemplate[])new TypeTemplate[]{DSL.field((String)"x", (TypeTemplate)DSL.constType((Type)DSL.doubleType())), DSL.field((String)"y", (TypeTemplate)DSL.constType((Type)DSL.doubleType())), DSL.field((String)"z", (TypeTemplate)DSL.constType((Type)DSL.doubleType())), DSL.field((String)"headYaw", (TypeTemplate)DSL.constType((Type)DSL.floatType())), DSL.field((String)"pitch", (TypeTemplate)DSL.constType((Type)DSL.floatType())), DSL.field((String)"name", (TypeTemplate)DSL.constType((Type)DSL.string())), DSL.remainder()}));
        }
    }

    public static class AddNameFieldFix
    extends DataFix {
        public AddNameFieldFix(Schema outputSchema) {
            super(outputSchema, false);
        }

        public TypeRewriteRule makeRule() {
            Type inputType = this.getInputSchema().getType(TYPE);
            Type outputType = this.getOutputSchema().getType(TYPE);
            return this.fixTypeEverywhereTyped("AddNameFieldFix", inputType, outputType, typed -> typed.update(DSL.remainderFinder(), this::addNameFields));
        }

        private Dynamic<?> addNameFields(Dynamic<?> dynamic) {
            return dynamic.updateMapValues(pair -> {
                String locationName = (String)((Dynamic)pair.getFirst()).asString().getOrThrow();
                return pair.mapSecond(value -> value.set("name", dynamic.createString(locationName)));
            });
        }
    }

    public static class V0p1
    extends Schema {
        public V0p1(int versionKey, Schema parent) {
            super(versionKey, parent);
        }

        public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> entityTypes, Map<String, Supplier<TypeTemplate>> blockEntityTypes) {
            super.registerTypes(schema, entityTypes, blockEntityTypes);
            schema.registerType(false, TYPE, this::v0p1);
        }

        private TypeTemplate v0p1() {
            return DSL.compoundList((TypeTemplate)DSL.constType((Type)DSL.string()), (TypeTemplate)DSL.and((TypeTemplate)DSL.field((String)"WorldRegistryKey", (TypeTemplate)DSL.constType((Type)DSL.string())), (TypeTemplate[])new TypeTemplate[]{DSL.field((String)"x", (TypeTemplate)DSL.constType((Type)DSL.doubleType())), DSL.field((String)"y", (TypeTemplate)DSL.constType((Type)DSL.doubleType())), DSL.field((String)"z", (TypeTemplate)DSL.constType((Type)DSL.doubleType())), DSL.field((String)"headYaw", (TypeTemplate)DSL.constType((Type)DSL.floatType())), DSL.field((String)"pitch", (TypeTemplate)DSL.constType((Type)DSL.floatType())), DSL.remainder()}));
        }
    }

    public static class V0
    extends Schema {
        public V0(int versionKey, Schema parent) {
            super(versionKey, parent);
        }

        public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> entityTypes, Map<String, Supplier<TypeTemplate>> blockEntityTypes) {
            super.registerTypes(schema, entityTypes, blockEntityTypes);
            schema.registerType(false, TYPE, this::v0);
        }

        private TypeTemplate v0() {
            return DSL.compoundList((TypeTemplate)DSL.constType((Type)DSL.string()), (TypeTemplate)DSL.and((TypeTemplate)DSL.field((String)"WorldRegistryKey", (TypeTemplate)DSL.constType((Type)DSL.string())), (TypeTemplate[])new TypeTemplate[]{DSL.field((String)"x", (TypeTemplate)DSL.constType((Type)DSL.doubleType())), DSL.field((String)"y", (TypeTemplate)DSL.constType((Type)DSL.doubleType())), DSL.field((String)"z", (TypeTemplate)DSL.constType((Type)DSL.doubleType())), DSL.field((String)"headYaw", (TypeTemplate)DSL.constType((Type)DSL.floatType())), DSL.field((String)"pitch", (TypeTemplate)DSL.constType((Type)DSL.floatType())), DSL.remainder()}));
        }
    }
}

