/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands.utility;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.commands.CommandUtil;
import com.fibermc.essentialcommands.playerdata.PlayerData;
import com.fibermc.essentialcommands.text.ECText;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jpcode.eccore.util.TextUtil;
import java.util.List;
import me.drex.vanish.api.VanishAPI;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class NearCommand
implements Command<class_2168> {
    public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerData senderPlayerData = PlayerData.accessFromContextOrThrow(context);
        class_3222 targetPlayer = CommandUtil.getCommandTargetPlayer(context);
        return NearCommand.exec(senderPlayerData, targetPlayer, EssentialCommands.CONFIG.NEAR_COMMAND_DEFAULT_RADIUS);
    }

    public static int withRange(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerData senderPlayerData = PlayerData.accessFromContextOrThrow(context);
        class_3222 targetPlayer = CommandUtil.getCommandTargetPlayer(context);
        int range = IntegerArgumentType.getInteger(context, (String)"range");
        if (range > EssentialCommands.CONFIG.NEAR_COMMAND_MAX_RADIUS) {
            ECText ecTextSender = ECText.access(senderPlayerData.getPlayer());
            senderPlayerData.sendCommandError("cmd.near.error.range_too_high", new class_2561[]{ecTextSender.accent(String.valueOf(EssentialCommands.CONFIG.NEAR_COMMAND_MAX_RADIUS))});
            return 0;
        }
        return NearCommand.exec(senderPlayerData, targetPlayer, range);
    }

    public static int exec(PlayerData senderPlayerData, class_3222 targetPlayer, int range) {
        class_243 basePos = targetPlayer.method_19538();
        List<class_2561> players = targetPlayer.method_51469().method_18456().stream().filter(player -> targetPlayer.method_5667() != player.method_5667() && basePos.method_24802((class_2374)player.method_19538(), (double)range) && (!EssentialCommands.VANISH_PRESENT || VanishAPI.canSeePlayer((class_3222)player, (class_3222)senderPlayerData.getPlayer()))).map(class_1657::method_5476).toList();
        if (players.isEmpty()) {
            senderPlayerData.sendCommandFeedback("cmd.near.feedback.empty", new class_2561[0]);
        } else {
            senderPlayerData.sendCommandFeedback("cmd.near.feedback.list", new class_2561[]{TextUtil.join(players, (class_2561)class_2561.method_43470((String)", "))});
        }
        return 1;
    }
}

