/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands.commands;

import com.fibermc.essentialcommands.EssentialCommands;
import com.fibermc.essentialcommands.commands.suggestions.SuggestionListProvider;
import com.fibermc.essentialcommands.playerdata.PlayerProfile;
import com.fibermc.essentialcommands.text.ECText;
import com.fibermc.essentialcommands.text.TextFormatType;
import com.fibermc.essentialcommands.types.IStyleProvider;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import dev.jpcode.eccore.util.TextUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class ListCommandFactory {
    private ListCommandFactory() {
    }

    public static <T> Command<class_2168> create(String responsePreText, String commandExecText, SuggestionListProvider<Map.Entry<String, T>> suggestionsProvider) {
        return context -> {
            PlayerProfile styleProvider = PlayerProfile.accessFromContextOrThrow((CommandContext<class_2168>)context);
            Collection suggestionsList = suggestionsProvider.getSuggestionList((CommandContext<class_2168>)context);
            ((class_2168)context.getSource()).method_9226(() -> ListCommandFactory.getSuggestionText(responsePreText, commandExecText, suggestionsList, Map.Entry::getKey, styleProvider), EssentialCommands.CONFIG.BROADCAST_TO_OPS);
            return 0;
        };
    }

    public static <T> Command<class_2168> create(String responsePreText, String commandExecText, SuggestionListProvider<T> suggestionsProvider, Function<T, String> nameAccessor) {
        return context -> {
            PlayerProfile styleProvider = PlayerProfile.accessFromContextOrThrow((CommandContext<class_2168>)context);
            Collection suggestionsList = suggestionsProvider.getSuggestionList((CommandContext<class_2168>)context);
            ((class_2168)context.getSource()).method_9226(() -> ListCommandFactory.getSuggestionText(responsePreText, commandExecText, suggestionsList, nameAccessor, styleProvider), EssentialCommands.CONFIG.BROADCAST_TO_OPS);
            return 0;
        };
    }

    public static <T> class_2561 getSuggestionText(String responsePreText, String commandExecText, Collection<T> suggestionsList, Function<T, String> nameAccessor, IStyleProvider styleProvider) {
        class_5250 responseText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)responsePreText).method_10862(styleProvider.getStyle(TextFormatType.Default)));
        List suggestionTextList = suggestionsList.stream().map(nameAccessor).map(name -> TextUtil.clickableTeleport((class_5250)class_2561.method_43470((String)name).method_10862(styleProvider.getStyle(TextFormatType.Accent)), (String)name, (String)String.format("/%s", commandExecText))).collect(Collectors.toList());
        if (suggestionTextList.size() > 0) {
            responseText.method_10852((class_2561)TextUtil.join(suggestionTextList, (class_2561)class_2561.method_43470((String)", ").method_10862(styleProvider.getStyle(TextFormatType.Default))));
        } else {
            responseText.method_10852((class_2561)ECText.getInstance().getText("cmd.list.feedback.empty", TextFormatType.Error, styleProvider, new class_2561[0]));
        }
        return responseText;
    }
}

