/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands;

import com.fibermc.essentialcommands.codec.Codecs;
import com.fibermc.essentialcommands.types.MinecraftLocation;
import com.fibermc.essentialcommands.types.WarpStorage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldData {
    @Nullable
    private MinecraftLocation spawnLocation;
    @NotNull
    private final WarpStorage warps;
    public static final Codec<WorldData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.MINECRAFT_LOCATION.optionalFieldOf("spawn").forGetter(WorldData::getSpawn), (App)Codecs.WARP_STORAGE.fieldOf("warps").forGetter(WorldData::warps)).apply((Applicative)instance, WorldData::new));

    WorldData() {
        this.spawnLocation = null;
        this.warps = new WarpStorage();
    }

    WorldData(Optional<MinecraftLocation> spawnLocation, @NotNull WarpStorage warps) {
        this.spawnLocation = spawnLocation.orElse(null);
        this.warps = warps;
    }

    public WarpStorage warps() {
        return this.warps;
    }

    public Optional<MinecraftLocation> getSpawn() {
        return Optional.ofNullable(this.spawnLocation);
    }

    public void setSpawn(@Nullable MinecraftLocation spawn) {
        this.spawnLocation = spawn;
    }

    public static WorldData fromNbt(class_2487 nbt) {
        return (WorldData)CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbt).getOrThrow();
    }

    public class_2487 toNbt() {
        return (class_2487)((class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow()).method_68571().orElseThrow();
    }
}

