/*
 * Decompiled with CFR 0.152.
 */
package com.fibermc.essentialcommands;

import com.fibermc.essentialcommands.WorldDataManager;
import com.fibermc.essentialcommands.commands.suggestions.OfflinePlayerRepo;
import com.fibermc.essentialcommands.playerdata.PlayerDataManager;
import com.fibermc.essentialcommands.teleportation.TeleportManager;
import java.util.HashMap;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.server.MinecraftServer;

public final class ManagerLocator {
    private MinecraftServer server;
    private PlayerDataManager playerDataManager;
    private TeleportManager tpManager;
    private WorldDataManager worldDataManager;
    private OfflinePlayerRepo offlinePlayerRepo;
    private final HashMap<String, Consumer<MinecraftServer>> serverStartActions = new HashMap();
    public static ManagerLocator instance;
    private boolean serverStarted = false;

    private ManagerLocator() {
    }

    public static ManagerLocator getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new ManagerLocator();
        return instance;
    }

    public void init() {
        PlayerDataManager.init();
        TeleportManager.init();
    }

    public void onServerStart(MinecraftServer server) {
        this.server = server;
        this.playerDataManager = PlayerDataManager.getInstance();
        this.tpManager = TeleportManager.getInstance();
        this.worldDataManager = WorldDataManager.createForServer(server);
        this.offlinePlayerRepo = new OfflinePlayerRepo(server);
        ServerLifecycleEvents.SERVER_STARTED.register(server1 -> {
            this.serverStartActions.values().forEach(a -> a.accept(server));
            this.serverStarted = true;
        });
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public TeleportManager getTpManager() {
        return this.tpManager;
    }

    public WorldDataManager getWorldDataManager() {
        return this.worldDataManager;
    }

    public OfflinePlayerRepo getOfflinePlayerRepo() {
        return this.offlinePlayerRepo;
    }

    public void runAndQueue(String key, Consumer<MinecraftServer> action) {
        this.serverStartActions.putIfAbsent(key, action);
        if (this.serverStarted) {
            action.accept(this.server);
        }
    }
}

