/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.entityviewdistance.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import eu.pb4.entityviewdistance.EvdUtils;
import eu.pb4.entityviewdistance.config.ConfigManager;
import eu.pb4.entityviewdistance.config.EvdOverrideSide;
import eu.pb4.entityviewdistance.screen.EvdValueModifierOption;
import eu.pb4.entityviewdistance.screen.SpruceSeparatorWidget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_7172;
import net.minecraft.class_7923;
import net.minecraft.class_7940;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class EvdSettingsScreen
extends class_437 {
    protected final class_437 parent;
    protected final class_315 gameOptions;
    @Nullable
    private EntryListWidget body;

    public EvdSettingsScreen(@Nullable class_437 parent, class_315 options) {
        super((class_2561)class_2561.method_43471((String)"entityviewdistance.menu.title"));
        this.parent = parent;
        this.gameOptions = options;
    }

    protected void method_25426() {
        class_8132 layout = new class_8132((class_437)this);
        this.initHeader(layout);
        this.initBody(layout);
        this.initFooter(layout);
        this.initTabNavigation(layout);
        layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    protected void initHeader(class_8132 layout) {
        layout.method_57726(this.field_22785, this.field_22793);
    }

    protected void initBody(class_8132 layout) {
        this.body = (EntryListWidget)layout.method_48999((class_8021)new EntryListWidget(this.field_22787, this.field_22789, layout.method_57727(), layout.method_48998(), 25));
        this.addOptions();
    }

    protected void initFooter(class_8132 layout) {
        layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(200).method_46431());
    }

    protected void initTabNavigation(class_8132 layout) {
        layout.method_48222();
        if (this.body != null) {
            this.body.method_57712(this.field_22789, layout);
        }
    }

    public void method_25432() {
        this.saveChanges();
    }

    public void method_25419() {
        this.saveChanges();
        this.field_22787.method_1507(this.parent);
    }

    protected void addOptions() {
        assert (this.body != null);
        class_7172 scale = this.gameOptions.method_42517();
        this.body.addEntry(OptionEntry.create((class_339)class_5676.method_32606(value -> EvdUtils.getText("menu.option.toggle", value.displayName)).method_32620(List.of(EvdOverrideSide.values())).method_32618(class_7172.method_42717((class_2561)EvdOverrideSide.TOOLTIP)).method_32619((Object)ConfigManager.getConfig().mode).method_32616().method_32617(0, 0, 150, 20, (class_2561)EvdUtils.getText("menu.option.toggle", new Object[0]), (button, value) -> {
            ConfigManager.getConfig().mode = value;
        }), new class_7172("options.entityDistanceScaling", class_7172.method_42717((class_2561)EvdUtils.getText("menu.option.vanilla_dist.description", new Object[0])), (text, value) -> EvdUtils.getText("menu.option.vanilla_dist", (int)(value * 100.0)), scale.method_41754(), Codec.doubleRange((double)0.5, (double)5.0), (Object)((Double)scale.method_41753()), value -> {}).method_47603(this.gameOptions, 0, 0, 150, x -> this.gameOptions.method_42517().method_41748(x)), this));
        this.body.addEntry(new Separator((class_2561)EvdUtils.getText("menu.separator.entity_options", new Object[0]), this.field_22793));
        this.body.addEntry(new CenteredText((class_2561)EvdUtils.getText("menu.separator.entity_options.description", new Object[0]).method_27692(class_124.field_1080), this.field_22793));
        this.body.addEntry(new Separator(null, this.field_22793));
        ArrayList<EvdValueModifierOption> entries = new ArrayList<EvdValueModifierOption>();
        for (class_1299 class_12992 : class_7923.field_41177) {
            if (class_12992.method_18387() == 0) continue;
            entries.add(new EvdValueModifierOption(class_12992, this.field_22793));
        }
        entries.sort(Comparator.comparing(e -> e.nameString));
        for (EvdValueModifierOption evdValueModifierOption : entries) {
            this.body.addEntry(evdValueModifierOption);
        }
    }

    private void saveChanges() {
        ConfigManager.overrideConfig();
        EvdUtils.updateAll();
        this.gameOptions.method_1640();
        if (this.field_22787.method_1576() != null) {
            this.field_22787.method_1576().execute(() -> EvdUtils.updateServer((MinecraftServer)this.field_22787.method_1576()));
        }
    }

    private static class EntryListWidget
    extends class_4265<Entry> {
        public EntryListWidget(class_310 minecraftClient, int i, int j, int k, int l) {
            super(minecraftClient, i, j, k, l);
        }

        public int addEntry(Entry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        public int method_25322() {
            return 310;
        }
    }

    private static class OptionEntry
    extends Entry {
        private final List<class_339> widgets;
        private final class_437 screen;

        OptionEntry(List<class_339> widgets, class_437 screen) {
            this.widgets = ImmutableList.copyOf(widgets);
            this.screen = screen;
        }

        public static OptionEntry create(class_339 firstWidget, @Nullable class_339 secondWidget, class_437 screen) {
            return secondWidget == null ? new OptionEntry((List<class_339>)ImmutableList.of((Object)firstWidget), screen) : new OptionEntry((List<class_339>)ImmutableList.of((Object)firstWidget, (Object)secondWidget), screen);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int i = 0;
            int j = this.screen.field_22789 / 2 - 155;
            for (class_339 widget : this.widgets) {
                this.setPos((class_8021)widget, j + i, y, entryHeight);
                widget.method_25394(context, mouseX, mouseY, tickDelta);
                i += 160;
            }
        }

        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        public List<? extends class_6379> method_37025() {
            return this.widgets;
        }
    }

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
        protected void setPos(class_8021 label, int x, int y, int height) {
            label.method_48229(x, y + (height - label.method_25364()) / 2);
        }
    }

    public static class Separator
    extends Entry {
        private final SpruceSeparatorWidget separator;

        public Separator(@Nullable class_2561 text, class_327 renderer) {
            this.separator = new SpruceSeparatorWidget(text, renderer);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.setPos((class_8021)this.separator, x, y, entryHeight);
            this.separator.method_25358(entryWidth);
            this.separator.method_25394(context, mouseX, mouseY, tickDelta);
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }
    }

    public static class CenteredText
    extends Entry {
        private final class_7940 label;

        public CenteredText(class_2561 text, class_327 renderer) {
            this.label = new class_7940(text, renderer);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.label.method_48981(true);
            this.setPos((class_8021)this.label, x + (entryWidth - this.label.method_25368()) / 2, y, entryHeight);
            this.label.method_25394(context, mouseX, mouseY, tickDelta);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.label);
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }
    }
}

