/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.specialty;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_10034;
import net.minecraft.class_1792;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public abstract class DyeableGeoArmorRenderer<T extends class_1792, R extends class_10034>
extends GeoArmorRenderer<T, R> {
    protected final Set<GeoBone> dyeableBones = new ReferenceOpenHashSet();
    protected BakedGeoModel lastModel = null;

    public DyeableGeoArmorRenderer(GeoModel<T> model) {
        super(model);
    }

    protected abstract boolean isBoneDyeable(GeoBone var1);

    protected int getColorForBone(R renderState, GeoBone bone, int packedLight, int packedOverlay, int baseColour) {
        return baseColour;
    }

    @Override
    public int getRenderColor(T animatable, GeoArmorRenderer.RenderData stackAndSlot, float partialTick) {
        return -1;
    }

    @Override
    public void preRender(R renderState, class_4587 poseStack, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        super.preRender(renderState, poseStack, model, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        if (!isReRender) {
            this.checkBoneDyeCache((GeoRenderState)renderState, model, packedLight, packedOverlay, renderColor);
        }
    }

    @Override
    public void renderCubesOfBone(R renderState, GeoBone bone, class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int renderColor) {
        if (this.dyeableBones.contains(bone)) {
            renderColor = class_9848.method_61322((int)renderColor, (int)this.getColorForBone(renderState, bone, packedLight, packedOverlay, ((GeoRenderState)renderState).getGeckolibData(DataTickets.RENDER_COLOR)));
        }
        super.renderCubesOfBone(renderState, bone, poseStack, buffer, packedLight, packedOverlay, renderColor);
    }

    protected void checkBoneDyeCache(GeoRenderState renderState, BakedGeoModel model, int packedLight, int packedOverlay, int renderColor) {
        if (model != this.lastModel) {
            this.dyeableBones.clear();
            this.lastModel = model;
            this.collectDyeableBones(model.topLevelBones());
        }
    }

    protected void collectDyeableBones(Collection<GeoBone> bones) {
        for (GeoBone bone : bones) {
            if (this.isBoneDyeable(bone)) {
                this.dyeableBones.add(bone);
            }
            this.collectDyeableBones(bone.getChildBones());
        }
    }
}

