/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.math.value;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToDoubleFunction;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.loading.math.MathValue;

public record Variable(String name, AtomicReference<ToDoubleFunction<AnimationState<?>>> value) implements MathValue
{
    public Variable(String name, double value) {
        this(name, (AnimationState<?> animationState) -> value);
    }

    public Variable(String name, ToDoubleFunction<AnimationState<?>> value) {
        this(name, new AtomicReference(value));
    }

    @Override
    public double get(AnimationState<?> animationState) {
        try {
            return this.value.get().applyAsDouble(animationState);
        }
        catch (Exception ex) {
            GeckoLibConstants.LOGGER.error("Attempted to use Molang variable for incompatible animatable type (" + this.name + "). An animation json needs to be fixed", (Object)ex.getMessage());
            return 0.0;
        }
    }

    public void set(double value) {
        this.value.set(animationState -> value);
    }

    public void set(ToDoubleFunction<AnimationState<?>> value) {
        this.value.set(value);
    }

    @Override
    public Set<Variable> getUsedVariables() {
        return Set.of(this);
    }

    @Override
    public String toString() {
        return "variable(" + this.name + ")";
    }
}

