/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.util;

import com.iamkaf.amber.platform.Services;
import com.iamkaf.amber.util.Env;
import java.util.Optional;
import java.util.function.Supplier;

public final class EnvExecutor {
    private EnvExecutor() {
    }

    public static void runInEnv(Env type, Supplier<Runnable> runnableSupplier) {
        if (Services.PLATFORM.getEnvironment() == type) {
            runnableSupplier.get().run();
        }
    }

    public static <T> Optional<T> getInEnv(Env type, Supplier<Supplier<T>> runnableSupplier) {
        if (Services.PLATFORM.getEnvironment() == type) {
            return Optional.ofNullable(runnableSupplier.get().get());
        }
        return Optional.empty();
    }

    public static <T> T getEnvSpecific(Supplier<Supplier<T>> client, Supplier<Supplier<T>> server) {
        if (Services.PLATFORM.getEnvironment() == Env.CLIENT) {
            return client.get().get();
        }
        return server.get().get();
    }
}

