/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.networking.v1;

import com.iamkaf.amber.Constants;
import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketDecoder;
import com.iamkaf.amber.api.networking.v1.PacketEncoder;
import com.iamkaf.amber.api.networking.v1.PacketHandler;
import com.iamkaf.amber.networking.v1.AmberNetworking;
import com.iamkaf.amber.networking.v1.PongPacket;

public record PingPacket(long timestamp, String message) implements Packet<PingPacket>
{
    public static final PacketEncoder<PingPacket> ENCODER = (packet, buffer) -> {
        buffer.method_10791(packet.timestamp);
        buffer.method_10814(packet.message);
    };
    public static final PacketDecoder<PingPacket> DECODER = buffer -> {
        long timestamp = buffer.method_10792();
        String message = buffer.method_19772();
        return new PingPacket(timestamp, message);
    };
    public static final PacketHandler<PingPacket> HANDLER = (packet, context) -> {
        if (context.isClientSide()) {
            context.execute(() -> {
                Constants.LOG.debug("Amber received ping: {} at {}", (Object)packet.message(), (Object)packet.timestamp());
                long currentTime = System.currentTimeMillis();
                long responseTime = currentTime - packet.timestamp();
                try {
                    PongPacket pongResponse = new PongPacket(packet.timestamp(), currentTime, "Pong: " + packet.message());
                    AmberNetworking.sendToServer(pongResponse);
                    Constants.LOG.debug("Amber sent pong response (response time: {}ms)", (Object)responseTime);
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to send pong response", (Throwable)e);
                }
            });
        } else {
            Constants.LOG.warn("PingPacket received on server side - this should not happen");
        }
    };
}

