/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.amber.api.networking.v1.examples;

import com.iamkaf.amber.Constants;
import com.iamkaf.amber.api.networking.v1.Packet;
import com.iamkaf.amber.api.networking.v1.PacketContext;
import com.iamkaf.amber.api.networking.v1.examples.NetworkingExample;
import com.iamkaf.amber.api.networking.v1.examples.PongPacket;
import net.minecraft.class_2540;

public record PingPacket(long timestamp, String message) implements Packet<PingPacket>
{
    public static void encode(PingPacket packet, class_2540 buffer) {
        buffer.method_10791(packet.timestamp);
        buffer.method_10814(packet.message);
    }

    public static PingPacket decode(class_2540 buffer) {
        long timestamp = buffer.method_10792();
        String message = buffer.method_19772();
        return new PingPacket(timestamp, message);
    }

    public static void handle(PingPacket packet, PacketContext context) {
        if (context.isClientSide()) {
            context.execute(() -> {
                long responseTime = System.currentTimeMillis();
                PongPacket response = new PongPacket(packet.timestamp, responseTime, "Pong: " + packet.message);
                NetworkingExample.CHANNEL.sendToServer(response);
                Constants.LOG.info("Client received ping: {} at {}", (Object)packet.message, (Object)packet.timestamp);
                Constants.LOG.info("Responding with pong after {}ms", (Object)(responseTime - packet.timestamp));
            });
        } else {
            Constants.LOG.error("Server received ping packet - this should not happen!");
        }
    }
}

