/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.armor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_8051;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import reborncore.api.items.ArmorBlockEntityTicker;
import reborncore.api.items.ArmorRemoveHandler;
import reborncore.common.powerSystem.RcEnergyTier;
import techreborn.config.TechRebornConfig;
import techreborn.init.TRItemSettings;
import techreborn.items.armor.AttributeModifierBuilder;
import techreborn.items.armor.TREnergyArmourItem;
import techreborn.utils.TRItemUtils;

public class NanoSuitItem
extends TREnergyArmourItem
implements ArmorBlockEntityTicker,
ArmorRemoveHandler {
    private static final class_9285 FULL_SUIT = new AttributeModifierBuilder().armor(10).toughness(4).build();
    private final class_9285 noPowerAttributes;
    private final class_9285 hasPowerAttributes;
    private final class_9285 fullSuitAttributes;

    public NanoSuitItem(class_1741 material, class_8051 slot, String name) {
        super(material, slot, TechRebornConfig.nanoSuitCapacity, RcEnergyTier.HIGH, name);
        switch (slot) {
            case field_41934: 
            case field_41937: {
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(1).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(3).toughness(2).knockback(1.0).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(5).toughness(3).knockback(1.0).build();
                break;
            }
            case field_41935: {
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(2).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(6).toughness(2).knockback(1.0).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(10).toughness(3).knockback(1.0).build();
                break;
            }
            case field_41936: {
                this.noPowerAttributes = new AttributeModifierBuilder(slot).armor(3).build();
                this.hasPowerAttributes = new AttributeModifierBuilder(slot).armor(8).toughness(2).knockback(1.0).build();
                this.fullSuitAttributes = new AttributeModifierBuilder(slot).armor(10).toughness(3).knockback(1.0).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid slot type");
            }
        }
    }

    public long getEnergyMaxOutput(class_1799 stack) {
        return 0L;
    }

    public void tickArmor(class_1799 stack, boolean hasFullSuit, class_1657 playerEntity) {
        if (this.getSlotType() == class_1304.field_6169) {
            if (TRItemUtils.isActive(stack) && this.tryUseEnergy(stack, TechRebornConfig.suitNightVisionCost)) {
                playerEntity.method_6092(new class_1293(class_1294.field_5925, 220, 1, false, false));
            } else {
                playerEntity.method_6016(class_1294.field_5925);
            }
        }
        this.applyModifier(stack, hasFullSuit);
    }

    public void applyModifier(class_1799 stack, boolean hasFullSuit) {
        class_9285 attributes = (class_9285)stack.method_58694(class_9334.field_49636);
        if (this.getStoredEnergy(stack) > 0L) {
            if (hasFullSuit) {
                if (attributes != this.fullSuitAttributes) {
                    stack.method_57379(class_9334.field_49636, (Object)this.fullSuitAttributes);
                    stack.method_57379(class_9334.field_56400, (Object)AttributeModifierBuilder.ATTRIBUTE_HIDE);
                }
            } else if (attributes != this.hasPowerAttributes) {
                stack.method_57379(class_9334.field_49636, (Object)this.hasPowerAttributes);
                stack.method_57379(class_9334.field_56400, (Object)TRItemSettings.UNBREAKABLE_HIDE);
            }
        } else if (attributes != this.noPowerAttributes) {
            stack.method_57379(class_9334.field_49636, (Object)this.noPowerAttributes);
            stack.method_57379(class_9334.field_56400, (Object)TRItemSettings.UNBREAKABLE_HIDE);
        }
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 thisStack = user.method_5998(hand);
        class_1304 slotType = this.getSlotType();
        if (user.method_5715() && slotType == class_1304.field_6169) {
            TRItemUtils.switchActive(thisStack, 1, (class_1297)user);
            return class_1269.field_5812;
        }
        return super.method_7836(world, user, hand);
    }

    public void onRemoved(class_1657 playerEntity) {
        playerEntity.method_6016(class_1294.field_5925);
        class_1799 stack = playerEntity.field_7498.method_34255();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof NanoSuitItem) {
            NanoSuitItem nanoSuitItem = (NanoSuitItem)class_17922;
            nanoSuitItem.applyModifier(stack, false);
            stack.method_57381(class_9334.field_49628);
        } else {
            playerEntity.method_31548().method_67533().forEach(itemStack -> {
                class_1792 patt0$temp = itemStack.method_7909();
                if (patt0$temp instanceof NanoSuitItem) {
                    NanoSuitItem nanoSuitItem = (NanoSuitItem)patt0$temp;
                    nanoSuitItem.applyModifier((class_1799)itemStack, false);
                    itemStack.method_57381(class_9334.field_49628);
                }
            });
        }
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> tooltip, class_1836 type) {
        if (this.getSlotType() == class_1304.field_6169) {
            TRItemUtils.buildActiveTooltip(stack, tooltip);
        }
    }

    public void appendArmorTooltip(class_1799 stack, List<class_2561> tooltip, boolean shift) {
        ArrayList<class_2561> buffer = new ArrayList<class_2561>();
        class_9285 attributes = (class_9285)stack.method_58694(class_9334.field_49636);
        if (AttributeModifierBuilder.equals(attributes, this.hasPowerAttributes)) {
            if (shift) {
                buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.all_equipment").method_27692(class_124.field_1080));
                AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1078);
            }
        } else if (AttributeModifierBuilder.equals(attributes, this.fullSuitAttributes)) {
            buffer.add(class_5244.field_39003);
            class_1304 slotType = this.getSlotType();
            buffer.add((class_2561)AttributeModifierBuilder.text(slotType).method_27692(class_124.field_1080));
            AttributeModifierBuilder.appendText(buffer, shift ? attributes : this.hasPowerAttributes, class_124.field_1078);
            AttributeModifierBuilder.appendEnchantmentText(buffer, stack, slotType, class_124.field_1078);
            AttributeModifierBuilder.appendArmorEnchantmentText(buffer, stack, class_124.field_1078);
            if (!shift) {
                buffer.add(class_5244.field_39003);
                buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.full_suit").method_27692(class_124.field_1054));
                AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1054);
            }
        } else {
            if (!shift && stack.method_57826(class_9334.field_49628)) {
                return;
            }
            buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.power").method_27692(class_124.field_1080));
            AttributeModifierBuilder.appendDiffText(buffer, this.noPowerAttributes, this.hasPowerAttributes, class_124.field_1078);
            buffer.add((class_2561)class_2561.method_43471((String)"item.modifiers.all_equipment").method_27692(class_124.field_1080));
            AttributeModifierBuilder.appendText(buffer, FULL_SUIT, class_124.field_1078);
        }
        AttributeModifierBuilder.appendEnd(tooltip, buffer);
    }
}

