/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import dev.architectury.event.CompoundEventResult;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.display.ServerDisplayRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.client.entry.ItemEntryDefinition;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.crafting.RecipeManager;
import reborncore.common.fluid.container.ItemFluidInfo;
import techreborn.compat.rei.FluidGeneratorRecipeDisplay;
import techreborn.compat.rei.FluidReplicatorRecipeDisplay;
import techreborn.compat.rei.MachineRecipeDisplay;
import techreborn.compat.rei.RollingMachineDisplay;
import techreborn.init.ModRecipes;
import techreborn.init.TRContent;
import techreborn.recipe.recipes.FluidGeneratorRecipe;

public class ReiCommonPlugin
implements REICommonPlugin {
    public double getPriority() {
        return 1.0;
    }

    public void registerEntryTypes(EntryTypeRegistry registry) {
        registry.register(VanillaEntryTypes.ITEM, (EntryDefinition)new ItemEntryDefinition(this){

            public boolean equals(class_1799 left, class_1799 right, ComparisonContext context) {
                ItemFluidInfo leftInfo;
                class_1792 class_17922;
                block5: {
                    block4: {
                        if (context != ComparisonContext.FUZZY || !((class_17922 = left.method_7909()) instanceof ItemFluidInfo)) break block4;
                        leftInfo = (ItemFluidInfo)class_17922;
                        class_17922 = right.method_7909();
                        if (class_17922 instanceof ItemFluidInfo) break block5;
                    }
                    return super.equals(left, right, context);
                }
                ItemFluidInfo rightInfo = (ItemFluidInfo)class_17922;
                class_3611 leftFluid = leftInfo.getFluid(left);
                if (leftFluid == rightInfo.getFluid(right)) {
                    return leftFluid != class_3612.field_15906 || leftInfo == rightInfo;
                }
                return false;
            }
        });
    }

    public void registerFluidSupport(FluidSupportProvider support) {
        support.register(stack -> {
            ItemFluidInfo fluidInfo;
            class_3611 fluid;
            class_1799 itemStack = (class_1799)stack.getValue();
            class_1792 patt0$temp = itemStack.method_7909();
            if (patt0$temp instanceof ItemFluidInfo && (fluid = (fluidInfo = (ItemFluidInfo)patt0$temp).getFluid(itemStack)) != null) {
                return CompoundEventResult.interruptTrue(Stream.of(EntryStacks.of((class_3611)fluid)));
            }
            return CompoundEventResult.pass();
        });
    }

    public void registerItemComparators(ItemComparatorRegistry registry) {
        registry.registerComponents((class_1792)TRContent.CELL);
    }

    public void registerDisplays(ServerDisplayRegistry registry) {
        Map<class_3956<FluidGeneratorRecipe>, TRContent.Machine> fluidGenRecipes = Map.of(ModRecipes.THERMAL_GENERATOR, TRContent.Machine.THERMAL_GENERATOR, ModRecipes.GAS_GENERATOR, TRContent.Machine.GAS_TURBINE, ModRecipes.DIESEL_GENERATOR, TRContent.Machine.DIESEL_GENERATOR, ModRecipes.SEMI_FLUID_GENERATOR, TRContent.Machine.SEMI_FLUID_GENERATOR, ModRecipes.PLASMA_GENERATOR, TRContent.Machine.PLASMA_GENERATOR);
        RecipeManager.getRecipeTypes((String)"techreborn").stream().filter(recipeType -> !fluidGenRecipes.containsKey(recipeType)).forEach(rebornRecipeType -> this.registerMachineRecipe(registry, (class_3956<?>)rebornRecipeType));
        fluidGenRecipes.forEach((recipeType, machine) -> this.registerFluidGeneratorDisplays(registry, (class_3956<FluidGeneratorRecipe>)recipeType, (TRContent.Machine)machine));
    }

    private void registerFluidGeneratorDisplays(ServerDisplayRegistry registry, class_3956<FluidGeneratorRecipe> generator, TRContent.Machine machine) {
        class_2960 identifier = class_2960.method_60655((String)"techreborn", (String)machine.name);
        registry.beginRecipeFiller(FluidGeneratorRecipe.class).filterType(generator).fill(recipe -> new FluidGeneratorRecipeDisplay((FluidGeneratorRecipe)recipe.comp_1933(), identifier));
    }

    private void registerMachineRecipe(ServerDisplayRegistry registry, class_3956<?> recipeType) {
        if (recipeType == ModRecipes.RECYCLER) {
            return;
        }
        Function<class_8786, Display> recipeDisplay = MachineRecipeDisplay::new;
        if (recipeType == ModRecipes.ROLLING_MACHINE) {
            recipeDisplay = RollingMachineDisplay::new;
        }
        if (recipeType == ModRecipes.FLUID_REPLICATOR) {
            recipeDisplay = FluidReplicatorRecipeDisplay::new;
        }
        registry.beginRecipeFiller(RebornRecipe.class).filter(recipeEntry -> ((RebornRecipe)recipeEntry.comp_1933()).method_17716() == recipeType).fill(recipeDisplay);
    }

    public void registerDisplaySerializer(DisplaySerializerRegistry registry) {
        registry.register(class_2960.method_60655((String)"techreborn", (String)"machine"), MachineRecipeDisplay.SERIALIZER);
        registry.register(class_2960.method_60655((String)"techreborn", (String)"rolling_machine"), RollingMachineDisplay.SERIALIZER);
        registry.register(class_2960.method_60655((String)"techreborn", (String)"fluid_generator"), FluidGeneratorRecipeDisplay.SERIALIZER);
        registry.register(class_2960.method_60655((String)"techreborn", (String)"fluid_replicator"), FluidReplicatorRecipeDisplay.SERIALIZER);
    }
}

