/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_746;
import net.minecraft.class_8666;
import net.minecraft.class_8710;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.GuiBuilder;
import reborncore.common.screen.BuiltScreenHandler;
import techreborn.blockentity.machine.iron.IronFurnaceBlockEntity;
import techreborn.packets.serverbound.ExperiencePayload;
import techreborn.utils.PlayerUtils;

@Environment(value=EnvType.CLIENT)
public class GuiIronFurnace
extends GuiBase<BuiltScreenHandler> {
    final IronFurnaceBlockEntity blockEntity;
    private static final class_2960 EXP_BUTTON_TEXTURE = class_2960.method_60656((String)"item/experience_bottle");

    public GuiIronFurnace(int syncID, class_1657 player, IronFurnaceBlockEntity furnace) {
        super(player, (class_2586)furnace, (class_1703)furnace.createScreenHandler(syncID, player));
        this.blockEntity = furnace;
    }

    public void onClick(class_4185 buttonWidget) {
        ClientPlayNetworking.send((class_8710)new ExperiencePayload(this.blockEntity.method_11016()));
    }

    public void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new XpButtonWidget(this::onClick));
    }

    protected void method_2389(class_332 drawContext, float lastFrameDuration, int mouseX, int mouseY) {
        super.method_2389(drawContext, lastFrameDuration, mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;
        this.drawSlot(drawContext, 56, 17, layer);
        this.drawSlot(drawContext, 56, 53, layer);
        this.drawOutputSlot(drawContext, 116, 35, layer);
    }

    protected void method_2388(class_332 drawContext, int mouseX, int mouseY) {
        super.method_2388(drawContext, mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;
        this.builder.drawProgressBar(drawContext, (GuiBase)this, this.blockEntity.getProgressScaled(100), 100, 85, 36, mouseX, mouseY, GuiBuilder.ProgressDirection.RIGHT, layer);
        this.builder.drawBurnBar(drawContext, (GuiBase)this, this.blockEntity.getBurnTimeRemainingScaled(100), 100, 56, 36, mouseX, mouseY, layer);
    }

    @Environment(value=EnvType.CLIENT)
    private class XpButtonWidget
    extends class_344 {
        private static final class_8666 TEXTURES = new class_8666(EXP_BUTTON_TEXTURE, EXP_BUTTON_TEXTURE);

        public XpButtonWidget(class_4185.class_4241 pressAction) {
            super(GuiIronFurnace.this.getGuiLeft() + 116, GuiIronFurnace.this.getGuiTop() + 58, 16, 16, TEXTURES, pressAction, (class_2561)class_2561.method_43473());
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            if (this.field_22762) {
                context.method_51438(GuiIronFurnace.this.method_64506(), this.getTooltipText(), mouseX, mouseY);
            }
        }

        private class_2561 getTooltipText() {
            class_746 player = class_310.method_1551().field_1724;
            Objects.requireNonNull(player);
            Object message = ": ";
            float furnaceExp = GuiIronFurnace.this.blockEntity.experience;
            if (furnaceExp <= 0.0f) {
                message = (String)message + "0";
            } else {
                float expTillLevel = (1.0f - player.field_7510) * (float)player.method_7349();
                if (furnaceExp <= expTillLevel) {
                    int percentage = (int)(GuiIronFurnace.this.blockEntity.experience * 100.0f / (float)player.method_7349());
                    message = (String)message + "+" + (percentage > 0 ? String.valueOf(percentage) : "<1") + "%";
                } else {
                    int levels = 0;
                    furnaceExp -= expTillLevel;
                    while (furnaceExp > 0.0f) {
                        furnaceExp -= (float)PlayerUtils.getLevelExperience(player.field_7520);
                        ++levels;
                    }
                    message = (String)message + "+" + levels + "L";
                }
            }
            return class_2561.method_43471((String)"techreborn.tooltip.experience").method_27693((String)message);
        }
    }
}

