/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.util;

import java.util.function.Consumer;
import net.frozenblock.wilderwild.block.IcicleBlock;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5689;
import net.minecraft.class_5691;
import net.minecraft.class_5726;
import org.jetbrains.annotations.NotNull;

public class IcicleUtils {
    public static boolean isEmptyOrWater(@NotNull class_1936 levelAccessor, class_2338 blockPos) {
        return levelAccessor.method_16358(blockPos, class_5726::method_33014);
    }

    public static void buildBaseToTipColumn(class_2350 direction, int length, boolean merge, Consumer<class_2680> consumer) {
        if (length >= 3) {
            consumer.accept(IcicleUtils.createIcicle(direction, class_5691.field_28068));
            for (int j = 0; j < length - 3; ++j) {
                consumer.accept(IcicleUtils.createIcicle(direction, class_5691.field_28067));
            }
        }
        if (length >= 2) {
            consumer.accept(IcicleUtils.createIcicle(direction, class_5691.field_28066));
        }
        if (length >= 1) {
            consumer.accept(IcicleUtils.createIcicle(direction, merge ? class_5691.field_28064 : class_5691.field_28065));
        }
    }

    public static boolean growIcicle(@NotNull class_1936 levelAccessor, @NotNull class_2338 blockPos, @NotNull class_2350 direction, int i, boolean merge) {
        if (IcicleUtils.isIcicleBase(levelAccessor.method_8320(blockPos.method_10093(direction.method_10153())))) {
            class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
            IcicleUtils.buildBaseToTipColumn(direction, i, merge, blockState -> {
                if (blockState.method_27852((class_2248)WWBlocks.ICICLE)) {
                    blockState = (class_2680)blockState.method_11657((class_2769)IcicleBlock.WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.method_22351((class_2338)mutableBlockPos)));
                }
                levelAccessor.method_8652((class_2338)mutableBlockPos, blockState, 2);
                mutableBlockPos.method_10098(direction);
            });
            return true;
        }
        return false;
    }

    public static boolean placeIceBlockIfPossible(@NotNull class_1936 levelAccessor, class_2338 blockPos) {
        class_2680 blockState = levelAccessor.method_8320(blockPos);
        if (blockState.method_26164(WWBlockTags.CAVE_FRAGILE_ICE_REPLACEABLE)) {
            levelAccessor.method_8652(blockPos, WWBlocks.FRAGILE_ICE.method_9564(), 2);
            return true;
        }
        return false;
    }

    @NotNull
    private static class_2680 createIcicle(class_2350 direction, class_5691 icicleThickness) {
        return (class_2680)((class_2680)WWBlocks.ICICLE.method_9564().method_11657((class_2769)class_5689.field_28050, (Comparable)direction)).method_11657((class_2769)class_5689.field_28051, (Comparable)icicleThickness);
    }

    public static boolean isIcicleBase(@NotNull class_2680 blockState) {
        return blockState.method_26164(WWBlockTags.ICICLE_GROWS_WHEN_UNDER) || blockState.method_26164(class_3481.field_15467) || blockState.method_26164(WWBlockTags.CAVE_ICE_REPLACEABLE);
    }

    public static boolean growIcicleOnRandomTick(@NotNull class_3218 serverLevel, @NotNull class_2338 blockPos) {
        class_2338 belowPos = blockPos.method_10074();
        class_2680 belowState = serverLevel.method_8320(belowPos);
        if (belowState.method_26215()) {
            return IcicleUtils.growIcicle((class_1936)serverLevel, belowPos, class_2350.field_11033, 1, false);
        }
        return false;
    }

    public static boolean spreadIcicleOnRandomTick(@NotNull class_3218 serverLevel, @NotNull class_2338 blockPos) {
        class_2680 blockState = serverLevel.method_8320(blockPos);
        if (IcicleBlock.canSpreadTo(blockState)) {
            return IcicleUtils.growIcicleOnRandomTick(serverLevel, blockPos);
        }
        return false;
    }
}

