/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.worldgen.impl.treedecorators.WWTreeDecorators;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4662;
import net.minecraft.class_4663;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class PollenTreeDecorator
extends class_4662 {
    public static final MapCodec<PollenTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(treeDecorator -> Float.valueOf(treeDecorator.probability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("placement_chance").forGetter(treeDecorator -> Float.valueOf(treeDecorator.placementChance)), (App)Codec.INT.fieldOf("max_count").forGetter(treeDecorator -> treeDecorator.maxCount)).apply((Applicative)instance, PollenTreeDecorator::new));
    private final float probability;
    private final float placementChance;
    private final int maxCount;

    public PollenTreeDecorator(float probability, float placementChance, int maxCount) {
        this.probability = probability;
        this.placementChance = placementChance;
        this.maxCount = maxCount;
    }

    @NotNull
    protected class_4663<?> method_28893() {
        return WWTreeDecorators.POLLEN_TREE_DECORATOR;
    }

    public void method_23469(@NotNull class_4662.class_7402 context) {
        if (!WWWorldgenConfig.GENERATE_POLLEN) {
            return;
        }
        class_5819 random = context.method_43320();
        if (random.method_43057() > this.probability) {
            return;
        }
        ObjectArrayList poses = new ObjectArrayList((ObjectList)context.method_43321());
        poses.addAll((ObjectList)context.method_43322());
        class_156.method_43028((List)poses, (class_5819)random);
        class_2680 pollenState = WWBlocks.POLLEN.method_9564();
        int placedPollen = 0;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (class_2338 pos : poses) {
            if (placedPollen >= this.maxCount) {
                return;
            }
            for (class_2350 direction : class_2350.values()) {
                if (random.method_43057() > this.placementChance || !context.method_43317((class_2338)mutableBlockPos.method_25505((class_2382)pos, direction))) continue;
                context.method_43318((class_2338)mutableBlockPos, (class_2680)pollenState.method_11657((class_2769)class_5778.method_33374((class_2350)direction.method_10153()), (Comparable)Boolean.valueOf(true)));
                ++placedPollen;
            }
        }
    }
}

