/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.datafix.wilderwild.datafixers;

import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.frozenblock.wilderwild.WWConstants;
import net.minecraft.class_1208;
import net.minecraft.class_1220;
import org.jetbrains.annotations.NotNull;

public final class FireflyBottleComponentizationFix
extends DataFix {
    private static final Map<String, String> FIREFLY_BOTTLE_TO_COMPONENT = ImmutableBiMap.builder().put((Object)WWConstants.string("firefly_bottle"), (Object)WWConstants.string("on")).put((Object)WWConstants.string("black_firefly_bottle"), (Object)WWConstants.string("black")).put((Object)WWConstants.string("blue_firefly_bottle"), (Object)WWConstants.string("blue")).put((Object)WWConstants.string("brown_firefly_bottle"), (Object)WWConstants.string("brown")).put((Object)WWConstants.string("cyan_firefly_bottle"), (Object)WWConstants.string("cyan")).put((Object)WWConstants.string("gray_firefly_bottle"), (Object)WWConstants.string("gray")).put((Object)WWConstants.string("green_firefly_bottle"), (Object)WWConstants.string("green")).put((Object)WWConstants.string("light_blue_firefly_bottle"), (Object)WWConstants.string("light_blue")).put((Object)WWConstants.string("light_gray_firefly_bottle"), (Object)WWConstants.string("light_gray")).put((Object)WWConstants.string("lime_firefly_bottle"), (Object)WWConstants.string("lime")).put((Object)WWConstants.string("magenta_firefly_bottle"), (Object)WWConstants.string("magenta")).put((Object)WWConstants.string("orange_firefly_bottle"), (Object)WWConstants.string("orange")).put((Object)WWConstants.string("pink_firefly_bottle"), (Object)WWConstants.string("pink")).put((Object)WWConstants.string("purple_firefly_bottle"), (Object)WWConstants.string("purple")).put((Object)WWConstants.string("red_firefly_bottle"), (Object)WWConstants.string("red")).put((Object)WWConstants.string("white_firefly_bottle"), (Object)WWConstants.string("white")).put((Object)WWConstants.string("yellow_firefly_bottle"), (Object)WWConstants.string("yellow")).build();

    public FireflyBottleComponentizationFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    private static Dynamic<?> fixItemStack(@NotNull Dynamic<?> dynamic, String fireflyColor) {
        return dynamic.set("components", dynamic.emptyMap().set(WWConstants.string("bottle_entity_data"), dynamic.emptyMap().set("FireflyBottleVariantTag", dynamic.createString(fireflyColor))));
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(class_1208.field_5712);
        return this.fixTypeEverywhereTyped("Firefly Bottle ItemStack componentization fix", type, FireflyBottleComponentizationFix.createFixer(type));
    }

    @NotNull
    private static UnaryOperator<Typed<?>> createFixer(@NotNull Type<?> type) {
        OpticFinder idFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)class_1208.field_5713.typeName(), (Type)class_1220.method_28295()));
        return typed -> {
            String id;
            String componentName;
            Optional possibleId = typed.getOptional(idFinder);
            if (possibleId.isPresent() && (componentName = FIREFLY_BOTTLE_TO_COMPONENT.get(id = (String)((Pair)possibleId.get()).getSecond())) != null) {
                return typed.update(DSL.remainderFinder(), dynamic -> FireflyBottleComponentizationFix.fixItemStack(dynamic, componentName));
            }
            return typed;
        };
    }
}

