/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.datafix.wilderwild;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.datafix.wilderwild.datafixers.DrySandStateFix;
import net.frozenblock.wilderwild.datafix.wilderwild.datafixers.FireflyBottleComponentizationFix;
import net.frozenblock.wilderwild.datafix.wilderwild.datafixers.NematocystStateFix;
import net.frozenblock.wilderwild.datafix.wilderwild.datafixers.OsseousSculkStateFix;
import net.frozenblock.wilderwild.datafix.wilderwild.datafixers.ScorchedSandStateFix2;
import net.minecraft.class_1220;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.QuiltDataFixerBuilder;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.QuiltDataFixes;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.SimpleFixes;

public final class WWDataFixer {
    public static final int DATA_VERSION = 28;

    private WWDataFixer() {
        throw new UnsupportedOperationException("WWDataFixer contains only static declarations.");
    }

    public static void applyDataFixes(@NotNull ModContainer mod) {
        WWConstants.log("Applying DataFixes for Wilder Wild with Data Version 28", true);
        QuiltDataFixerBuilder builder = new QuiltDataFixerBuilder(28);
        builder.addSchema(0, QuiltDataFixes.BASE_SCHEMA);
        Schema schemaV1 = builder.addSchema(1, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename white_dandelion to blooming_dandelion", (class_2960)WWConstants.id("white_dandelion"), (class_2960)WWConstants.id("blooming_dandelion"), (Schema)schemaV1);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename potted_white_dandelion to potted_blooming_dandelion", (class_2960)WWConstants.id("potted_white_dandelion"), (class_2960)WWConstants.id("potted_blooming_dandelion"), (Schema)schemaV1);
        Schema schemaV2 = builder.addSchema(2, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename blooming_dandelion to seeding_dandelion", (class_2960)WWConstants.id("blooming_dandelion"), (class_2960)WWConstants.id("seeding_dandelion"), (Schema)schemaV2);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename potted_blooming_dandelion to potted_seeding_dandelion", (class_2960)WWConstants.id("potted_blooming_dandelion"), (class_2960)WWConstants.id("potted_seeding_dandelion"), (Schema)schemaV2);
        Schema schemaV3 = builder.addSchema(3, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename floating_moss to algae", (class_2960)WWConstants.id("floating_moss"), (class_2960)WWConstants.id("algae"), (Schema)schemaV3);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename floating_moss to algae", (class_2960)WWConstants.id("floating_moss"), (class_2960)WWConstants.id("algae"), (Schema)schemaV3);
        Schema schemaV4 = builder.addSchema(4, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename test_1 to null_block", (class_2960)WWConstants.id("test_1"), (class_2960)WWConstants.id("null_block"), (Schema)schemaV4);
        Schema schemaV5 = builder.addSchema(5, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename sculk_echoer to null_block", (class_2960)WWConstants.id("sculk_echoer"), (class_2960)WWConstants.id("null_block"), (Schema)schemaV5);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename sculk_jaw to null_block", (class_2960)WWConstants.id("sculk_jaw"), (class_2960)WWConstants.id("null_block"), (Schema)schemaV5);
        Schema schemaV6 = builder.addSchema(6, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename baobab_sapling to baobab_nut", (class_2960)WWConstants.id("baobab_sapling"), (class_2960)WWConstants.id("baobab_nut"), (Schema)schemaV6);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename baobab_nut_sapling to baobab_nut", (class_2960)WWConstants.id("baobab_nut_sapling"), (class_2960)WWConstants.id("baobab_nut"), (Schema)schemaV6);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename potted_baobab_sapling to potted_baobab_nut", (class_2960)WWConstants.id("potted_baobab_sapling"), (class_2960)WWConstants.id("potted_baobab_nut"), (Schema)schemaV6);
        Schema schemaV7 = builder.addSchema(7, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename firefly_lantern to display_lantern", (class_2960)WWConstants.id("firefly_lantern"), (class_2960)WWConstants.id("display_lantern"), (Schema)schemaV7);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename mesoglea to blue_pearlescent_mesoglea", (class_2960)WWConstants.id("mesoglea"), (class_2960)WWConstants.id("blue_pearlescent_mesoglea"), (Schema)schemaV7);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename mesoglea to blue_pearlescent_mesoglea", (class_2960)WWConstants.id("mesoglea"), (class_2960)WWConstants.id("blue_pearlescent_mesoglea"), (Schema)schemaV7);
        Schema schemaV8 = builder.addSchema(8, class_1220::new);
        SimpleFixes.addBlockStateRenameFix((DataFixerBuilder)builder, (String)"display_lantern_rename_fix", (class_2960)WWConstants.id("display_lantern"), (String)"light", (String)"0", (String)"display_light", (Schema)schemaV8);
        Schema schemaV9 = builder.addSchema(9, class_1220::new);
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "blue_nematocyst_fix", WWConstants.id("blue_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "blue_pearlescent_nematocyst_fix", WWConstants.id("blue_pearlescent_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "lime_nematocyst_fix", WWConstants.id("lime_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "pink_nematocyst_fix", WWConstants.id("pink_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "purple_pearlescent_nematocyst_fix", WWConstants.id("purple_pearlescent_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "red_nematocyst_fix", WWConstants.id("red_nematocyst")));
        builder.addFixer((DataFix)new NematocystStateFix(schemaV9, "yellow_nematocyst_fix", WWConstants.id("yellow_nematocyst")));
        Schema schemaV10 = builder.addSchema(10, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename palm_sapling to coconut", (class_2960)WWConstants.id("palm_sapling"), (class_2960)WWConstants.id("coconut"), (Schema)schemaV10);
        Schema schemaV11 = builder.addSchema(11, class_1220::new);
        builder.addFixer((DataFix)new DrySandStateFix(schemaV11, "dry_sand_crackness_to_crackedness", WWConstants.id("dry_sand")));
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename dry_sand to scorched_sand", (class_2960)WWConstants.id("dry_sand"), (class_2960)WWConstants.id("scorched_sand"), (Schema)schemaV11);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename dry_sand to scorched_sand", (class_2960)WWConstants.id("dry_sand"), (class_2960)WWConstants.id("scorched_sand"), (Schema)schemaV11);
        builder.addFixer((DataFix)new DrySandStateFix(schemaV11, "scorched_sand_crackness_to_crackedness", WWConstants.id("scorched_sand")));
        Schema schemaV13 = builder.addSchema(13, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename palm_leaves to palm_fronds", (class_2960)WWConstants.id("palm_leaves"), (class_2960)WWConstants.id("palm_fronds"), (Schema)schemaV13);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename palm_leaves to palm_fronds", (class_2960)WWConstants.id("palm_leaves"), (class_2960)WWConstants.id("palm_fronds"), (Schema)schemaV13);
        Schema schemaV14 = builder.addSchema(14, class_1220::new);
        builder.addFixer((DataFix)new ScorchedSandStateFix2(schemaV14, "scorched_sand_integer_to_boolean", WWConstants.id("scorched_sand")));
        builder.addFixer((DataFix)new ScorchedSandStateFix2(schemaV14, "scorched_red_sand_integer_to_boolean", WWConstants.id("scorched_red_sand")));
        Schema schemaV15 = builder.addSchema(15, class_1220::new);
        builder.addFixer((DataFix)new OsseousSculkStateFix(schemaV15, "osseous_sculk_axis_to_direction", WWConstants.id("osseous_sculk")));
        Schema schemaV16 = builder.addSchema(16, class_1220::new);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Replace wilderwild:music_disc_back with minecraft:music_disc_5", (class_2960)WWConstants.id("music_disc_back"), (class_2960)WWConstants.vanillaId("music_disc_5"), (Schema)schemaV16);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Replace wilderwild:music_disc_goathorn_symphony with minecraft:music_disc_otherside", (class_2960)WWConstants.id("music_disc_goathorn_symphony"), (class_2960)WWConstants.vanillaId("music_disc_otherside"), (Schema)schemaV16);
        Schema schemaV17 = builder.addSchema(17, class_1220::new);
        SimpleFixes.addBiomeRenameFix((DataFixerBuilder)builder, (String)"Rename wilderwild:magma_caves to wilderwild:magmatic_caves", Map.of(WWConstants.id("magma_caves"), WWConstants.id("magmatic_caves")), (Schema)schemaV17);
        Schema schemaV18 = builder.addSchema(18, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename palm_crown to palm_log", (class_2960)WWConstants.id("palm_crown"), (class_2960)WWConstants.id("palm_log"), (Schema)schemaV18);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename palm_crown to palm_log", (class_2960)WWConstants.id("palm_crown"), (class_2960)WWConstants.id("palm_log"), (Schema)schemaV18);
        Schema schemaV19 = builder.addSchema(19, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename small_sponge to sponge_bud", (class_2960)WWConstants.id("small_sponge"), (class_2960)WWConstants.id("sponge_bud"), (Schema)schemaV19);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename small_sponge to sponge_bud", (class_2960)WWConstants.id("small_sponge"), (class_2960)WWConstants.id("sponge_bud"), (Schema)schemaV19);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename ancient_horn to echo_glass", (class_2960)WWConstants.id("ancient_horn"), (class_2960)WWConstants.id("echo_glass"), (Schema)schemaV19);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename ancient_horn_fragment to echo_glass", (class_2960)WWConstants.id("ancient_horn_fragment"), (class_2960)WWConstants.id("echo_glass"), (Schema)schemaV19);
        Schema schemaV20 = builder.addSchema(20, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename brown_shelf_fungus to brown_shelf_fungi", (class_2960)WWConstants.id("brown_shelf_fungus"), (class_2960)WWConstants.id("brown_shelf_fungi"), (Schema)schemaV20);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename brown_shelf_fungus to brown_shelf_fungi", (class_2960)WWConstants.id("brown_shelf_fungus"), (class_2960)WWConstants.id("brown_shelf_fungi"), (Schema)schemaV20);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename red_shelf_fungus to red_shelf_fungi", (class_2960)WWConstants.id("red_shelf_fungus"), (class_2960)WWConstants.id("red_shelf_fungi"), (Schema)schemaV20);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename red_shelf_fungus to red_shelf_fungi", (class_2960)WWConstants.id("red_shelf_fungus"), (class_2960)WWConstants.id("red_shelf_fungi"), (Schema)schemaV20);
        Schema schemaV21 = builder.addSchema(21, class_1220::new);
        SimpleFixes.addBiomeRenameFix((DataFixerBuilder)builder, (String)"Rename jellyfish_caves to mesoglea_caves", Map.of(WWConstants.id("jellyfish_caves"), WWConstants.id("mesoglea_caves")), (Schema)schemaV21);
        Schema schemaV22 = builder.addSchema(22, class_1220::new);
        SimpleFixes.addBiomeRenameFix((DataFixerBuilder)builder, (String)"Rename maple_grove to maple_forest", Map.of(WWConstants.id("maple_grove"), WWConstants.id("maple_forest")), (Schema)schemaV22);
        Schema schemaV23 = builder.addSchema(23, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename alba_glory_of_the_snow to white_glory_of_the_snow_petals", (class_2960)WWConstants.id("alba_glory_of_the_snow"), (class_2960)WWConstants.id("white_glory_of_the_snow_petals"), (Schema)schemaV23);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename alba_glory_of_the_snow to white_glory_of_the_snow_petals", (class_2960)WWConstants.id("alba_glory_of_the_snow"), (class_2960)WWConstants.id("white_glory_of_the_snow_petals"), (Schema)schemaV23);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename blue_giant_glory_of_the_snow to blue_glory_of_the_snow_petals", (class_2960)WWConstants.id("blue_giant_glory_of_the_snow"), (class_2960)WWConstants.id("blue_glory_of_the_snow_petals"), (Schema)schemaV23);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename blue_giant_glory_of_the_snow to blue_glory_of_the_snow_petals", (class_2960)WWConstants.id("blue_giant_glory_of_the_snow"), (class_2960)WWConstants.id("blue_glory_of_the_snow_petals"), (Schema)schemaV23);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename pink_giant_glory_of_the_snow to pink_glory_of_the_snow_petals", (class_2960)WWConstants.id("pink_giant_glory_of_the_snow"), (class_2960)WWConstants.id("pink_glory_of_the_snow_petals"), (Schema)schemaV23);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename pink_giant_glory_of_the_snow to pink_glory_of_the_snow_petals", (class_2960)WWConstants.id("pink_giant_glory_of_the_snow"), (class_2960)WWConstants.id("pink_glory_of_the_snow_petals"), (Schema)schemaV23);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename violet_beauty_glory_of_the_snow to purple_glory_of_the_snow_petals", (class_2960)WWConstants.id("violet_beauty_glory_of_the_snow"), (class_2960)WWConstants.id("purple_glory_of_the_snow_petals"), (Schema)schemaV23);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename violet_beauty_glory_of_the_snow to purple_glory_of_the_snow_petals", (class_2960)WWConstants.id("violet_beauty_glory_of_the_snow"), (class_2960)WWConstants.id("purple_glory_of_the_snow_petals"), (Schema)schemaV23);
        Schema schemaV24 = builder.addSchema(24, class_1220::new);
        builder.addFixer((DataFix)new FireflyBottleComponentizationFix(schemaV24));
        Schema schemaV25 = builder.addSchema(25, class_1220::new);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename black_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("black_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename blue_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("blue_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename brown_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("brown_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV24);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename cyan_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("cyan_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename gray_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("gray_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename green_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("green_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename light_blue_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("light_blue_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename light_gray_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("light_gray_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename lime_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("lime_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename magenta_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("magenta_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename orange_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("orange_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename pink_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("pink_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename purple_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("purple_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename red_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("red_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename white_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("white_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename yellow_firefly_bottle to firefly_bottle", (class_2960)WWConstants.id("yellow_firefly_bottle"), (class_2960)WWConstants.id("firefly_bottle"), (Schema)schemaV25);
        Schema schemaV26 = builder.addSchema(26, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename white_glory_of_the_snow_petals to pollen", (class_2960)WWConstants.id("white_glory_of_the_snow_petals"), (class_2960)WWConstants.id("pollen"), (Schema)schemaV26);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename white_glory_of_the_snow_petals to pollen", (class_2960)WWConstants.id("white_glory_of_the_snow_petals"), (class_2960)WWConstants.id("pollen"), (Schema)schemaV26);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename blue_glory_of_the_snow_petals to pollen", (class_2960)WWConstants.id("blue_glory_of_the_snow_petals"), (class_2960)WWConstants.id("pollen"), (Schema)schemaV26);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename blue_glory_of_the_snow_petals to pollen", (class_2960)WWConstants.id("blue_glory_of_the_snow_petals"), (class_2960)WWConstants.id("pollen"), (Schema)schemaV26);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename pink_glory_of_the_snow_petals to pollen", (class_2960)WWConstants.id("pink_glory_of_the_snow_petals"), (class_2960)WWConstants.id("pollen"), (Schema)schemaV26);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename pink_glory_of_the_snow_petals to pollen", (class_2960)WWConstants.id("pink_glory_of_the_snow_petals"), (class_2960)WWConstants.id("pollen"), (Schema)schemaV26);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename purple_glory_of_the_snow_petals to pollen", (class_2960)WWConstants.id("purple_glory_of_the_snow_petals"), (class_2960)WWConstants.id("pollen"), (Schema)schemaV26);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename purple_glory_of_the_snow_petals to pollen", (class_2960)WWConstants.id("purple_glory_of_the_snow_petals"), (class_2960)WWConstants.id("pollen"), (Schema)schemaV26);
        SimpleFixes.addRandomBlockRenameFix((DataFixerBuilder)builder, (String)"Random datafix of glory_of_the_snow to Hibiscus variants", (class_2960)WWConstants.id("glory_of_the_snow"), (List)ImmutableList.of((Object)WWConstants.id("red_hibiscus"), (Object)WWConstants.id("yellow_hibiscus"), (Object)WWConstants.id("white_hibiscus"), (Object)WWConstants.id("pink_hibiscus"), (Object)WWConstants.id("purple_hibiscus")), (Schema)schemaV26);
        SimpleFixes.addRandomItemRenameFix((DataFixerBuilder)builder, (String)"Random datafix of glory_of_the_snow to Hibiscus variants", (class_2960)WWConstants.id("glory_of_the_snow"), (List)ImmutableList.of((Object)WWConstants.id("red_hibiscus"), (Object)WWConstants.id("yellow_hibiscus"), (Object)WWConstants.id("white_hibiscus"), (Object)WWConstants.id("pink_hibiscus"), (Object)WWConstants.id("purple_hibiscus")), (Schema)schemaV26);
        Schema schemaV27 = builder.addSchema(27, class_1220::new);
        SimpleFixes.addBiomeRenameFix((DataFixerBuilder)builder, (String)"Rename tundra to autumnal_plains", Map.of(WWConstants.id("tundra"), WWConstants.id("autumnal_plains")), (Schema)schemaV27);
        Schema schemaV28 = builder.addSchema(28, class_1220::new);
        SimpleFixes.addBiomeRenameFix((DataFixerBuilder)builder, (String)"Rename autumnal_plains to tundra", Map.of(WWConstants.id("autumnal_plains"), WWConstants.id("tundra")), (Schema)schemaV28);
        QuiltDataFixes.buildAndRegisterFixer((ModContainer)mod, (QuiltDataFixerBuilder)builder);
        WWConstants.log("DataFixes for Wilder Wild have been applied", true);
    }
}

