/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.frozenblock.wilderwild.block.entity.StoneChestBlockEntity;
import net.frozenblock.wilderwild.block.entity.impl.ChestBlockEntityInterface;
import net.frozenblock.wilderwild.block.impl.ChestUtil;
import net.frozenblock.wilderwild.entity.Jellyfish;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.minecraft.class_10225;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4838;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneChestBlock
extends class_2281 {
    public static final MapCodec<StoneChestBlock> CODEC = StoneChestBlock.method_54094(properties -> new StoneChestBlock(() -> WWBlockEntityTypes.STONE_CHEST, (class_4970.class_2251)properties));
    public static final float MIN_OPENABLE_PROGRESS = 0.3f;
    public static final float MAX_OPENABLE_PROGRESS = 0.5f;
    public static final float LIFT_AMOUNT = 0.025f;
    public static final float MAX_LIFT_AMOUNT_UNDER_SOLID_BLOCK = 0.05f;
    public static final class_2746 SCULK = WWBlockStateProperties.HAS_SCULK;
    public static final class_4732.class_3923<class_2595, Optional<class_3908>> STONE_NAME_RETRIEVER = new class_4732.class_3923<class_2595, Optional<class_3908>>(){

        @NotNull
        public Optional<class_3908> acceptDouble(final @NotNull class_2595 chestBlockEntity, final @NotNull class_2595 chestBlockEntity2) {
            final class_1258 inventory = new class_1258((class_1263)chestBlockEntity, (class_1263)chestBlockEntity2);
            return Optional.of(new class_3908(){

                @Nullable
                public class_1703 createMenu(int i, @NotNull class_1661 playerInventory, @NotNull class_1657 playerEntity) {
                    if (chestBlockEntity.method_17489(playerEntity) && chestBlockEntity2.method_17489(playerEntity)) {
                        chestBlockEntity.method_54873(playerInventory.field_7546);
                        chestBlockEntity2.method_54873(playerInventory.field_7546);
                        return class_1707.method_19247((int)i, (class_1661)playerInventory, (class_1263)inventory);
                    }
                    return null;
                }

                @NotNull
                public class_2561 method_5476() {
                    if (chestBlockEntity.method_16914()) {
                        return chestBlockEntity.method_5476();
                    }
                    if (chestBlockEntity2.method_16914()) {
                        return chestBlockEntity2.method_5476();
                    }
                    return class_2561.method_43471((String)"container.double_stone_chest");
                }
            });
        }

        @NotNull
        public Optional<class_3908> acceptSingle(@NotNull class_2595 chestBlockEntity) {
            return Optional.of(chestBlockEntity);
        }

        @NotNull
        public Optional<class_3908> acceptNone() {
            return Optional.empty();
        }
    };

    public StoneChestBlock(@NotNull Supplier<class_2591<? extends class_2595>> supplier, @NotNull class_4970.class_2251 properties) {
        super(supplier, properties);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)SCULK, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean hasLid(@NotNull class_1937 level, @NotNull class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChest = (StoneChestBlockEntity)class_25862;
            return stoneChest.openProgress < 0.3f;
        }
        return false;
    }

    public static boolean canInteract(@NotNull class_1936 level, @NotNull class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChest = (StoneChestBlockEntity)class_25862;
            return !stoneChest.closing && stoneChest.cooldownTicks <= 0;
        }
        return true;
    }

    public static boolean hasLid(@NotNull class_1936 level, @NotNull class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChest = (StoneChestBlockEntity)class_25862;
            return stoneChest.openProgress < 0.3f;
        }
        return false;
    }

    public static boolean isStoneChestBlocked(@NotNull class_1936 level, @NotNull class_2338 pos) {
        if (StoneChestBlock.hasLid(level, pos)) {
            return true;
        }
        return class_2281.method_9756((class_1936)level, (class_2338)pos) || !StoneChestBlock.canInteract(level, pos);
    }

    public static boolean isStoneChestBlockedNoLid(@NotNull class_1936 level, @NotNull class_2338 pos) {
        return class_2281.method_9756((class_1936)level, (class_2338)pos) || !StoneChestBlock.canInteract(level, pos);
    }

    @NotNull
    public MapCodec<? extends StoneChestBlock> method_53969() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public class_1269 method_55766(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hit) {
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof StoneChestBlockEntity)) return class_1269.field_21466;
        StoneChestBlockEntity stoneChest = (StoneChestBlockEntity)class_25862;
        if (stoneChest.closing) {
            return class_1269.field_5814;
        }
        if (StoneChestBlock.canInteract((class_1936)level, pos)) {
            class_3908 namedScreenHandlerFactory = this.method_17454(state, level, pos);
            if (!(StoneChestBlock.hasLid(level, pos) || player.method_5715() && !(stoneChest.openProgress >= 0.5f) || namedScreenHandlerFactory == null)) {
                player.method_17355(namedScreenHandlerFactory);
                player.method_7259(this.method_9755());
                class_4838.method_24733((class_3218)((class_3218)level), (class_1657)player, (boolean)true);
            } else if (stoneChest.openProgress < 0.5f) {
                boolean first;
                class_3908 lidCheck = ((Optional)this.getBlockEntitySourceIgnoreLid(state, level, pos, false).apply(STONE_NAME_RETRIEVER)).orElse(null);
                boolean bl = first = stoneChest.openProgress == 0.0f;
                if (lidCheck == null) {
                    if (!(stoneChest.openProgress < 0.05f)) return class_1269.field_5811;
                    stoneChest.setLid(stoneChest.openProgress + 0.025f);
                } else {
                    stoneChest.liftLid(0.025f);
                }
                if (first) {
                    ((ChestBlockEntityInterface)((Object)stoneChest)).wilderWild$bubble(level, pos, state);
                    class_5321 lootTable = stoneChest.field_12037;
                    if (lootTable != null && state.method_28498((class_2769)class_2741.field_12508) && ((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && lootTable.method_29177().method_12832().toLowerCase().contains("shipwreck")) {
                        Jellyfish.spawnFromChest(level, state, pos, true);
                    }
                }
                StoneChestBlockEntity.playSound(level, pos, state, first ? WWSounds.BLOCK_STONE_CHEST_OPEN : WWSounds.BLOCK_STONE_CHEST_LIFT, first ? WWSounds.BLOCK_STONE_CHEST_OPEN_UNDERWATER : WWSounds.BLOCK_STONE_CHEST_LIFT_UNDERWATER, 0.35f);
                level.method_33596((class_1297)player, (class_6880)class_5712.field_28176, pos);
            }
        }
        Optional<StoneChestBlockEntity> possibleCoupledStoneChest = ChestUtil.getCoupledStoneChestBlockEntity((class_1936)level, pos, state);
        possibleCoupledStoneChest.ifPresent(otherStoneChest -> {
            if (otherStoneChest instanceof ChestBlockEntityInterface) {
                ChestBlockEntityInterface chestBlockEntityInterface = (ChestBlockEntityInterface)((Object)otherStoneChest);
                chestBlockEntityInterface.wilderWild$syncBubble(stoneChest, (class_2595)otherStoneChest);
            }
        });
        stoneChest.syncLidValuesAndUpdate(possibleCoupledStoneChest.orElse(null));
        return class_1269.field_21466;
    }

    @NotNull
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new StoneChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return level.field_9236 ? class_2237.method_31618(type, WWBlockEntityTypes.STONE_CHEST, StoneChestBlockEntity::clientStoneTick) : class_2237.method_31618(type, WWBlockEntityTypes.STONE_CHEST, StoneChestBlockEntity::serverStoneTick);
    }

    @Nullable
    public class_3908 method_17454(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos) {
        return ((Optional)this.method_24167(state, level, pos, false).apply(STONE_NAME_RETRIEVER)).orElse(null);
    }

    @NotNull
    public class_4732.class_4734<? extends class_2595> method_24167(@NotNull class_2680 state, @NotNull class_1937 level2, @NotNull class_2338 pos2, boolean ignoreBlocked) {
        BiPredicate<class_1936, class_2338> biPredicate = ignoreBlocked ? (level, pos) -> false : StoneChestBlock::isStoneChestBlocked;
        return class_4732.method_24173((class_2591)((class_2591)this.field_21796.get()), class_2281::method_24169, class_2281::method_9758, (class_2769)field_10768, (class_2680)state, (class_1936)level2, (class_2338)pos2, biPredicate);
    }

    @NotNull
    public class_4732.class_4734<? extends class_2595> getBlockEntitySourceIgnoreLid(class_2680 state, class_1937 level2, class_2338 pos2, boolean ignoreBlocked) {
        BiPredicate<class_1936, class_2338> biPredicate = ignoreBlocked ? (level, pos) -> false : StoneChestBlock::isStoneChestBlockedNoLid;
        return class_4732.method_24173((class_2591)((class_2591)this.field_21796.get()), class_2281::method_24169, class_2281::method_9758, (class_2769)field_10768, (class_2680)state, (class_1936)level2, (class_2338)pos2, biPredicate);
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 randomSource) {
        if (((Boolean)blockState.method_11654((class_2769)field_10772)).booleanValue()) {
            scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        class_2680 retState = blockState;
        if (neighborState.method_27852((class_2248)this) && direction.method_10166().method_10179()) {
            class_2745 chestType = (class_2745)neighborState.method_11654((class_2769)field_10770);
            if (blockState.method_11654((class_2769)field_10770) == class_2745.field_12569 && chestType != class_2745.field_12569 && blockState.method_11654((class_2769)field_10768) == neighborState.method_11654((class_2769)field_10768) && class_2281.method_9758((class_2680)neighborState) == direction.method_10153()) {
                retState = (class_2680)blockState.method_11657((class_2769)field_10770, (Comparable)chestType.method_11824());
            }
        } else {
            retState = class_2281.method_9758((class_2680)blockState) == direction ? (class_2680)blockState.method_11657((class_2769)field_10770, (Comparable)class_2745.field_12569) : super.method_9559(blockState, levelReader, scheduledTickAccess, blockPos, direction, neighborPos, neighborState, randomSource);
        }
        ChestUtil.updateBubbles(blockState, retState, levelReader, blockPos);
        return retState;
    }

    @NotNull
    public class_2680 method_9605(@NotNull class_1750 ctx) {
        class_2350 direction3;
        class_2745 chestType = class_2745.field_12569;
        class_1937 level = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2350 direction = ctx.method_8042().method_10153();
        class_3610 fluidState = ctx.method_8045().method_8316(pos);
        boolean secondaryUseActive = ctx.method_8046();
        class_2350 direction2 = ctx.method_8038();
        if (direction2.method_10166().method_10179() && secondaryUseActive && (direction3 = this.candidatePartnerFacing(ctx, direction2.method_10153())) != null && direction3.method_10166() != direction2.method_10166()) {
            direction = direction3;
            class_2745 class_27452 = chestType = direction.method_10160() == direction2.method_10153() ? class_2745.field_12571 : class_2745.field_12574;
        }
        if (chestType == class_2745.field_12569 && !secondaryUseActive) {
            if (direction == this.candidatePartnerFacing(ctx, direction.method_10170())) {
                chestType = class_2745.field_12574;
            } else if (direction == this.candidatePartnerFacing(ctx, direction.method_10160())) {
                chestType = class_2745.field_12571;
            }
        }
        class_2680 retState = (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_10768, (Comparable)direction)).method_11657((class_2769)field_10770, (Comparable)chestType)).method_11657((class_2769)field_10772, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        ChestUtil.getCoupledStoneChestBlockEntity((class_1936)level, pos, retState).ifPresent(coupledStoneChest -> {
            if (coupledStoneChest instanceof ChestBlockEntityInterface) {
                StoneChestBlockEntity chest;
                ChestBlockEntityInterface coupledStoneChestInterface = (ChestBlockEntityInterface)((Object)coupledStoneChest);
                class_2586 patt0$temp = level.method_8321(pos);
                if (patt0$temp instanceof StoneChestBlockEntity && (chest = (StoneChestBlockEntity)patt0$temp) instanceof ChestBlockEntityInterface) {
                    ChestBlockEntityInterface chestInterface = (ChestBlockEntityInterface)((Object)chest);
                    chestInterface.wilderWild$setCanBubble(coupledStoneChestInterface.wilderWild$getCanBubble());
                    chestInterface.wilderWild$syncBubble(chest, (class_2595)coupledStoneChest);
                }
            }
        });
        return retState;
    }

    @Nullable
    private class_2350 candidatePartnerFacing(@NotNull class_1750 ctx, @NotNull class_2350 dir) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037().method_10093(dir));
        return blockState.method_27852((class_2248)this) && blockState.method_11654((class_2769)field_10770) == class_2745.field_12569 ? (class_2350)blockState.method_11654((class_2769)field_10768) : null;
    }

    protected void method_66388(class_2680 state, @NotNull class_3218 level, class_2338 pos, boolean bl) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChest = (StoneChestBlockEntity)blockEntity;
            if (stoneChest instanceof ChestBlockEntityInterface) {
                ChestBlockEntityInterface stoneChestInterface = (ChestBlockEntityInterface)((Object)stoneChest);
                stoneChestInterface.wilderWild$bubbleBurst(state);
            }
            level.method_8455(pos, (class_2248)this);
        }
    }

    public boolean method_9498(@NotNull class_2680 state) {
        return true;
    }

    public int method_9572(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof StoneChestBlockEntity) {
            StoneChestBlockEntity stoneChestBlockEntity = (StoneChestBlockEntity)class_25862;
            return stoneChestBlockEntity.getComparatorOutput();
        }
        return 0;
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{SCULK});
    }
}

